'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../../utils/index.js');
var draggable = require('../draggable.js');
var pluginVue_exportHelper = require('../../../../_virtual/plugin-vue_export-helper.js');
var position = require('../../../../utils/dom/position.js');

const _sfc_main = vue.defineComponent({
  name: "ElSlPanel",
  props: {
    color: {
      type: Object,
      required: true
    }
  },
  setup(props) {
    const instance = vue.getCurrentInstance();
    const cursorTop = vue.ref(0);
    const cursorLeft = vue.ref(0);
    const background = vue.ref("hsl(0, 100%, 50%)");
    const colorValue = vue.computed(() => {
      const hue = props.color.get("hue");
      const value = props.color.get("value");
      return { hue, value };
    });
    function update() {
      const saturation = props.color.get("saturation");
      const value = props.color.get("value");
      const el = instance.vnode.el;
      const { clientWidth: width, clientHeight: height } = el;
      cursorLeft.value = saturation * width / 100;
      cursorTop.value = (100 - value) * height / 100;
      background.value = `hsl(${props.color.get("hue")}, 100%, 50%)`;
    }
    function handleDrag(event) {
      const el = instance.vnode.el;
      const rect = el.getBoundingClientRect();
      const { clientX, clientY } = position.getClientXY(event);
      let left = clientX - rect.left;
      let top = clientY - rect.top;
      left = Math.max(0, left);
      left = Math.min(left, rect.width);
      top = Math.max(0, top);
      top = Math.min(top, rect.height);
      cursorLeft.value = left;
      cursorTop.value = top;
      props.color.set({
        saturation: left / rect.width * 100,
        value: 100 - top / rect.height * 100
      });
    }
    vue.watch(() => colorValue.value, () => {
      update();
    });
    vue.onMounted(() => {
      draggable["default"](instance.vnode.el, {
        drag: (event) => {
          handleDrag(event);
        },
        end: (event) => {
          handleDrag(event);
        }
      });
      update();
    });
    return {
      cursorTop,
      cursorLeft,
      background,
      colorValue,
      handleDrag,
      update
    };
  }
});
const _hoisted_1 = /* @__PURE__ */ vue.createElementVNode("div", { class: "el-color-svpanel__white" }, null, -1);
const _hoisted_2 = /* @__PURE__ */ vue.createElementVNode("div", { class: "el-color-svpanel__black" }, null, -1);
const _hoisted_3 = /* @__PURE__ */ vue.createElementVNode("div", null, null, -1);
const _hoisted_4 = [
  _hoisted_3
];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createElementBlock("div", {
    class: "el-color-svpanel",
    style: vue.normalizeStyle({
      backgroundColor: _ctx.background
    })
  }, [
    _hoisted_1,
    _hoisted_2,
    vue.createElementVNode("div", {
      class: "el-color-svpanel__cursor",
      style: vue.normalizeStyle({
        top: _ctx.cursorTop + "px",
        left: _ctx.cursorLeft + "px"
      })
    }, _hoisted_4, 4)
  ], 4);
}
var SvPanel = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render]]);

exports["default"] = SvPanel;
//# sourceMappingURL=sv-panel.js.map
