'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var index = require('../../icon/index.js');
require('../../../utils/index.js');
require('../../../tokens/index.js');
var dialogContent = require('./dialog-content.js');
var icon = require('../../../utils/vue/icon.js');
var dialog = require('../../../tokens/dialog.js');

const _hoisted_1 = ["aria-label"];
const __default__ = { name: "ElDialogContent" };
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: dialogContent.dialogContentProps,
  emits: dialogContent.dialogContentEmits,
  setup(__props) {
    const { Close } = icon.CloseComponents;
    const { dialogRef, headerRef, ns, style } = vue.inject(dialog.dialogInjectionKey);
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        ref_key: "dialogRef",
        ref: dialogRef,
        class: vue.normalizeClass([
          vue.unref(ns).b(),
          vue.unref(ns).is("fullscreen", _ctx.fullscreen),
          vue.unref(ns).is("draggable", _ctx.draggable),
          { [vue.unref(ns).m("center")]: _ctx.center },
          _ctx.customClass
        ]),
        "aria-modal": "true",
        role: "dialog",
        "aria-label": _ctx.title || "dialog",
        style: vue.normalizeStyle(vue.unref(style)),
        onClick: _cache[1] || (_cache[1] = vue.withModifiers(() => {
        }, ["stop"]))
      }, [
        vue.createElementVNode("div", {
          ref_key: "headerRef",
          ref: headerRef,
          class: vue.normalizeClass(vue.unref(ns).e("header"))
        }, [
          vue.renderSlot(_ctx.$slots, "title", {}, () => [
            vue.createElementVNode("span", {
              class: vue.normalizeClass(vue.unref(ns).e("title"))
            }, vue.toDisplayString(_ctx.title), 3)
          ])
        ], 2),
        vue.createElementVNode("div", {
          class: vue.normalizeClass(vue.unref(ns).e("body"))
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2),
        _ctx.$slots.footer ? (vue.openBlock(), vue.createElementBlock("div", {
          key: 0,
          class: vue.normalizeClass(vue.unref(ns).e("footer"))
        }, [
          vue.renderSlot(_ctx.$slots, "footer")
        ], 2)) : vue.createCommentVNode("v-if", true),
        _ctx.showClose ? (vue.openBlock(), vue.createElementBlock("button", {
          key: 1,
          "aria-label": "close",
          class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
          type: "button",
          onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("close"))
        }, [
          vue.createVNode(vue.unref(index.ElIcon), {
            class: vue.normalizeClass(vue.unref(ns).e("close"))
          }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.closeIcon || vue.unref(Close))))
            ]),
            _: 1
          }, 8, ["class"])
        ], 2)) : vue.createCommentVNode("v-if", true)
      ], 14, _hoisted_1);
    };
  }
});

exports["default"] = _sfc_main;
//# sourceMappingURL=dialog-content2.js.map
