'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var AsyncValidator = require('async-validator');
var lodashUnified = require('lodash-unified');
require('../../../utils/index.js');
require('../../../tokens/index.js');
require('../../../hooks/index.js');
var formItem = require('./form-item.js');
var formLabelWrap = require('./form-label-wrap.js');
var form = require('../../../tokens/form.js');
var error = require('../../../utils/error.js');
var index = require('../../../hooks/use-common-props/index.js');
var index$1 = require('../../../hooks/use-namespace/index.js');
var style = require('../../../utils/vue/style.js');
var core = require('@vueuse/core');
var shared = require('@vue/shared');
var objects = require('../../../utils/objects.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var AsyncValidator__default = /*#__PURE__*/_interopDefaultLegacy(AsyncValidator);

const _hoisted_1 = ["for"];
const __default__ = {
  name: "ElFormItem"
};
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: formItem.formItemProps,
  setup(__props, { expose }) {
    const props = __props;
    const COMPONENT_NAME = "ElFormItem";
    const slots = vue.useSlots();
    const formContext = vue.inject(form.formContextKey);
    if (!formContext)
      error.throwError(COMPONENT_NAME, "usage: <el-form><el-form-item /></el-form>");
    const parentFormItemContext = vue.inject(form.formItemContextKey, void 0);
    const _size = index.useSize(void 0, { formItem: false });
    const ns = index$1.useNamespace("form-item");
    const validateState = vue.ref("");
    const validateMessage = vue.ref("");
    const formItemRef = vue.ref();
    let initialValue = void 0;
    const labelStyle = vue.computed(() => {
      if (formContext.labelPosition === "top") {
        return {};
      }
      const labelWidth = style.addUnit(props.labelWidth || formContext.labelWidth || "");
      if (labelWidth)
        return { width: labelWidth };
      return {};
    });
    const contentStyle = vue.computed(() => {
      if (formContext.labelPosition === "top" || formContext.inline) {
        return {};
      }
      if (!props.label && !props.labelWidth && isNested) {
        return {};
      }
      const labelWidth = style.addUnit(props.labelWidth || formContext.labelWidth || "");
      if (!props.label && !slots.label) {
        return { marginLeft: labelWidth };
      }
      return {};
    });
    const formItemClasses = vue.computed(() => [
      ns.b(),
      ns.m(_size.value),
      ns.is("error", validateState.value === "error"),
      ns.is("validating", validateState.value === "validating"),
      ns.is("success", validateState.value === "success"),
      ns.is("required", isRequired.value || props.required),
      ns.is("no-asterisk", formContext.hideRequiredAsterisk),
      { [ns.m("feedback")]: formContext.statusIcon }
    ]);
    const _inlineMessage = vue.computed(() => core.isBoolean(props.inlineMessage) ? props.inlineMessage : formContext.inlineMessage || false);
    const validateClasses = vue.computed(() => [
      ns.e("error"),
      { [ns.em("error", "inline")]: _inlineMessage.value }
    ]);
    const propString = vue.computed(() => {
      if (!props.prop)
        return "";
      return shared.isString(props.prop) ? props.prop : props.prop.join(".");
    });
    const labelFor = vue.computed(() => props.for || propString.value);
    const isNested = !!parentFormItemContext;
    const fieldValue = vue.computed(() => {
      const model = formContext.model;
      if (!model || !props.prop) {
        return;
      }
      return objects.getProp(model, props.prop).value;
    });
    const _rules = vue.computed(() => {
      const rules = props.rules ? lodashUnified.castArray(props.rules) : [];
      const formRules = formContext.rules;
      if (formRules && props.prop) {
        const _rules2 = objects.getProp(formRules, props.prop).value;
        if (_rules2) {
          rules.push(...lodashUnified.castArray(_rules2));
        }
      }
      if (props.required !== void 0) {
        rules.push({ required: !!props.required });
      }
      return rules;
    });
    const validateEnabled = vue.computed(() => _rules.value.length > 0);
    const getFilteredRule = (trigger) => {
      const rules = _rules.value;
      return rules.filter((rule) => {
        if (!rule.trigger || !trigger)
          return true;
        if (Array.isArray(rule.trigger)) {
          return rule.trigger.includes(trigger);
        } else {
          return rule.trigger === trigger;
        }
      }).map(({ trigger: trigger2, ...rule }) => rule);
    };
    const isRequired = vue.computed(() => _rules.value.some((rule) => rule.required === true));
    const shouldShowError = vue.computed(() => validateState.value === "error" && props.showMessage && formContext.showMessage);
    const currentLabel = vue.computed(() => `${props.label || ""}${formContext.labelSuffix || ""}`);
    const validate = async (trigger, callback) => {
      if (callback) {
        try {
          validate(trigger);
          callback(true);
        } catch (err) {
          callback(false, err);
        }
        validate(trigger).then(() => callback(true)).catch((fields) => callback(false, fields));
        return;
      }
      if (!validateEnabled.value) {
        return;
      }
      const rules = getFilteredRule(trigger);
      if (rules.length === 0) {
        return;
      }
      validateState.value = "validating";
      const descriptor = {
        [propString.value]: rules
      };
      const validator = new AsyncValidator__default["default"](descriptor);
      const model = {
        [propString.value]: fieldValue.value
      };
      return validator.validate(model, { firstFields: true }).then(() => void 0).catch((err) => {
        const { errors, fields } = err;
        if (!errors || !fields)
          console.error(err);
        validateState.value = "error";
        validateMessage.value = errors ? errors[0].message || `${props.prop} is required` : "";
        formContext.emit("validate", props.prop, !errors, validateMessage.value);
        return Promise.reject(fields);
      });
    };
    const clearValidate = () => {
      validateState.value = "";
      validateMessage.value = "";
    };
    const resetField = () => {
      const model = formContext.model;
      if (!model || !props.prop)
        return;
      objects.getProp(model, props.prop).value = initialValue;
      vue.nextTick(() => clearValidate());
    };
    vue.watch(() => props.error, (val) => {
      validateMessage.value = val || "";
      validateState.value = val ? "error" : "";
    }, { immediate: true });
    vue.watch(() => props.validateStatus, (val) => validateState.value = val || "");
    const context = vue.reactive({
      ...vue.toRefs(props),
      $el: formItemRef,
      size: _size,
      validateState,
      resetField,
      clearValidate,
      validate
    });
    vue.provide(form.formItemContextKey, context);
    vue.onMounted(() => {
      if (props.prop) {
        formContext.addField(context);
        initialValue = lodashUnified.clone(fieldValue.value);
      }
    });
    vue.onBeforeUnmount(() => {
      formContext.removeField(context);
    });
    expose({
      size: _size,
      validateMessage,
      validate,
      clearValidate,
      resetField
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        ref_key: "formItemRef",
        ref: formItemRef,
        class: vue.normalizeClass(vue.unref(formItemClasses))
      }, [
        vue.createVNode(vue.unref(formLabelWrap["default"]), {
          "is-auto-width": vue.unref(labelStyle).width === "auto",
          "update-all": vue.unref(formContext).labelWidth === "auto"
        }, {
          default: vue.withCtx(() => [
            _ctx.label || _ctx.$slots.label ? (vue.openBlock(), vue.createElementBlock("label", {
              key: 0,
              for: vue.unref(labelFor),
              class: vue.normalizeClass(vue.unref(ns).e("label")),
              style: vue.normalizeStyle(vue.unref(labelStyle))
            }, [
              vue.renderSlot(_ctx.$slots, "label", { label: vue.unref(currentLabel) }, () => [
                vue.createTextVNode(vue.toDisplayString(vue.unref(currentLabel)), 1)
              ])
            ], 14, _hoisted_1)) : vue.createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["is-auto-width", "update-all"]),
        vue.createElementVNode("div", {
          class: vue.normalizeClass(vue.unref(ns).e("content")),
          style: vue.normalizeStyle(vue.unref(contentStyle))
        }, [
          vue.renderSlot(_ctx.$slots, "default"),
          vue.createVNode(vue.Transition, {
            name: `${vue.unref(ns).namespace.value}-zoom-in-top`
          }, {
            default: vue.withCtx(() => [
              vue.unref(shouldShowError) ? vue.renderSlot(_ctx.$slots, "error", {
                key: 0,
                error: validateMessage.value
              }, () => [
                vue.createElementVNode("div", {
                  class: vue.normalizeClass(vue.unref(validateClasses))
                }, vue.toDisplayString(validateMessage.value), 3)
              ]) : vue.createCommentVNode("v-if", true)
            ]),
            _: 3
          }, 8, ["name"])
        ], 6)
      ], 2);
    };
  }
});

exports["default"] = _sfc_main;
//# sourceMappingURL=form-item2.js.map
