'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../utils/index.js');
require('../../../tokens/index.js');
require('../../../hooks/index.js');
var form = require('./form.js');
var utils = require('./utils.js');
var index = require('../../../hooks/use-common-props/index.js');
var index$1 = require('../../../hooks/use-namespace/index.js');
var error = require('../../../utils/error.js');
var form$1 = require('../../../tokens/form.js');

const __default__ = {
  name: "ElForm"
};
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: form.formProps,
  emits: form.formEmits,
  setup(__props, { expose, emit }) {
    const props = __props;
    const COMPONENT_NAME = "ElForm";
    const fields = [];
    const formSize = index.useSize();
    const ns = index$1.useNamespace("form");
    const formClasses = vue.computed(() => {
      const { labelPosition, inline } = props;
      return [
        ns.b(),
        ns.m(formSize.value),
        {
          [ns.m(`label-${labelPosition}`)]: labelPosition,
          [ns.m("inline")]: inline
        }
      ];
    });
    const addField = (field) => {
      fields.push(field);
    };
    const removeField = (field) => {
      if (!field.prop) {
        fields.splice(fields.indexOf(field), 1);
      }
    };
    const resetFields = (properties = []) => {
      if (!props.model) {
        error.debugWarn(COMPONENT_NAME, "model is required for resetFields to work.");
        return;
      }
      utils.filterFields(fields, properties).forEach((field) => field.resetField());
    };
    const clearValidate = (props2 = []) => {
      utils.filterFields(fields, props2).forEach((field) => field.clearValidate());
    };
    const validate = async (callback) => validateField(void 0, callback);
    const validateField = async (properties = [], callback) => {
      if (callback) {
        validate().then(() => callback(true)).catch((fields2) => callback(false, fields2));
        return;
      }
      const { model, scrollToError } = props;
      if (!model) {
        error.debugWarn(COMPONENT_NAME, "model is required for form validation!");
        return;
      }
      if (fields.length === 0) {
        return;
      }
      const filteredFields = utils.filterFields(fields, properties);
      if (!filteredFields.length) {
        error.debugWarn(COMPONENT_NAME, "please pass correct props!");
        return;
      }
      let valid = true;
      let invalidFields = {};
      let firstInvalidFields;
      for (const field of filteredFields) {
        const fieldsError = await field.validate("").catch((fields2) => fields2);
        if (fieldsError) {
          valid = false;
          if (!firstInvalidFields)
            firstInvalidFields = fieldsError;
        }
        invalidFields = { ...invalidFields, ...fieldsError };
      }
      if (!valid) {
        if (scrollToError)
          scrollToField(Object.keys(firstInvalidFields)[0]);
        return Promise.reject(invalidFields);
      }
    };
    const scrollToField = (prop) => {
      var _a;
      const field = utils.filterFields(fields, prop)[0];
      if (field) {
        (_a = field.$el) == null ? void 0 : _a.scrollIntoView();
      }
    };
    vue.watch(() => props.rules, () => {
      if (props.validateOnRuleChange)
        validate();
    }, { deep: true });
    vue.provide(form$1.formContextKey, vue.reactive({
      ...vue.toRefs(props),
      emit,
      resetFields,
      clearValidate,
      validateField,
      addField,
      removeField,
      ...utils.useFormLabelWidth()
    }));
    expose({
      validate,
      validateField,
      resetFields,
      clearValidate,
      scrollToField
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("form", {
        class: vue.normalizeClass(vue.unref(formClasses))
      }, [
        vue.renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});

exports["default"] = _sfc_main;
//# sourceMappingURL=form2.js.map
