import type { PropType } from 'vue';
import type { Action, MessageBoxState, MessageBoxType } from './message-box.type';
declare const _default: import("vue").DefineComponent<{
    buttonSize: {
        type: PropType<"default" | "small" | "large">;
        validator: (val: string) => val is "" | "default" | "small" | "large";
    };
    modal: {
        type: BooleanConstructor;
        default: boolean;
    };
    lockScroll: {
        type: BooleanConstructor;
        default: boolean;
    };
    showClose: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnClickModal: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnPressEscape: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnHashChange: {
        type: BooleanConstructor;
        default: boolean;
    };
    center: BooleanConstructor;
    draggable: BooleanConstructor;
    roundButton: {
        default: boolean;
        type: BooleanConstructor;
    };
    container: {
        type: StringConstructor;
        default: string;
    };
    boxType: {
        type: PropType<MessageBoxType>;
        default: string;
    };
}, {
    overlayEvent: {
        onClick: (e: MouseEvent) => void;
        onMousedown: (e: MouseEvent) => void;
        onMouseup: (e: MouseEvent) => void;
    };
    visible: import("vue").Ref<boolean>;
    hasMessage: import("vue").ComputedRef<boolean>;
    typeClass: import("vue").ComputedRef<string>;
    btnSize: import("vue").ComputedRef<"default" | "small" | "large">;
    iconComponent: import("vue").ComputedRef<any>;
    confirmButtonClasses: import("vue").ComputedRef<string>;
    rootRef: import("vue").Ref<HTMLElement | undefined>;
    headerRef: import("vue").Ref<HTMLElement | undefined>;
    inputRef: import("vue").Ref<HTMLElement | undefined>;
    confirmRef: import("vue").Ref<HTMLElement | undefined>;
    doClose: () => void;
    handleClose: () => void;
    handleWrapperClick: () => void;
    handleInputEnter: () => void;
    handleAction: (action: Action) => void;
    t: import("element-plus/es/hooks").Translator;
    title: import("vue").Ref<string>;
    message: import("vue").Ref<string>;
    type: import("vue").Ref<"" | "success" | "warning" | "info" | "error">;
    icon: import("vue").Ref<string | import("vue").FunctionalComponent<any, any> | {
        new (...args: any[]): any;
        __isFragment?: undefined;
        __isTeleport?: undefined;
        __isSuspense?: undefined;
    } | {
        [x: string]: any;
        setup?: ((this: void, props: Readonly<import("@vue/shared").LooseRequired<any>>, ctx: import("vue").SetupContext<any>) => any) | undefined;
        name?: string | undefined;
        template?: string | object | undefined;
        render?: Function | undefined;
        components?: {
            [x: string]: import("vue").FunctionalComponent<any, any> | {
                new (...args: any[]): any;
                __isFragment?: undefined;
                __isTeleport?: undefined;
                __isSuspense?: undefined;
            } | any;
        } | undefined;
        directives?: {
            [x: string]: import("vue").FunctionDirective<any, any> | {
                created?: import("vue").DirectiveHook<any, null, any> | undefined;
                beforeMount?: import("vue").DirectiveHook<any, null, any> | undefined;
                mounted?: import("vue").DirectiveHook<any, null, any> | undefined;
                beforeUpdate?: import("vue").DirectiveHook<any, import("vue").VNode<any, any, {
                    [key: string]: any;
                }>, any> | undefined;
                updated?: import("vue").DirectiveHook<any, import("vue").VNode<any, any, {
                    [key: string]: any;
                }>, any> | undefined;
                beforeUnmount?: import("vue").DirectiveHook<any, null, any> | undefined;
                unmounted?: import("vue").DirectiveHook<any, null, any> | undefined;
                getSSRProps?: ((binding: import("vue").DirectiveBinding<any>, vnode: import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
                    [key: string]: any;
                }>) => {
                    [x: string]: unknown;
                } | undefined) | undefined;
                deep?: boolean | undefined;
            };
        } | undefined;
        inheritAttrs?: boolean | undefined;
        emits?: any;
        expose?: string[] | undefined;
        serverPrefetch?: (() => Promise<any>) | undefined;
        compilerOptions?: {
            isCustomElement?: ((tag: string) => boolean) | undefined;
            whitespace?: "preserve" | "condense" | undefined;
            comments?: boolean | undefined;
            delimiters?: [string, string] | undefined;
        } | undefined;
        call?: ((this: unknown, ...args: unknown[]) => never) | undefined;
        __isFragment?: undefined;
        __isTeleport?: undefined;
        __isSuspense?: undefined;
        __defaults?: {} | undefined;
        compatConfig?: {
            GLOBAL_MOUNT?: boolean | "suppress-warning" | undefined;
            GLOBAL_MOUNT_CONTAINER?: boolean | "suppress-warning" | undefined;
            GLOBAL_EXTEND?: boolean | "suppress-warning" | undefined;
            GLOBAL_PROTOTYPE?: boolean | "suppress-warning" | undefined;
            GLOBAL_SET?: boolean | "suppress-warning" | undefined;
            GLOBAL_DELETE?: boolean | "suppress-warning" | undefined;
            GLOBAL_OBSERVABLE?: boolean | "suppress-warning" | undefined;
            GLOBAL_PRIVATE_UTIL?: boolean | "suppress-warning" | undefined;
            CONFIG_SILENT?: boolean | "suppress-warning" | undefined;
            CONFIG_DEVTOOLS?: boolean | "suppress-warning" | undefined;
            CONFIG_KEY_CODES?: boolean | "suppress-warning" | undefined;
            CONFIG_PRODUCTION_TIP?: boolean | "suppress-warning" | undefined;
            CONFIG_IGNORED_ELEMENTS?: boolean | "suppress-warning" | undefined;
            CONFIG_WHITESPACE?: boolean | "suppress-warning" | undefined;
            CONFIG_OPTION_MERGE_STRATS?: boolean | "suppress-warning" | undefined;
            INSTANCE_SET?: boolean | "suppress-warning" | undefined;
            INSTANCE_DELETE?: boolean | "suppress-warning" | undefined;
            INSTANCE_DESTROY?: boolean | "suppress-warning" | undefined;
            INSTANCE_EVENT_EMITTER?: boolean | "suppress-warning" | undefined;
            INSTANCE_EVENT_HOOKS?: boolean | "suppress-warning" | undefined;
            INSTANCE_CHILDREN?: boolean | "suppress-warning" | undefined;
            INSTANCE_LISTENERS?: boolean | "suppress-warning" | undefined;
            INSTANCE_SCOPED_SLOTS?: boolean | "suppress-warning" | undefined;
            INSTANCE_ATTRS_CLASS_STYLE?: boolean | "suppress-warning" | undefined;
            OPTIONS_DATA_FN?: boolean | "suppress-warning" | undefined;
            OPTIONS_DATA_MERGE?: boolean | "suppress-warning" | undefined;
            OPTIONS_BEFORE_DESTROY?: boolean | "suppress-warning" | undefined;
            OPTIONS_DESTROYED?: boolean | "suppress-warning" | undefined;
            WATCH_ARRAY?: boolean | "suppress-warning" | undefined;
            PROPS_DEFAULT_THIS?: boolean | "suppress-warning" | undefined;
            V_ON_KEYCODE_MODIFIER?: boolean | "suppress-warning" | undefined;
            CUSTOM_DIR?: boolean | "suppress-warning" | undefined;
            ATTR_FALSE_VALUE?: boolean | "suppress-warning" | undefined;
            ATTR_ENUMERATED_COERCION?: boolean | "suppress-warning" | undefined;
            TRANSITION_CLASSES?: boolean | "suppress-warning" | undefined;
            TRANSITION_GROUP_ROOT?: boolean | "suppress-warning" | undefined;
            COMPONENT_ASYNC?: boolean | "suppress-warning" | undefined;
            COMPONENT_FUNCTIONAL?: boolean | "suppress-warning" | undefined;
            COMPONENT_V_MODEL?: boolean | "suppress-warning" | undefined;
            RENDER_FUNCTION?: boolean | "suppress-warning" | undefined;
            FILTERS?: boolean | "suppress-warning" | undefined;
            PRIVATE_APIS?: boolean | "suppress-warning" | undefined;
            MODE?: 3 | 2 | ((comp: import("vue").Component<any, any, any, import("vue").ComputedOptions, import("vue").MethodOptions> | null) => 3 | 2) | undefined;
        } | undefined;
        data?: ((this: any, vm: any) => any) | undefined;
        computed?: {
            [x: string]: import("vue").ComputedGetter<any> | {
                get: import("vue").ComputedGetter<any>;
                set: import("vue").ComputedSetter<any>;
            };
        } | undefined;
        methods?: {
            [x: string]: Function;
        } | undefined;
        watch?: {
            [x: string]: string | import("vue").WatchCallback<any, any> | {
                handler: string | import("vue").WatchCallback<any, any>;
                immediate?: boolean | undefined;
                deep?: boolean | undefined;
                flush?: "pre" | "post" | "sync" | undefined;
                onTrack?: ((event: import("vue").DebuggerEvent) => void) | undefined;
                onTrigger?: ((event: import("vue").DebuggerEvent) => void) | undefined;
            } | (string | import("vue").WatchCallback<any, any> | {
                handler: string | import("vue").WatchCallback<any, any>;
                immediate?: boolean | undefined;
                deep?: boolean | undefined;
                flush?: "pre" | "post" | "sync" | undefined;
                onTrack?: ((event: import("vue").DebuggerEvent) => void) | undefined;
                onTrigger?: ((event: import("vue").DebuggerEvent) => void) | undefined;
            })[];
        } | undefined;
        provide?: Function | {
            [x: string]: unknown;
        } | undefined;
        inject?: string[] | {
            [x: string]: string | symbol | {
                from?: string | symbol | undefined;
                default?: unknown;
            };
            [x: symbol]: string | symbol | {
                from?: string | symbol | undefined;
                default?: unknown;
            };
        } | undefined;
        filters?: {
            [x: string]: Function;
        } | undefined;
        mixins?: any[] | undefined;
        extends?: any;
        beforeCreate?: (() => void) | undefined;
        created?: (() => void) | undefined;
        beforeMount?: (() => void) | undefined;
        mounted?: (() => void) | undefined;
        beforeUpdate?: (() => void) | undefined;
        updated?: (() => void) | undefined;
        activated?: (() => void) | undefined;
        deactivated?: (() => void) | undefined;
        beforeDestroy?: (() => void) | undefined;
        beforeUnmount?: (() => void) | undefined;
        destroyed?: (() => void) | undefined;
        unmounted?: (() => void) | undefined;
        renderTracked?: ((e: import("vue").DebuggerEvent) => void) | undefined;
        renderTriggered?: ((e: import("vue").DebuggerEvent) => void) | undefined;
        errorCaptured?: ((err: unknown, instance: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>> | null, info: string) => boolean | void) | undefined;
        delimiters?: [string, string] | undefined;
        __differentiator?: string | number | symbol | undefined;
        __isBuiltIn?: boolean | undefined;
        __file?: string | undefined;
        beforeRouteEnter?: import("vue-router").NavigationGuardWithThis<undefined> | undefined;
        beforeRouteUpdate?: import("vue-router").NavigationGuard | undefined;
        beforeRouteLeave?: import("vue-router").NavigationGuard | undefined;
    }>;
    customClass: import("vue").Ref<string>;
    customStyle: import("vue").Ref<{
        accentColor?: string | undefined;
        alignContent?: string | undefined;
        alignItems?: string | undefined;
        alignSelf?: string | undefined;
        alignTracks?: string | undefined;
        animationDelay?: string | undefined;
        animationDirection?: string | undefined;
        animationDuration?: string | undefined;
        animationFillMode?: string | undefined;
        animationIterationCount?: import("csstype").AnimationIterationCountProperty | undefined;
        animationName?: string | undefined;
        animationPlayState?: string | undefined;
        animationTimingFunction?: string | undefined;
        appearance?: import("csstype").AppearanceProperty | undefined;
        aspectRatio?: string | undefined;
        backdropFilter?: string | undefined;
        backfaceVisibility?: import("csstype").BackfaceVisibilityProperty | undefined;
        backgroundAttachment?: string | undefined;
        backgroundBlendMode?: string | undefined;
        backgroundClip?: string | undefined;
        backgroundColor?: string | undefined;
        backgroundImage?: string | undefined;
        backgroundOrigin?: string | undefined;
        backgroundPositionX?: import("csstype").BackgroundPositionXProperty<string | number> | undefined;
        backgroundPositionY?: import("csstype").BackgroundPositionYProperty<string | number> | undefined;
        backgroundRepeat?: string | undefined;
        backgroundSize?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        blockOverflow?: string | undefined;
        blockSize?: import("csstype").BlockSizeProperty<string | number> | undefined;
        borderBlockColor?: string | undefined;
        borderBlockEndColor?: string | undefined;
        borderBlockEndStyle?: import("csstype").BorderBlockEndStyleProperty | undefined;
        borderBlockEndWidth?: import("csstype").BorderBlockEndWidthProperty<string | number> | undefined;
        borderBlockStartColor?: string | undefined;
        borderBlockStartStyle?: import("csstype").BorderBlockStartStyleProperty | undefined;
        borderBlockStartWidth?: import("csstype").BorderBlockStartWidthProperty<string | number> | undefined;
        borderBlockStyle?: import("csstype").BorderBlockStyleProperty | undefined;
        borderBlockWidth?: import("csstype").BorderBlockWidthProperty<string | number> | undefined;
        borderBottomColor?: string | undefined;
        borderBottomLeftRadius?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        borderBottomRightRadius?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        borderBottomStyle?: import("csstype").BorderBottomStyleProperty | undefined;
        borderBottomWidth?: import("csstype").BorderBottomWidthProperty<string | number> | undefined;
        borderCollapse?: import("csstype").BorderCollapseProperty | undefined;
        borderEndEndRadius?: import("csstype").BorderEndEndRadiusProperty<string | number> | undefined;
        borderEndStartRadius?: import("csstype").BorderEndStartRadiusProperty<string | number> | undefined;
        borderImageOutset?: import("csstype").BorderImageOutsetProperty<string | number> | undefined;
        borderImageRepeat?: string | undefined;
        borderImageSlice?: import("csstype").BorderImageSliceProperty | undefined;
        borderImageSource?: string | undefined;
        borderImageWidth?: import("csstype").BorderImageWidthProperty<string | number> | undefined;
        borderInlineColor?: string | undefined;
        borderInlineEndColor?: string | undefined;
        borderInlineEndStyle?: import("csstype").BorderInlineEndStyleProperty | undefined;
        borderInlineEndWidth?: import("csstype").BorderInlineEndWidthProperty<string | number> | undefined;
        borderInlineStartColor?: string | undefined;
        borderInlineStartStyle?: import("csstype").BorderInlineStartStyleProperty | undefined;
        borderInlineStartWidth?: import("csstype").BorderInlineStartWidthProperty<string | number> | undefined;
        borderInlineStyle?: import("csstype").BorderInlineStyleProperty | undefined;
        borderInlineWidth?: import("csstype").BorderInlineWidthProperty<string | number> | undefined;
        borderLeftColor?: string | undefined;
        borderLeftStyle?: import("csstype").BorderLeftStyleProperty | undefined;
        borderLeftWidth?: import("csstype").BorderLeftWidthProperty<string | number> | undefined;
        borderRightColor?: string | undefined;
        borderRightStyle?: import("csstype").BorderRightStyleProperty | undefined;
        borderRightWidth?: import("csstype").BorderRightWidthProperty<string | number> | undefined;
        borderSpacing?: import("csstype").BorderSpacingProperty<string | number> | undefined;
        borderStartEndRadius?: import("csstype").BorderStartEndRadiusProperty<string | number> | undefined;
        borderStartStartRadius?: import("csstype").BorderStartStartRadiusProperty<string | number> | undefined;
        borderTopColor?: string | undefined;
        borderTopLeftRadius?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        borderTopRightRadius?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        borderTopStyle?: import("csstype").BorderTopStyleProperty | undefined;
        borderTopWidth?: import("csstype").BorderTopWidthProperty<string | number> | undefined;
        bottom?: import("csstype").BottomProperty<string | number> | undefined;
        boxDecorationBreak?: import("csstype").BoxDecorationBreakProperty | undefined;
        boxShadow?: string | undefined;
        boxSizing?: import("csstype").BoxSizingProperty | undefined;
        breakAfter?: import("csstype").BreakAfterProperty | undefined;
        breakBefore?: import("csstype").BreakBeforeProperty | undefined;
        breakInside?: import("csstype").BreakInsideProperty | undefined;
        captionSide?: import("csstype").CaptionSideProperty | undefined;
        caretColor?: string | undefined;
        clear?: import("csstype").ClearProperty | undefined;
        clipPath?: string | undefined;
        color?: string | undefined;
        colorAdjust?: import("csstype").ColorAdjustProperty | undefined;
        colorScheme?: string | undefined;
        columnCount?: import("csstype").ColumnCountProperty | undefined;
        columnFill?: import("csstype").ColumnFillProperty | undefined;
        columnGap?: import("csstype").ColumnGapProperty<string | number> | undefined;
        columnRuleColor?: string | undefined;
        columnRuleStyle?: string | undefined;
        columnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        columnSpan?: import("csstype").ColumnSpanProperty | undefined;
        columnWidth?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        contain?: string | undefined;
        content?: string | undefined;
        contentVisibility?: import("csstype").ContentVisibilityProperty | undefined;
        counterIncrement?: string | undefined;
        counterReset?: string | undefined;
        counterSet?: string | undefined;
        cursor?: string | undefined;
        direction?: import("csstype").DirectionProperty | undefined;
        display?: string | undefined;
        emptyCells?: import("csstype").EmptyCellsProperty | undefined;
        filter?: string | undefined;
        flexBasis?: import("csstype").FlexBasisProperty<string | number> | undefined;
        flexDirection?: import("csstype").FlexDirectionProperty | undefined;
        flexGrow?: import("csstype").GlobalsNumber | undefined;
        flexShrink?: import("csstype").GlobalsNumber | undefined;
        flexWrap?: import("csstype").FlexWrapProperty | undefined;
        float?: import("csstype").FloatProperty | undefined;
        fontFamily?: string | undefined;
        fontFeatureSettings?: string | undefined;
        fontKerning?: import("csstype").FontKerningProperty | undefined;
        fontLanguageOverride?: string | undefined;
        fontOpticalSizing?: import("csstype").FontOpticalSizingProperty | undefined;
        fontSize?: import("csstype").FontSizeProperty<string | number> | undefined;
        fontSizeAdjust?: import("csstype").FontSizeAdjustProperty | undefined;
        fontSmooth?: import("csstype").FontSmoothProperty<string | number> | undefined;
        fontStretch?: string | undefined;
        fontStyle?: string | undefined;
        fontSynthesis?: string | undefined;
        fontVariant?: string | undefined;
        fontVariantCaps?: import("csstype").FontVariantCapsProperty | undefined;
        fontVariantEastAsian?: string | undefined;
        fontVariantLigatures?: string | undefined;
        fontVariantNumeric?: string | undefined;
        fontVariantPosition?: import("csstype").FontVariantPositionProperty | undefined;
        fontVariationSettings?: string | undefined;
        fontWeight?: import("csstype").FontWeightProperty | undefined;
        forcedColorAdjust?: import("csstype").ForcedColorAdjustProperty | undefined;
        gridAutoColumns?: import("csstype").GridAutoColumnsProperty<string | number> | undefined;
        gridAutoFlow?: string | undefined;
        gridAutoRows?: import("csstype").GridAutoRowsProperty<string | number> | undefined;
        gridColumnEnd?: import("csstype").GridColumnEndProperty | undefined;
        gridColumnStart?: import("csstype").GridColumnStartProperty | undefined;
        gridRowEnd?: import("csstype").GridRowEndProperty | undefined;
        gridRowStart?: import("csstype").GridRowStartProperty | undefined;
        gridTemplateAreas?: string | undefined;
        gridTemplateColumns?: import("csstype").GridTemplateColumnsProperty<string | number> | undefined;
        gridTemplateRows?: import("csstype").GridTemplateRowsProperty<string | number> | undefined;
        hangingPunctuation?: string | undefined;
        height?: import("csstype").HeightProperty<string | number> | undefined;
        hyphens?: import("csstype").HyphensProperty | undefined;
        imageOrientation?: string | undefined;
        imageRendering?: import("csstype").ImageRenderingProperty | undefined;
        imageResolution?: string | undefined;
        initialLetter?: import("csstype").InitialLetterProperty | undefined;
        inlineSize?: import("csstype").InlineSizeProperty<string | number> | undefined;
        inset?: import("csstype").InsetProperty<string | number> | undefined;
        insetBlock?: import("csstype").InsetBlockProperty<string | number> | undefined;
        insetBlockEnd?: import("csstype").InsetBlockEndProperty<string | number> | undefined;
        insetBlockStart?: import("csstype").InsetBlockStartProperty<string | number> | undefined;
        insetInline?: import("csstype").InsetInlineProperty<string | number> | undefined;
        insetInlineEnd?: import("csstype").InsetInlineEndProperty<string | number> | undefined;
        insetInlineStart?: import("csstype").InsetInlineStartProperty<string | number> | undefined;
        isolation?: import("csstype").IsolationProperty | undefined;
        justifyContent?: string | undefined;
        justifyItems?: string | undefined;
        justifySelf?: string | undefined;
        justifyTracks?: string | undefined;
        left?: import("csstype").LeftProperty<string | number> | undefined;
        letterSpacing?: import("csstype").LetterSpacingProperty<string | number> | undefined;
        lineBreak?: import("csstype").LineBreakProperty | undefined;
        lineHeight?: import("csstype").LineHeightProperty<string | number> | undefined;
        lineHeightStep?: import("csstype").LineHeightStepProperty<string | number> | undefined;
        listStyleImage?: string | undefined;
        listStylePosition?: import("csstype").ListStylePositionProperty | undefined;
        listStyleType?: string | undefined;
        marginBlock?: import("csstype").MarginBlockProperty<string | number> | undefined;
        marginBlockEnd?: import("csstype").MarginBlockEndProperty<string | number> | undefined;
        marginBlockStart?: import("csstype").MarginBlockStartProperty<string | number> | undefined;
        marginBottom?: import("csstype").MarginBottomProperty<string | number> | undefined;
        marginInline?: import("csstype").MarginInlineProperty<string | number> | undefined;
        marginInlineEnd?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        marginInlineStart?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        marginLeft?: import("csstype").MarginLeftProperty<string | number> | undefined;
        marginRight?: import("csstype").MarginRightProperty<string | number> | undefined;
        marginTop?: import("csstype").MarginTopProperty<string | number> | undefined;
        maskBorderMode?: import("csstype").MaskBorderModeProperty | undefined;
        maskBorderOutset?: import("csstype").MaskBorderOutsetProperty<string | number> | undefined;
        maskBorderRepeat?: string | undefined;
        maskBorderSlice?: import("csstype").MaskBorderSliceProperty | undefined;
        maskBorderSource?: string | undefined;
        maskBorderWidth?: import("csstype").MaskBorderWidthProperty<string | number> | undefined;
        maskClip?: string | undefined;
        maskComposite?: string | undefined;
        maskImage?: string | undefined;
        maskMode?: string | undefined;
        maskOrigin?: string | undefined;
        maskPosition?: import("csstype").MaskPositionProperty<string | number> | undefined;
        maskRepeat?: string | undefined;
        maskSize?: import("csstype").MaskSizeProperty<string | number> | undefined;
        maskType?: import("csstype").MaskTypeProperty | undefined;
        mathStyle?: import("csstype").MathStyleProperty | undefined;
        maxBlockSize?: import("csstype").MaxBlockSizeProperty<string | number> | undefined;
        maxHeight?: import("csstype").MaxHeightProperty<string | number> | undefined;
        maxInlineSize?: import("csstype").MaxInlineSizeProperty<string | number> | undefined;
        maxLines?: import("csstype").MaxLinesProperty | undefined;
        maxWidth?: import("csstype").MaxWidthProperty<string | number> | undefined;
        minBlockSize?: import("csstype").MinBlockSizeProperty<string | number> | undefined;
        minHeight?: import("csstype").MinHeightProperty<string | number> | undefined;
        minInlineSize?: import("csstype").MinInlineSizeProperty<string | number> | undefined;
        minWidth?: import("csstype").MinWidthProperty<string | number> | undefined;
        mixBlendMode?: import("csstype").MixBlendModeProperty | undefined;
        motionDistance?: import("csstype").OffsetDistanceProperty<string | number> | undefined;
        motionPath?: string | undefined;
        motionRotation?: string | undefined;
        objectFit?: import("csstype").ObjectFitProperty | undefined;
        objectPosition?: import("csstype").ObjectPositionProperty<string | number> | undefined;
        offsetAnchor?: import("csstype").OffsetAnchorProperty<string | number> | undefined;
        offsetDistance?: import("csstype").OffsetDistanceProperty<string | number> | undefined;
        offsetPath?: string | undefined;
        offsetRotate?: string | undefined;
        offsetRotation?: string | undefined;
        opacity?: import("csstype").OpacityProperty | undefined;
        order?: import("csstype").GlobalsNumber | undefined;
        orphans?: import("csstype").GlobalsNumber | undefined;
        outlineColor?: string | undefined;
        outlineOffset?: import("csstype").OutlineOffsetProperty<string | number> | undefined;
        outlineStyle?: string | undefined;
        outlineWidth?: import("csstype").OutlineWidthProperty<string | number> | undefined;
        overflowAnchor?: import("csstype").OverflowAnchorProperty | undefined;
        overflowBlock?: import("csstype").OverflowBlockProperty | undefined;
        overflowClipBox?: import("csstype").OverflowClipBoxProperty | undefined;
        overflowClipMargin?: import("csstype").OverflowClipMarginProperty<string | number> | undefined;
        overflowInline?: import("csstype").OverflowInlineProperty | undefined;
        overflowWrap?: import("csstype").OverflowWrapProperty | undefined;
        overflowX?: import("csstype").OverflowXProperty | undefined;
        overflowY?: import("csstype").OverflowYProperty | undefined;
        overscrollBehaviorBlock?: import("csstype").OverscrollBehaviorBlockProperty | undefined;
        overscrollBehaviorInline?: import("csstype").OverscrollBehaviorInlineProperty | undefined;
        overscrollBehaviorX?: import("csstype").OverscrollBehaviorXProperty | undefined;
        overscrollBehaviorY?: import("csstype").OverscrollBehaviorYProperty | undefined;
        paddingBlock?: import("csstype").PaddingBlockProperty<string | number> | undefined;
        paddingBlockEnd?: import("csstype").PaddingBlockEndProperty<string | number> | undefined;
        paddingBlockStart?: import("csstype").PaddingBlockStartProperty<string | number> | undefined;
        paddingBottom?: import("csstype").PaddingBottomProperty<string | number> | undefined;
        paddingInline?: import("csstype").PaddingInlineProperty<string | number> | undefined;
        paddingInlineEnd?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        paddingInlineStart?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        paddingLeft?: import("csstype").PaddingLeftProperty<string | number> | undefined;
        paddingRight?: import("csstype").PaddingRightProperty<string | number> | undefined;
        paddingTop?: import("csstype").PaddingTopProperty<string | number> | undefined;
        pageBreakAfter?: import("csstype").PageBreakAfterProperty | undefined;
        pageBreakBefore?: import("csstype").PageBreakBeforeProperty | undefined;
        pageBreakInside?: import("csstype").PageBreakInsideProperty | undefined;
        paintOrder?: string | undefined;
        perspective?: import("csstype").PerspectiveProperty<string | number> | undefined;
        perspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        placeContent?: string | undefined;
        pointerEvents?: import("csstype").PointerEventsProperty | undefined;
        position?: import("csstype").PositionProperty | undefined;
        quotes?: string | undefined;
        resize?: import("csstype").ResizeProperty | undefined;
        right?: import("csstype").RightProperty<string | number> | undefined;
        rotate?: string | undefined;
        rowGap?: import("csstype").RowGapProperty<string | number> | undefined;
        rubyAlign?: import("csstype").RubyAlignProperty | undefined;
        rubyMerge?: import("csstype").RubyMergeProperty | undefined;
        rubyPosition?: string | undefined;
        scale?: import("csstype").ScaleProperty | undefined;
        scrollBehavior?: import("csstype").ScrollBehaviorProperty | undefined;
        scrollMargin?: import("csstype").ScrollMarginProperty<string | number> | undefined;
        scrollMarginBlock?: import("csstype").ScrollMarginBlockProperty<string | number> | undefined;
        scrollMarginBlockEnd?: import("csstype").ScrollMarginBlockEndProperty<string | number> | undefined;
        scrollMarginBlockStart?: import("csstype").ScrollMarginBlockStartProperty<string | number> | undefined;
        scrollMarginBottom?: import("csstype").ScrollMarginBottomProperty<string | number> | undefined;
        scrollMarginInline?: import("csstype").ScrollMarginInlineProperty<string | number> | undefined;
        scrollMarginInlineEnd?: import("csstype").ScrollMarginInlineEndProperty<string | number> | undefined;
        scrollMarginInlineStart?: import("csstype").ScrollMarginInlineStartProperty<string | number> | undefined;
        scrollMarginLeft?: import("csstype").ScrollMarginLeftProperty<string | number> | undefined;
        scrollMarginRight?: import("csstype").ScrollMarginRightProperty<string | number> | undefined;
        scrollMarginTop?: import("csstype").ScrollMarginTopProperty<string | number> | undefined;
        scrollPadding?: import("csstype").ScrollPaddingProperty<string | number> | undefined;
        scrollPaddingBlock?: import("csstype").ScrollPaddingBlockProperty<string | number> | undefined;
        scrollPaddingBlockEnd?: import("csstype").ScrollPaddingBlockEndProperty<string | number> | undefined;
        scrollPaddingBlockStart?: import("csstype").ScrollPaddingBlockStartProperty<string | number> | undefined;
        scrollPaddingBottom?: import("csstype").ScrollPaddingBottomProperty<string | number> | undefined;
        scrollPaddingInline?: import("csstype").ScrollPaddingInlineProperty<string | number> | undefined;
        scrollPaddingInlineEnd?: import("csstype").ScrollPaddingInlineEndProperty<string | number> | undefined;
        scrollPaddingInlineStart?: import("csstype").ScrollPaddingInlineStartProperty<string | number> | undefined;
        scrollPaddingLeft?: import("csstype").ScrollPaddingLeftProperty<string | number> | undefined;
        scrollPaddingRight?: import("csstype").ScrollPaddingRightProperty<string | number> | undefined;
        scrollPaddingTop?: import("csstype").ScrollPaddingTopProperty<string | number> | undefined;
        scrollSnapAlign?: string | undefined;
        scrollSnapMargin?: import("csstype").ScrollMarginProperty<string | number> | undefined;
        scrollSnapMarginBottom?: import("csstype").ScrollMarginBottomProperty<string | number> | undefined;
        scrollSnapMarginLeft?: import("csstype").ScrollMarginLeftProperty<string | number> | undefined;
        scrollSnapMarginRight?: import("csstype").ScrollMarginRightProperty<string | number> | undefined;
        scrollSnapMarginTop?: import("csstype").ScrollMarginTopProperty<string | number> | undefined;
        scrollSnapStop?: import("csstype").ScrollSnapStopProperty | undefined;
        scrollSnapType?: string | undefined;
        scrollbarColor?: string | undefined;
        scrollbarGutter?: string | undefined;
        scrollbarWidth?: import("csstype").ScrollbarWidthProperty | undefined;
        shapeImageThreshold?: import("csstype").ShapeImageThresholdProperty | undefined;
        shapeMargin?: import("csstype").ShapeMarginProperty<string | number> | undefined;
        shapeOutside?: string | undefined;
        tabSize?: import("csstype").TabSizeProperty<string | number> | undefined;
        tableLayout?: import("csstype").TableLayoutProperty | undefined;
        textAlign?: import("csstype").TextAlignProperty | undefined;
        textAlignLast?: import("csstype").TextAlignLastProperty | undefined;
        textCombineUpright?: string | undefined;
        textDecorationColor?: string | undefined;
        textDecorationLine?: string | undefined;
        textDecorationSkip?: string | undefined;
        textDecorationSkipInk?: import("csstype").TextDecorationSkipInkProperty | undefined;
        textDecorationStyle?: import("csstype").TextDecorationStyleProperty | undefined;
        textDecorationThickness?: import("csstype").TextDecorationThicknessProperty<string | number> | undefined;
        textDecorationWidth?: import("csstype").TextDecorationThicknessProperty<string | number> | undefined;
        textEmphasisColor?: string | undefined;
        textEmphasisPosition?: string | undefined;
        textEmphasisStyle?: string | undefined;
        textIndent?: import("csstype").TextIndentProperty<string | number> | undefined;
        textJustify?: import("csstype").TextJustifyProperty | undefined;
        textOrientation?: import("csstype").TextOrientationProperty | undefined;
        textOverflow?: string | undefined;
        textRendering?: import("csstype").TextRenderingProperty | undefined;
        textShadow?: string | undefined;
        textSizeAdjust?: string | undefined;
        textTransform?: import("csstype").TextTransformProperty | undefined;
        textUnderlineOffset?: import("csstype").TextUnderlineOffsetProperty<string | number> | undefined;
        textUnderlinePosition?: string | undefined;
        top?: import("csstype").TopProperty<string | number> | undefined;
        touchAction?: string | undefined;
        transform?: string | undefined;
        transformBox?: import("csstype").TransformBoxProperty | undefined;
        transformOrigin?: import("csstype").TransformOriginProperty<string | number> | undefined;
        transformStyle?: import("csstype").TransformStyleProperty | undefined;
        transitionDelay?: string | undefined;
        transitionDuration?: string | undefined;
        transitionProperty?: string | undefined;
        transitionTimingFunction?: string | undefined;
        translate?: import("csstype").TranslateProperty<string | number> | undefined;
        unicodeBidi?: import("csstype").UnicodeBidiProperty | undefined;
        userSelect?: import("csstype").UserSelectProperty | undefined;
        verticalAlign?: import("csstype").VerticalAlignProperty<string | number> | undefined;
        visibility?: import("csstype").VisibilityProperty | undefined;
        whiteSpace?: import("csstype").WhiteSpaceProperty | undefined;
        widows?: import("csstype").GlobalsNumber | undefined;
        width?: import("csstype").WidthProperty<string | number> | undefined;
        willChange?: string | undefined;
        wordBreak?: import("csstype").WordBreakProperty | undefined;
        wordSpacing?: import("csstype").WordSpacingProperty<string | number> | undefined;
        wordWrap?: import("csstype").WordWrapProperty | undefined;
        writingMode?: import("csstype").WritingModeProperty | undefined;
        zIndex?: import("csstype").ZIndexProperty | undefined;
        zoom?: import("csstype").ZoomProperty | undefined;
        all?: import("csstype").Globals | undefined;
        animation?: import("csstype").AnimationProperty | undefined;
        background?: import("csstype").BackgroundProperty<string | number> | undefined;
        backgroundPosition?: import("csstype").BackgroundPositionProperty<string | number> | undefined;
        border?: import("csstype").BorderProperty<string | number> | undefined;
        borderBlock?: import("csstype").BorderBlockProperty<string | number> | undefined;
        borderBlockEnd?: import("csstype").BorderBlockEndProperty<string | number> | undefined;
        borderBlockStart?: import("csstype").BorderBlockStartProperty<string | number> | undefined;
        borderBottom?: import("csstype").BorderBottomProperty<string | number> | undefined;
        borderColor?: string | undefined;
        borderImage?: import("csstype").BorderImageProperty | undefined;
        borderInline?: import("csstype").BorderInlineProperty<string | number> | undefined;
        borderInlineEnd?: import("csstype").BorderInlineEndProperty<string | number> | undefined;
        borderInlineStart?: import("csstype").BorderInlineStartProperty<string | number> | undefined;
        borderLeft?: import("csstype").BorderLeftProperty<string | number> | undefined;
        borderRadius?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        borderRight?: import("csstype").BorderRightProperty<string | number> | undefined;
        borderStyle?: string | undefined;
        borderTop?: import("csstype").BorderTopProperty<string | number> | undefined;
        borderWidth?: import("csstype").BorderWidthProperty<string | number> | undefined;
        columnRule?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        columns?: import("csstype").ColumnsProperty<string | number> | undefined;
        flex?: import("csstype").FlexProperty<string | number> | undefined;
        flexFlow?: string | undefined;
        font?: string | undefined;
        gap?: import("csstype").GapProperty<string | number> | undefined;
        grid?: string | undefined;
        gridArea?: import("csstype").GridAreaProperty | undefined;
        gridColumn?: import("csstype").GridColumnProperty | undefined;
        gridRow?: import("csstype").GridRowProperty | undefined;
        gridTemplate?: string | undefined;
        lineClamp?: import("csstype").LineClampProperty | undefined;
        listStyle?: string | undefined;
        margin?: import("csstype").MarginProperty<string | number> | undefined;
        mask?: import("csstype").MaskProperty<string | number> | undefined;
        maskBorder?: import("csstype").MaskBorderProperty | undefined;
        motion?: import("csstype").OffsetProperty<string | number> | undefined;
        offset?: import("csstype").OffsetProperty<string | number> | undefined;
        outline?: import("csstype").OutlineProperty<string | number> | undefined;
        overflow?: string | undefined;
        overscrollBehavior?: string | undefined;
        padding?: import("csstype").PaddingProperty<string | number> | undefined;
        placeItems?: string | undefined;
        placeSelf?: string | undefined;
        textDecoration?: import("csstype").TextDecorationProperty<string | number> | undefined;
        textEmphasis?: string | undefined;
        transition?: string | undefined;
        MozAnimationDelay?: string | undefined;
        MozAnimationDirection?: string | undefined;
        MozAnimationDuration?: string | undefined;
        MozAnimationFillMode?: string | undefined;
        MozAnimationIterationCount?: import("csstype").AnimationIterationCountProperty | undefined;
        MozAnimationName?: string | undefined;
        MozAnimationPlayState?: string | undefined;
        MozAnimationTimingFunction?: string | undefined;
        MozAppearance?: import("csstype").MozAppearanceProperty | undefined;
        MozBackfaceVisibility?: import("csstype").BackfaceVisibilityProperty | undefined;
        MozBorderBottomColors?: string | undefined;
        MozBorderEndColor?: string | undefined;
        MozBorderEndStyle?: import("csstype").BorderInlineEndStyleProperty | undefined;
        MozBorderEndWidth?: import("csstype").BorderInlineEndWidthProperty<string | number> | undefined;
        MozBorderLeftColors?: string | undefined;
        MozBorderRightColors?: string | undefined;
        MozBorderStartColor?: string | undefined;
        MozBorderStartStyle?: import("csstype").BorderInlineStartStyleProperty | undefined;
        MozBorderTopColors?: string | undefined;
        MozBoxSizing?: import("csstype").BoxSizingProperty | undefined;
        MozColumnCount?: import("csstype").ColumnCountProperty | undefined;
        MozColumnFill?: import("csstype").ColumnFillProperty | undefined;
        MozColumnGap?: import("csstype").ColumnGapProperty<string | number> | undefined;
        MozColumnRuleColor?: string | undefined;
        MozColumnRuleStyle?: string | undefined;
        MozColumnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        MozColumnWidth?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        MozContextProperties?: string | undefined;
        MozFontFeatureSettings?: string | undefined;
        MozFontLanguageOverride?: string | undefined;
        MozHyphens?: import("csstype").HyphensProperty | undefined;
        MozImageRegion?: string | undefined;
        MozMarginEnd?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        MozMarginStart?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        MozOrient?: import("csstype").MozOrientProperty | undefined;
        MozOsxFontSmoothing?: import("csstype").FontSmoothProperty<string | number> | undefined;
        MozPaddingEnd?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        MozPaddingStart?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        MozPerspective?: import("csstype").PerspectiveProperty<string | number> | undefined;
        MozPerspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        MozStackSizing?: import("csstype").MozStackSizingProperty | undefined;
        MozTabSize?: import("csstype").TabSizeProperty<string | number> | undefined;
        MozTextBlink?: import("csstype").MozTextBlinkProperty | undefined;
        MozTextSizeAdjust?: string | undefined;
        MozTransformOrigin?: import("csstype").TransformOriginProperty<string | number> | undefined;
        MozTransformStyle?: import("csstype").TransformStyleProperty | undefined;
        MozTransitionDelay?: string | undefined;
        MozTransitionDuration?: string | undefined;
        MozTransitionProperty?: string | undefined;
        MozTransitionTimingFunction?: string | undefined;
        MozUserFocus?: import("csstype").MozUserFocusProperty | undefined;
        MozUserModify?: import("csstype").MozUserModifyProperty | undefined;
        MozUserSelect?: import("csstype").UserSelectProperty | undefined;
        MozWindowDragging?: import("csstype").MozWindowDraggingProperty | undefined;
        MozWindowShadow?: import("csstype").MozWindowShadowProperty | undefined;
        msAccelerator?: import("csstype").MsAcceleratorProperty | undefined;
        msAlignSelf?: string | undefined;
        msBlockProgression?: import("csstype").MsBlockProgressionProperty | undefined;
        msContentZoomChaining?: import("csstype").MsContentZoomChainingProperty | undefined;
        msContentZoomLimitMax?: string | undefined;
        msContentZoomLimitMin?: string | undefined;
        msContentZoomSnapPoints?: string | undefined;
        msContentZoomSnapType?: import("csstype").MsContentZoomSnapTypeProperty | undefined;
        msContentZooming?: import("csstype").MsContentZoomingProperty | undefined;
        msFilter?: string | undefined;
        msFlexDirection?: import("csstype").FlexDirectionProperty | undefined;
        msFlexPositive?: import("csstype").GlobalsNumber | undefined;
        msFlowFrom?: string | undefined;
        msFlowInto?: string | undefined;
        msGridColumns?: import("csstype").MsGridColumnsProperty<string | number> | undefined;
        msGridRows?: import("csstype").MsGridRowsProperty<string | number> | undefined;
        msHighContrastAdjust?: import("csstype").MsHighContrastAdjustProperty | undefined;
        msHyphenateLimitChars?: import("csstype").MsHyphenateLimitCharsProperty | undefined;
        msHyphenateLimitLines?: import("csstype").MsHyphenateLimitLinesProperty | undefined;
        msHyphenateLimitZone?: import("csstype").MsHyphenateLimitZoneProperty<string | number> | undefined;
        msHyphens?: import("csstype").HyphensProperty | undefined;
        msImeAlign?: import("csstype").MsImeAlignProperty | undefined;
        msJustifySelf?: string | undefined;
        msLineBreak?: import("csstype").LineBreakProperty | undefined;
        msOrder?: import("csstype").GlobalsNumber | undefined;
        msOverflowStyle?: import("csstype").MsOverflowStyleProperty | undefined;
        msOverflowX?: import("csstype").OverflowXProperty | undefined;
        msOverflowY?: import("csstype").OverflowYProperty | undefined;
        msScrollChaining?: import("csstype").MsScrollChainingProperty | undefined;
        msScrollLimitXMax?: import("csstype").MsScrollLimitXMaxProperty<string | number> | undefined;
        msScrollLimitXMin?: import("csstype").MsScrollLimitXMinProperty<string | number> | undefined;
        msScrollLimitYMax?: import("csstype").MsScrollLimitYMaxProperty<string | number> | undefined;
        msScrollLimitYMin?: import("csstype").MsScrollLimitYMinProperty<string | number> | undefined;
        msScrollRails?: import("csstype").MsScrollRailsProperty | undefined;
        msScrollSnapPointsX?: string | undefined;
        msScrollSnapPointsY?: string | undefined;
        msScrollSnapType?: import("csstype").MsScrollSnapTypeProperty | undefined;
        msScrollTranslation?: import("csstype").MsScrollTranslationProperty | undefined;
        msScrollbar3dlightColor?: string | undefined;
        msScrollbarArrowColor?: string | undefined;
        msScrollbarBaseColor?: string | undefined;
        msScrollbarDarkshadowColor?: string | undefined;
        msScrollbarFaceColor?: string | undefined;
        msScrollbarHighlightColor?: string | undefined;
        msScrollbarShadowColor?: string | undefined;
        msTextAutospace?: import("csstype").MsTextAutospaceProperty | undefined;
        msTextCombineHorizontal?: string | undefined;
        msTextOverflow?: string | undefined;
        msTouchAction?: string | undefined;
        msTouchSelect?: import("csstype").MsTouchSelectProperty | undefined;
        msTransform?: string | undefined;
        msTransformOrigin?: import("csstype").TransformOriginProperty<string | number> | undefined;
        msTransitionDelay?: string | undefined;
        msTransitionDuration?: string | undefined;
        msTransitionProperty?: string | undefined;
        msTransitionTimingFunction?: string | undefined;
        msUserSelect?: import("csstype").MsUserSelectProperty | undefined;
        msWordBreak?: import("csstype").WordBreakProperty | undefined;
        msWrapFlow?: import("csstype").MsWrapFlowProperty | undefined;
        msWrapMargin?: import("csstype").MsWrapMarginProperty<string | number> | undefined;
        msWrapThrough?: import("csstype").MsWrapThroughProperty | undefined;
        msWritingMode?: import("csstype").WritingModeProperty | undefined;
        WebkitAlignContent?: string | undefined;
        WebkitAlignItems?: string | undefined;
        WebkitAlignSelf?: string | undefined;
        WebkitAnimationDelay?: string | undefined;
        WebkitAnimationDirection?: string | undefined;
        WebkitAnimationDuration?: string | undefined;
        WebkitAnimationFillMode?: string | undefined;
        WebkitAnimationIterationCount?: import("csstype").AnimationIterationCountProperty | undefined;
        WebkitAnimationName?: string | undefined;
        WebkitAnimationPlayState?: string | undefined;
        WebkitAnimationTimingFunction?: string | undefined;
        WebkitAppearance?: import("csstype").WebkitAppearanceProperty | undefined;
        WebkitBackdropFilter?: string | undefined;
        WebkitBackfaceVisibility?: import("csstype").BackfaceVisibilityProperty | undefined;
        WebkitBackgroundClip?: string | undefined;
        WebkitBackgroundOrigin?: string | undefined;
        WebkitBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        WebkitBorderBeforeColor?: string | undefined;
        WebkitBorderBeforeStyle?: string | undefined;
        WebkitBorderBeforeWidth?: import("csstype").WebkitBorderBeforeWidthProperty<string | number> | undefined;
        WebkitBorderBottomLeftRadius?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        WebkitBorderBottomRightRadius?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        WebkitBorderImageSlice?: import("csstype").BorderImageSliceProperty | undefined;
        WebkitBorderTopLeftRadius?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        WebkitBorderTopRightRadius?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        WebkitBoxDecorationBreak?: import("csstype").BoxDecorationBreakProperty | undefined;
        WebkitBoxReflect?: import("csstype").WebkitBoxReflectProperty<string | number> | undefined;
        WebkitBoxShadow?: string | undefined;
        WebkitBoxSizing?: import("csstype").BoxSizingProperty | undefined;
        WebkitClipPath?: string | undefined;
        WebkitColumnCount?: import("csstype").ColumnCountProperty | undefined;
        WebkitColumnFill?: import("csstype").ColumnFillProperty | undefined;
        WebkitColumnGap?: import("csstype").ColumnGapProperty<string | number> | undefined;
        WebkitColumnRuleColor?: string | undefined;
        WebkitColumnRuleStyle?: string | undefined;
        WebkitColumnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        WebkitColumnSpan?: import("csstype").ColumnSpanProperty | undefined;
        WebkitColumnWidth?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        WebkitFilter?: string | undefined;
        WebkitFlexBasis?: import("csstype").FlexBasisProperty<string | number> | undefined;
        WebkitFlexDirection?: import("csstype").FlexDirectionProperty | undefined;
        WebkitFlexGrow?: import("csstype").GlobalsNumber | undefined;
        WebkitFlexShrink?: import("csstype").GlobalsNumber | undefined;
        WebkitFlexWrap?: import("csstype").FlexWrapProperty | undefined;
        WebkitFontFeatureSettings?: string | undefined;
        WebkitFontKerning?: import("csstype").FontKerningProperty | undefined;
        WebkitFontSmoothing?: import("csstype").FontSmoothProperty<string | number> | undefined;
        WebkitFontVariantLigatures?: string | undefined;
        WebkitHyphens?: import("csstype").HyphensProperty | undefined;
        WebkitInitialLetter?: import("csstype").InitialLetterProperty | undefined;
        WebkitJustifyContent?: string | undefined;
        WebkitLineBreak?: import("csstype").LineBreakProperty | undefined;
        WebkitLineClamp?: import("csstype").WebkitLineClampProperty | undefined;
        WebkitMarginEnd?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        WebkitMarginStart?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        WebkitMaskAttachment?: string | undefined;
        WebkitMaskBoxImageOutset?: import("csstype").MaskBorderOutsetProperty<string | number> | undefined;
        WebkitMaskBoxImageRepeat?: string | undefined;
        WebkitMaskBoxImageSlice?: import("csstype").MaskBorderSliceProperty | undefined;
        WebkitMaskBoxImageSource?: string | undefined;
        WebkitMaskBoxImageWidth?: import("csstype").MaskBorderWidthProperty<string | number> | undefined;
        WebkitMaskClip?: string | undefined;
        WebkitMaskComposite?: string | undefined;
        WebkitMaskImage?: string | undefined;
        WebkitMaskOrigin?: string | undefined;
        WebkitMaskPosition?: import("csstype").WebkitMaskPositionProperty<string | number> | undefined;
        WebkitMaskPositionX?: import("csstype").WebkitMaskPositionXProperty<string | number> | undefined;
        WebkitMaskPositionY?: import("csstype").WebkitMaskPositionYProperty<string | number> | undefined;
        WebkitMaskRepeat?: string | undefined;
        WebkitMaskRepeatX?: import("csstype").WebkitMaskRepeatXProperty | undefined;
        WebkitMaskRepeatY?: import("csstype").WebkitMaskRepeatYProperty | undefined;
        WebkitMaskSize?: import("csstype").WebkitMaskSizeProperty<string | number> | undefined;
        WebkitMaxInlineSize?: import("csstype").MaxInlineSizeProperty<string | number> | undefined;
        WebkitOrder?: import("csstype").GlobalsNumber | undefined;
        WebkitOverflowScrolling?: import("csstype").WebkitOverflowScrollingProperty | undefined;
        WebkitPaddingEnd?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        WebkitPaddingStart?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        WebkitPerspective?: import("csstype").PerspectiveProperty<string | number> | undefined;
        WebkitPerspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        WebkitPrintColorAdjust?: import("csstype").ColorAdjustProperty | undefined;
        WebkitRubyPosition?: string | undefined;
        WebkitScrollSnapType?: string | undefined;
        WebkitShapeMargin?: import("csstype").ShapeMarginProperty<string | number> | undefined;
        WebkitTapHighlightColor?: string | undefined;
        WebkitTextCombine?: string | undefined;
        WebkitTextDecorationColor?: string | undefined;
        WebkitTextDecorationLine?: string | undefined;
        WebkitTextDecorationSkip?: string | undefined;
        WebkitTextDecorationStyle?: import("csstype").TextDecorationStyleProperty | undefined;
        WebkitTextEmphasisColor?: string | undefined;
        WebkitTextEmphasisPosition?: string | undefined;
        WebkitTextEmphasisStyle?: string | undefined;
        WebkitTextFillColor?: string | undefined;
        WebkitTextOrientation?: import("csstype").TextOrientationProperty | undefined;
        WebkitTextSizeAdjust?: string | undefined;
        WebkitTextStrokeColor?: string | undefined;
        WebkitTextStrokeWidth?: import("csstype").WebkitTextStrokeWidthProperty<string | number> | undefined;
        WebkitTextUnderlinePosition?: string | undefined;
        WebkitTouchCallout?: import("csstype").WebkitTouchCalloutProperty | undefined;
        WebkitTransform?: string | undefined;
        WebkitTransformOrigin?: import("csstype").TransformOriginProperty<string | number> | undefined;
        WebkitTransformStyle?: import("csstype").TransformStyleProperty | undefined;
        WebkitTransitionDelay?: string | undefined;
        WebkitTransitionDuration?: string | undefined;
        WebkitTransitionProperty?: string | undefined;
        WebkitTransitionTimingFunction?: string | undefined;
        WebkitUserModify?: import("csstype").WebkitUserModifyProperty | undefined;
        WebkitUserSelect?: import("csstype").UserSelectProperty | undefined;
        WebkitWritingMode?: import("csstype").WritingModeProperty | undefined;
        MozAnimation?: import("csstype").AnimationProperty | undefined;
        MozBorderImage?: import("csstype").BorderImageProperty | undefined;
        MozColumnRule?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        MozColumns?: import("csstype").ColumnsProperty<string | number> | undefined;
        MozTransition?: string | undefined;
        msContentZoomLimit?: string | undefined;
        msContentZoomSnap?: string | undefined;
        msFlex?: import("csstype").FlexProperty<string | number> | undefined;
        msScrollLimit?: string | undefined;
        msScrollSnapX?: string | undefined;
        msScrollSnapY?: string | undefined;
        msTransition?: string | undefined;
        WebkitAnimation?: import("csstype").AnimationProperty | undefined;
        WebkitBorderBefore?: import("csstype").WebkitBorderBeforeProperty<string | number> | undefined;
        WebkitBorderImage?: import("csstype").BorderImageProperty | undefined;
        WebkitBorderRadius?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        WebkitColumnRule?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        WebkitColumns?: import("csstype").ColumnsProperty<string | number> | undefined;
        WebkitFlex?: import("csstype").FlexProperty<string | number> | undefined;
        WebkitFlexFlow?: string | undefined;
        WebkitMask?: import("csstype").WebkitMaskProperty<string | number> | undefined;
        WebkitMaskBoxImage?: import("csstype").MaskBorderProperty | undefined;
        WebkitTextEmphasis?: string | undefined;
        WebkitTextStroke?: import("csstype").WebkitTextStrokeProperty<string | number> | undefined;
        WebkitTransition?: string | undefined;
        azimuth?: string | undefined;
        boxAlign?: import("csstype").BoxAlignProperty | undefined;
        boxDirection?: import("csstype").BoxDirectionProperty | undefined;
        boxFlex?: import("csstype").GlobalsNumber | undefined;
        boxFlexGroup?: import("csstype").GlobalsNumber | undefined;
        boxLines?: import("csstype").BoxLinesProperty | undefined;
        boxOrdinalGroup?: import("csstype").GlobalsNumber | undefined;
        boxOrient?: import("csstype").BoxOrientProperty | undefined;
        boxPack?: import("csstype").BoxPackProperty | undefined;
        clip?: string | undefined;
        fontVariantAlternates?: string | undefined;
        gridColumnGap?: import("csstype").GridColumnGapProperty<string | number> | undefined;
        gridGap?: import("csstype").GridGapProperty<string | number> | undefined;
        gridRowGap?: import("csstype").GridRowGapProperty<string | number> | undefined;
        imeMode?: import("csstype").ImeModeProperty | undefined;
        offsetBlock?: import("csstype").InsetBlockProperty<string | number> | undefined;
        offsetBlockEnd?: import("csstype").InsetBlockEndProperty<string | number> | undefined;
        offsetBlockStart?: import("csstype").InsetBlockStartProperty<string | number> | undefined;
        offsetInline?: import("csstype").InsetInlineProperty<string | number> | undefined;
        offsetInlineEnd?: import("csstype").InsetInlineEndProperty<string | number> | undefined;
        offsetInlineStart?: import("csstype").InsetInlineStartProperty<string | number> | undefined;
        scrollSnapCoordinate?: import("csstype").ScrollSnapCoordinateProperty<string | number> | undefined;
        scrollSnapDestination?: import("csstype").ScrollSnapDestinationProperty<string | number> | undefined;
        scrollSnapPointsX?: string | undefined;
        scrollSnapPointsY?: string | undefined;
        scrollSnapTypeX?: import("csstype").ScrollSnapTypeXProperty | undefined;
        scrollSnapTypeY?: import("csstype").ScrollSnapTypeYProperty | undefined;
        scrollbarTrackColor?: string | undefined;
        KhtmlBoxAlign?: import("csstype").BoxAlignProperty | undefined;
        KhtmlBoxDirection?: import("csstype").BoxDirectionProperty | undefined;
        KhtmlBoxFlex?: import("csstype").GlobalsNumber | undefined;
        KhtmlBoxFlexGroup?: import("csstype").GlobalsNumber | undefined;
        KhtmlBoxLines?: import("csstype").BoxLinesProperty | undefined;
        KhtmlBoxOrdinalGroup?: import("csstype").GlobalsNumber | undefined;
        KhtmlBoxOrient?: import("csstype").BoxOrientProperty | undefined;
        KhtmlBoxPack?: import("csstype").BoxPackProperty | undefined;
        KhtmlLineBreak?: import("csstype").LineBreakProperty | undefined;
        KhtmlOpacity?: import("csstype").OpacityProperty | undefined;
        KhtmlUserSelect?: import("csstype").UserSelectProperty | undefined;
        MozBackgroundClip?: string | undefined;
        MozBackgroundInlinePolicy?: import("csstype").BoxDecorationBreakProperty | undefined;
        MozBackgroundOrigin?: string | undefined;
        MozBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        MozBinding?: string | undefined;
        MozBorderRadius?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        MozBorderRadiusBottomleft?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        MozBorderRadiusBottomright?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        MozBorderRadiusTopleft?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        MozBorderRadiusTopright?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        MozBoxAlign?: import("csstype").BoxAlignProperty | undefined;
        MozBoxDirection?: import("csstype").BoxDirectionProperty | undefined;
        MozBoxFlex?: import("csstype").GlobalsNumber | undefined;
        MozBoxOrdinalGroup?: import("csstype").GlobalsNumber | undefined;
        MozBoxOrient?: import("csstype").BoxOrientProperty | undefined;
        MozBoxPack?: import("csstype").BoxPackProperty | undefined;
        MozBoxShadow?: string | undefined;
        MozFloatEdge?: import("csstype").MozFloatEdgeProperty | undefined;
        MozForceBrokenImageIcon?: import("csstype").MozForceBrokenImageIconProperty | undefined;
        MozOpacity?: import("csstype").OpacityProperty | undefined;
        MozOutline?: import("csstype").OutlineProperty<string | number> | undefined;
        MozOutlineColor?: string | undefined;
        MozOutlineRadius?: import("csstype").MozOutlineRadiusProperty<string | number> | undefined;
        MozOutlineRadiusBottomleft?: import("csstype").MozOutlineRadiusBottomleftProperty<string | number> | undefined;
        MozOutlineRadiusBottomright?: import("csstype").MozOutlineRadiusBottomrightProperty<string | number> | undefined;
        MozOutlineRadiusTopleft?: import("csstype").MozOutlineRadiusTopleftProperty<string | number> | undefined;
        MozOutlineRadiusTopright?: import("csstype").MozOutlineRadiusToprightProperty<string | number> | undefined;
        MozOutlineStyle?: string | undefined;
        MozOutlineWidth?: import("csstype").OutlineWidthProperty<string | number> | undefined;
        MozTextAlignLast?: import("csstype").TextAlignLastProperty | undefined;
        MozTextDecorationColor?: string | undefined;
        MozTextDecorationLine?: string | undefined;
        MozTextDecorationStyle?: import("csstype").TextDecorationStyleProperty | undefined;
        MozUserInput?: import("csstype").MozUserInputProperty | undefined;
        msImeMode?: import("csstype").ImeModeProperty | undefined;
        msScrollbarTrackColor?: string | undefined;
        OAnimation?: import("csstype").AnimationProperty | undefined;
        OAnimationDelay?: string | undefined;
        OAnimationDirection?: string | undefined;
        OAnimationDuration?: string | undefined;
        OAnimationFillMode?: string | undefined;
        OAnimationIterationCount?: import("csstype").AnimationIterationCountProperty | undefined;
        OAnimationName?: string | undefined;
        OAnimationPlayState?: string | undefined;
        OAnimationTimingFunction?: string | undefined;
        OBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        OBorderImage?: import("csstype").BorderImageProperty | undefined;
        OObjectFit?: import("csstype").ObjectFitProperty | undefined;
        OObjectPosition?: import("csstype").ObjectPositionProperty<string | number> | undefined;
        OTabSize?: import("csstype").TabSizeProperty<string | number> | undefined;
        OTextOverflow?: string | undefined;
        OTransform?: string | undefined;
        OTransformOrigin?: import("csstype").TransformOriginProperty<string | number> | undefined;
        OTransition?: string | undefined;
        OTransitionDelay?: string | undefined;
        OTransitionDuration?: string | undefined;
        OTransitionProperty?: string | undefined;
        OTransitionTimingFunction?: string | undefined;
        WebkitBoxAlign?: import("csstype").BoxAlignProperty | undefined;
        WebkitBoxDirection?: import("csstype").BoxDirectionProperty | undefined;
        WebkitBoxFlex?: import("csstype").GlobalsNumber | undefined;
        WebkitBoxFlexGroup?: import("csstype").GlobalsNumber | undefined;
        WebkitBoxLines?: import("csstype").BoxLinesProperty | undefined;
        WebkitBoxOrdinalGroup?: import("csstype").GlobalsNumber | undefined;
        WebkitBoxOrient?: import("csstype").BoxOrientProperty | undefined;
        WebkitBoxPack?: import("csstype").BoxPackProperty | undefined;
        WebkitScrollSnapPointsX?: string | undefined;
        WebkitScrollSnapPointsY?: string | undefined;
        alignmentBaseline?: import("csstype").AlignmentBaselineProperty | undefined;
        baselineShift?: import("csstype").BaselineShiftProperty<string | number> | undefined;
        clipRule?: import("csstype").ClipRuleProperty | undefined;
        colorInterpolation?: import("csstype").ColorInterpolationProperty | undefined;
        colorRendering?: import("csstype").ColorRenderingProperty | undefined;
        dominantBaseline?: import("csstype").DominantBaselineProperty | undefined;
        fill?: string | undefined;
        fillOpacity?: import("csstype").GlobalsNumber | undefined;
        fillRule?: import("csstype").FillRuleProperty | undefined;
        floodColor?: string | undefined;
        floodOpacity?: import("csstype").GlobalsNumber | undefined;
        glyphOrientationVertical?: import("csstype").GlyphOrientationVerticalProperty | undefined;
        lightingColor?: string | undefined;
        marker?: string | undefined;
        markerEnd?: string | undefined;
        markerMid?: string | undefined;
        markerStart?: string | undefined;
        shapeRendering?: import("csstype").ShapeRenderingProperty | undefined;
        stopColor?: string | undefined;
        stopOpacity?: import("csstype").GlobalsNumber | undefined;
        stroke?: string | undefined;
        strokeDasharray?: import("csstype").StrokeDasharrayProperty<string | number> | undefined;
        strokeDashoffset?: import("csstype").StrokeDashoffsetProperty<string | number> | undefined;
        strokeLinecap?: import("csstype").StrokeLinecapProperty | undefined;
        strokeLinejoin?: import("csstype").StrokeLinejoinProperty | undefined;
        strokeMiterlimit?: import("csstype").GlobalsNumber | undefined;
        strokeOpacity?: import("csstype").GlobalsNumber | undefined;
        strokeWidth?: import("csstype").StrokeWidthProperty<string | number> | undefined;
        textAnchor?: import("csstype").TextAnchorProperty | undefined;
        vectorEffect?: import("csstype").VectorEffectProperty | undefined;
        "accent-color"?: string | undefined;
        "align-content"?: string | undefined;
        "align-items"?: string | undefined;
        "align-self"?: string | undefined;
        "align-tracks"?: string | undefined;
        "animation-delay"?: string | undefined;
        "animation-direction"?: string | undefined;
        "animation-duration"?: string | undefined;
        "animation-fill-mode"?: string | undefined;
        "animation-iteration-count"?: import("csstype").AnimationIterationCountProperty | undefined;
        "animation-name"?: string | undefined;
        "animation-play-state"?: string | undefined;
        "animation-timing-function"?: string | undefined;
        "aspect-ratio"?: string | undefined;
        "backdrop-filter"?: string | undefined;
        "backface-visibility"?: import("csstype").BackfaceVisibilityProperty | undefined;
        "background-attachment"?: string | undefined;
        "background-blend-mode"?: string | undefined;
        "background-clip"?: string | undefined;
        "background-color"?: string | undefined;
        "background-image"?: string | undefined;
        "background-origin"?: string | undefined;
        "background-position-x"?: import("csstype").BackgroundPositionXProperty<string | number> | undefined;
        "background-position-y"?: import("csstype").BackgroundPositionYProperty<string | number> | undefined;
        "background-repeat"?: string | undefined;
        "background-size"?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        "block-overflow"?: string | undefined;
        "block-size"?: import("csstype").BlockSizeProperty<string | number> | undefined;
        "border-block-color"?: string | undefined;
        "border-block-end-color"?: string | undefined;
        "border-block-end-style"?: import("csstype").BorderBlockEndStyleProperty | undefined;
        "border-block-end-width"?: import("csstype").BorderBlockEndWidthProperty<string | number> | undefined;
        "border-block-start-color"?: string | undefined;
        "border-block-start-style"?: import("csstype").BorderBlockStartStyleProperty | undefined;
        "border-block-start-width"?: import("csstype").BorderBlockStartWidthProperty<string | number> | undefined;
        "border-block-style"?: import("csstype").BorderBlockStyleProperty | undefined;
        "border-block-width"?: import("csstype").BorderBlockWidthProperty<string | number> | undefined;
        "border-bottom-color"?: string | undefined;
        "border-bottom-left-radius"?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        "border-bottom-right-radius"?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        "border-bottom-style"?: import("csstype").BorderBottomStyleProperty | undefined;
        "border-bottom-width"?: import("csstype").BorderBottomWidthProperty<string | number> | undefined;
        "border-collapse"?: import("csstype").BorderCollapseProperty | undefined;
        "border-end-end-radius"?: import("csstype").BorderEndEndRadiusProperty<string | number> | undefined;
        "border-end-start-radius"?: import("csstype").BorderEndStartRadiusProperty<string | number> | undefined;
        "border-image-outset"?: import("csstype").BorderImageOutsetProperty<string | number> | undefined;
        "border-image-repeat"?: string | undefined;
        "border-image-slice"?: import("csstype").BorderImageSliceProperty | undefined;
        "border-image-source"?: string | undefined;
        "border-image-width"?: import("csstype").BorderImageWidthProperty<string | number> | undefined;
        "border-inline-color"?: string | undefined;
        "border-inline-end-color"?: string | undefined;
        "border-inline-end-style"?: import("csstype").BorderInlineEndStyleProperty | undefined;
        "border-inline-end-width"?: import("csstype").BorderInlineEndWidthProperty<string | number> | undefined;
        "border-inline-start-color"?: string | undefined;
        "border-inline-start-style"?: import("csstype").BorderInlineStartStyleProperty | undefined;
        "border-inline-start-width"?: import("csstype").BorderInlineStartWidthProperty<string | number> | undefined;
        "border-inline-style"?: import("csstype").BorderInlineStyleProperty | undefined;
        "border-inline-width"?: import("csstype").BorderInlineWidthProperty<string | number> | undefined;
        "border-left-color"?: string | undefined;
        "border-left-style"?: import("csstype").BorderLeftStyleProperty | undefined;
        "border-left-width"?: import("csstype").BorderLeftWidthProperty<string | number> | undefined;
        "border-right-color"?: string | undefined;
        "border-right-style"?: import("csstype").BorderRightStyleProperty | undefined;
        "border-right-width"?: import("csstype").BorderRightWidthProperty<string | number> | undefined;
        "border-spacing"?: import("csstype").BorderSpacingProperty<string | number> | undefined;
        "border-start-end-radius"?: import("csstype").BorderStartEndRadiusProperty<string | number> | undefined;
        "border-start-start-radius"?: import("csstype").BorderStartStartRadiusProperty<string | number> | undefined;
        "border-top-color"?: string | undefined;
        "border-top-left-radius"?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        "border-top-right-radius"?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        "border-top-style"?: import("csstype").BorderTopStyleProperty | undefined;
        "border-top-width"?: import("csstype").BorderTopWidthProperty<string | number> | undefined;
        "box-decoration-break"?: import("csstype").BoxDecorationBreakProperty | undefined;
        "box-shadow"?: string | undefined;
        "box-sizing"?: import("csstype").BoxSizingProperty | undefined;
        "break-after"?: import("csstype").BreakAfterProperty | undefined;
        "break-before"?: import("csstype").BreakBeforeProperty | undefined;
        "break-inside"?: import("csstype").BreakInsideProperty | undefined;
        "caption-side"?: import("csstype").CaptionSideProperty | undefined;
        "caret-color"?: string | undefined;
        "clip-path"?: string | undefined;
        "color-adjust"?: import("csstype").ColorAdjustProperty | undefined;
        "color-scheme"?: string | undefined;
        "column-count"?: import("csstype").ColumnCountProperty | undefined;
        "column-fill"?: import("csstype").ColumnFillProperty | undefined;
        "column-gap"?: import("csstype").ColumnGapProperty<string | number> | undefined;
        "column-rule-color"?: string | undefined;
        "column-rule-style"?: string | undefined;
        "column-rule-width"?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        "column-span"?: import("csstype").ColumnSpanProperty | undefined;
        "column-width"?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        "content-visibility"?: import("csstype").ContentVisibilityProperty | undefined;
        "counter-increment"?: string | undefined;
        "counter-reset"?: string | undefined;
        "counter-set"?: string | undefined;
        "empty-cells"?: import("csstype").EmptyCellsProperty | undefined;
        "flex-basis"?: import("csstype").FlexBasisProperty<string | number> | undefined;
        "flex-direction"?: import("csstype").FlexDirectionProperty | undefined;
        "flex-grow"?: import("csstype").GlobalsNumber | undefined;
        "flex-shrink"?: import("csstype").GlobalsNumber | undefined;
        "flex-wrap"?: import("csstype").FlexWrapProperty | undefined;
        "font-family"?: string | undefined;
        "font-feature-settings"?: string | undefined;
        "font-kerning"?: import("csstype").FontKerningProperty | undefined;
        "font-language-override"?: string | undefined;
        "font-optical-sizing"?: import("csstype").FontOpticalSizingProperty | undefined;
        "font-size"?: import("csstype").FontSizeProperty<string | number> | undefined;
        "font-size-adjust"?: import("csstype").FontSizeAdjustProperty | undefined;
        "font-smooth"?: import("csstype").FontSmoothProperty<string | number> | undefined;
        "font-stretch"?: string | undefined;
        "font-style"?: string | undefined;
        "font-synthesis"?: string | undefined;
        "font-variant"?: string | undefined;
        "font-variant-caps"?: import("csstype").FontVariantCapsProperty | undefined;
        "font-variant-east-asian"?: string | undefined;
        "font-variant-ligatures"?: string | undefined;
        "font-variant-numeric"?: string | undefined;
        "font-variant-position"?: import("csstype").FontVariantPositionProperty | undefined;
        "font-variation-settings"?: string | undefined;
        "font-weight"?: import("csstype").FontWeightProperty | undefined;
        "forced-color-adjust"?: import("csstype").ForcedColorAdjustProperty | undefined;
        "grid-auto-columns"?: import("csstype").GridAutoColumnsProperty<string | number> | undefined;
        "grid-auto-flow"?: string | undefined;
        "grid-auto-rows"?: import("csstype").GridAutoRowsProperty<string | number> | undefined;
        "grid-column-end"?: import("csstype").GridColumnEndProperty | undefined;
        "grid-column-start"?: import("csstype").GridColumnStartProperty | undefined;
        "grid-row-end"?: import("csstype").GridRowEndProperty | undefined;
        "grid-row-start"?: import("csstype").GridRowStartProperty | undefined;
        "grid-template-areas"?: string | undefined;
        "grid-template-columns"?: import("csstype").GridTemplateColumnsProperty<string | number> | undefined;
        "grid-template-rows"?: import("csstype").GridTemplateRowsProperty<string | number> | undefined;
        "hanging-punctuation"?: string | undefined;
        "image-orientation"?: string | undefined;
        "image-rendering"?: import("csstype").ImageRenderingProperty | undefined;
        "image-resolution"?: string | undefined;
        "initial-letter"?: import("csstype").InitialLetterProperty | undefined;
        "inline-size"?: import("csstype").InlineSizeProperty<string | number> | undefined;
        "inset-block"?: import("csstype").InsetBlockProperty<string | number> | undefined;
        "inset-block-end"?: import("csstype").InsetBlockEndProperty<string | number> | undefined;
        "inset-block-start"?: import("csstype").InsetBlockStartProperty<string | number> | undefined;
        "inset-inline"?: import("csstype").InsetInlineProperty<string | number> | undefined;
        "inset-inline-end"?: import("csstype").InsetInlineEndProperty<string | number> | undefined;
        "inset-inline-start"?: import("csstype").InsetInlineStartProperty<string | number> | undefined;
        "justify-content"?: string | undefined;
        "justify-items"?: string | undefined;
        "justify-self"?: string | undefined;
        "justify-tracks"?: string | undefined;
        "letter-spacing"?: import("csstype").LetterSpacingProperty<string | number> | undefined;
        "line-break"?: import("csstype").LineBreakProperty | undefined;
        "line-height"?: import("csstype").LineHeightProperty<string | number> | undefined;
        "line-height-step"?: import("csstype").LineHeightStepProperty<string | number> | undefined;
        "list-style-image"?: string | undefined;
        "list-style-position"?: import("csstype").ListStylePositionProperty | undefined;
        "list-style-type"?: string | undefined;
        "margin-block"?: import("csstype").MarginBlockProperty<string | number> | undefined;
        "margin-block-end"?: import("csstype").MarginBlockEndProperty<string | number> | undefined;
        "margin-block-start"?: import("csstype").MarginBlockStartProperty<string | number> | undefined;
        "margin-bottom"?: import("csstype").MarginBottomProperty<string | number> | undefined;
        "margin-inline"?: import("csstype").MarginInlineProperty<string | number> | undefined;
        "margin-inline-end"?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        "margin-inline-start"?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        "margin-left"?: import("csstype").MarginLeftProperty<string | number> | undefined;
        "margin-right"?: import("csstype").MarginRightProperty<string | number> | undefined;
        "margin-top"?: import("csstype").MarginTopProperty<string | number> | undefined;
        "mask-border-mode"?: import("csstype").MaskBorderModeProperty | undefined;
        "mask-border-outset"?: import("csstype").MaskBorderOutsetProperty<string | number> | undefined;
        "mask-border-repeat"?: string | undefined;
        "mask-border-slice"?: import("csstype").MaskBorderSliceProperty | undefined;
        "mask-border-source"?: string | undefined;
        "mask-border-width"?: import("csstype").MaskBorderWidthProperty<string | number> | undefined;
        "mask-clip"?: string | undefined;
        "mask-composite"?: string | undefined;
        "mask-image"?: string | undefined;
        "mask-mode"?: string | undefined;
        "mask-origin"?: string | undefined;
        "mask-position"?: import("csstype").MaskPositionProperty<string | number> | undefined;
        "mask-repeat"?: string | undefined;
        "mask-size"?: import("csstype").MaskSizeProperty<string | number> | undefined;
        "mask-type"?: import("csstype").MaskTypeProperty | undefined;
        "math-style"?: import("csstype").MathStyleProperty | undefined;
        "max-block-size"?: import("csstype").MaxBlockSizeProperty<string | number> | undefined;
        "max-height"?: import("csstype").MaxHeightProperty<string | number> | undefined;
        "max-inline-size"?: import("csstype").MaxInlineSizeProperty<string | number> | undefined;
        "max-lines"?: import("csstype").MaxLinesProperty | undefined;
        "max-width"?: import("csstype").MaxWidthProperty<string | number> | undefined;
        "min-block-size"?: import("csstype").MinBlockSizeProperty<string | number> | undefined;
        "min-height"?: import("csstype").MinHeightProperty<string | number> | undefined;
        "min-inline-size"?: import("csstype").MinInlineSizeProperty<string | number> | undefined;
        "min-width"?: import("csstype").MinWidthProperty<string | number> | undefined;
        "mix-blend-mode"?: import("csstype").MixBlendModeProperty | undefined;
        "motion-distance"?: import("csstype").OffsetDistanceProperty<string | number> | undefined;
        "motion-path"?: string | undefined;
        "motion-rotation"?: string | undefined;
        "object-fit"?: import("csstype").ObjectFitProperty | undefined;
        "object-position"?: import("csstype").ObjectPositionProperty<string | number> | undefined;
        "offset-anchor"?: import("csstype").OffsetAnchorProperty<string | number> | undefined;
        "offset-distance"?: import("csstype").OffsetDistanceProperty<string | number> | undefined;
        "offset-path"?: string | undefined;
        "offset-rotate"?: string | undefined;
        "offset-rotation"?: string | undefined;
        "outline-color"?: string | undefined;
        "outline-offset"?: import("csstype").OutlineOffsetProperty<string | number> | undefined;
        "outline-style"?: string | undefined;
        "outline-width"?: import("csstype").OutlineWidthProperty<string | number> | undefined;
        "overflow-anchor"?: import("csstype").OverflowAnchorProperty | undefined;
        "overflow-block"?: import("csstype").OverflowBlockProperty | undefined;
        "overflow-clip-box"?: import("csstype").OverflowClipBoxProperty | undefined;
        "overflow-clip-margin"?: import("csstype").OverflowClipMarginProperty<string | number> | undefined;
        "overflow-inline"?: import("csstype").OverflowInlineProperty | undefined;
        "overflow-wrap"?: import("csstype").OverflowWrapProperty | undefined;
        "overflow-x"?: import("csstype").OverflowXProperty | undefined;
        "overflow-y"?: import("csstype").OverflowYProperty | undefined;
        "overscroll-behavior-block"?: import("csstype").OverscrollBehaviorBlockProperty | undefined;
        "overscroll-behavior-inline"?: import("csstype").OverscrollBehaviorInlineProperty | undefined;
        "overscroll-behavior-x"?: import("csstype").OverscrollBehaviorXProperty | undefined;
        "overscroll-behavior-y"?: import("csstype").OverscrollBehaviorYProperty | undefined;
        "padding-block"?: import("csstype").PaddingBlockProperty<string | number> | undefined;
        "padding-block-end"?: import("csstype").PaddingBlockEndProperty<string | number> | undefined;
        "padding-block-start"?: import("csstype").PaddingBlockStartProperty<string | number> | undefined;
        "padding-bottom"?: import("csstype").PaddingBottomProperty<string | number> | undefined;
        "padding-inline"?: import("csstype").PaddingInlineProperty<string | number> | undefined;
        "padding-inline-end"?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        "padding-inline-start"?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        "padding-left"?: import("csstype").PaddingLeftProperty<string | number> | undefined;
        "padding-right"?: import("csstype").PaddingRightProperty<string | number> | undefined;
        "padding-top"?: import("csstype").PaddingTopProperty<string | number> | undefined;
        "page-break-after"?: import("csstype").PageBreakAfterProperty | undefined;
        "page-break-before"?: import("csstype").PageBreakBeforeProperty | undefined;
        "page-break-inside"?: import("csstype").PageBreakInsideProperty | undefined;
        "paint-order"?: string | undefined;
        "perspective-origin"?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        "place-content"?: string | undefined;
        "pointer-events"?: import("csstype").PointerEventsProperty | undefined;
        "row-gap"?: import("csstype").RowGapProperty<string | number> | undefined;
        "ruby-align"?: import("csstype").RubyAlignProperty | undefined;
        "ruby-merge"?: import("csstype").RubyMergeProperty | undefined;
        "ruby-position"?: string | undefined;
        "scroll-behavior"?: import("csstype").ScrollBehaviorProperty | undefined;
        "scroll-margin"?: import("csstype").ScrollMarginProperty<string | number> | undefined;
        "scroll-margin-block"?: import("csstype").ScrollMarginBlockProperty<string | number> | undefined;
        "scroll-margin-block-end"?: import("csstype").ScrollMarginBlockEndProperty<string | number> | undefined;
        "scroll-margin-block-start"?: import("csstype").ScrollMarginBlockStartProperty<string | number> | undefined;
        "scroll-margin-bottom"?: import("csstype").ScrollMarginBottomProperty<string | number> | undefined;
        "scroll-margin-inline"?: import("csstype").ScrollMarginInlineProperty<string | number> | undefined;
        "scroll-margin-inline-end"?: import("csstype").ScrollMarginInlineEndProperty<string | number> | undefined;
        "scroll-margin-inline-start"?: import("csstype").ScrollMarginInlineStartProperty<string | number> | undefined;
        "scroll-margin-left"?: import("csstype").ScrollMarginLeftProperty<string | number> | undefined;
        "scroll-margin-right"?: import("csstype").ScrollMarginRightProperty<string | number> | undefined;
        "scroll-margin-top"?: import("csstype").ScrollMarginTopProperty<string | number> | undefined;
        "scroll-padding"?: import("csstype").ScrollPaddingProperty<string | number> | undefined;
        "scroll-padding-block"?: import("csstype").ScrollPaddingBlockProperty<string | number> | undefined;
        "scroll-padding-block-end"?: import("csstype").ScrollPaddingBlockEndProperty<string | number> | undefined;
        "scroll-padding-block-start"?: import("csstype").ScrollPaddingBlockStartProperty<string | number> | undefined;
        "scroll-padding-bottom"?: import("csstype").ScrollPaddingBottomProperty<string | number> | undefined;
        "scroll-padding-inline"?: import("csstype").ScrollPaddingInlineProperty<string | number> | undefined;
        "scroll-padding-inline-end"?: import("csstype").ScrollPaddingInlineEndProperty<string | number> | undefined;
        "scroll-padding-inline-start"?: import("csstype").ScrollPaddingInlineStartProperty<string | number> | undefined;
        "scroll-padding-left"?: import("csstype").ScrollPaddingLeftProperty<string | number> | undefined;
        "scroll-padding-right"?: import("csstype").ScrollPaddingRightProperty<string | number> | undefined;
        "scroll-padding-top"?: import("csstype").ScrollPaddingTopProperty<string | number> | undefined;
        "scroll-snap-align"?: string | undefined;
        "scroll-snap-margin"?: import("csstype").ScrollMarginProperty<string | number> | undefined;
        "scroll-snap-margin-bottom"?: import("csstype").ScrollMarginBottomProperty<string | number> | undefined;
        "scroll-snap-margin-left"?: import("csstype").ScrollMarginLeftProperty<string | number> | undefined;
        "scroll-snap-margin-right"?: import("csstype").ScrollMarginRightProperty<string | number> | undefined;
        "scroll-snap-margin-top"?: import("csstype").ScrollMarginTopProperty<string | number> | undefined;
        "scroll-snap-stop"?: import("csstype").ScrollSnapStopProperty | undefined;
        "scroll-snap-type"?: string | undefined;
        "scrollbar-color"?: string | undefined;
        "scrollbar-gutter"?: string | undefined;
        "scrollbar-width"?: import("csstype").ScrollbarWidthProperty | undefined;
        "shape-image-threshold"?: import("csstype").ShapeImageThresholdProperty | undefined;
        "shape-margin"?: import("csstype").ShapeMarginProperty<string | number> | undefined;
        "shape-outside"?: string | undefined;
        "tab-size"?: import("csstype").TabSizeProperty<string | number> | undefined;
        "table-layout"?: import("csstype").TableLayoutProperty | undefined;
        "text-align"?: import("csstype").TextAlignProperty | undefined;
        "text-align-last"?: import("csstype").TextAlignLastProperty | undefined;
        "text-combine-upright"?: string | undefined;
        "text-decoration-color"?: string | undefined;
        "text-decoration-line"?: string | undefined;
        "text-decoration-skip"?: string | undefined;
        "text-decoration-skip-ink"?: import("csstype").TextDecorationSkipInkProperty | undefined;
        "text-decoration-style"?: import("csstype").TextDecorationStyleProperty | undefined;
        "text-decoration-thickness"?: import("csstype").TextDecorationThicknessProperty<string | number> | undefined;
        "text-decoration-width"?: import("csstype").TextDecorationThicknessProperty<string | number> | undefined;
        "text-emphasis-color"?: string | undefined;
        "text-emphasis-position"?: string | undefined;
        "text-emphasis-style"?: string | undefined;
        "text-indent"?: import("csstype").TextIndentProperty<string | number> | undefined;
        "text-justify"?: import("csstype").TextJustifyProperty | undefined;
        "text-orientation"?: import("csstype").TextOrientationProperty | undefined;
        "text-overflow"?: string | undefined;
        "text-rendering"?: import("csstype").TextRenderingProperty | undefined;
        "text-shadow"?: string | undefined;
        "text-size-adjust"?: string | undefined;
        "text-transform"?: import("csstype").TextTransformProperty | undefined;
        "text-underline-offset"?: import("csstype").TextUnderlineOffsetProperty<string | number> | undefined;
        "text-underline-position"?: string | undefined;
        "touch-action"?: string | undefined;
        "transform-box"?: import("csstype").TransformBoxProperty | undefined;
        "transform-origin"?: import("csstype").TransformOriginProperty<string | number> | undefined;
        "transform-style"?: import("csstype").TransformStyleProperty | undefined;
        "transition-delay"?: string | undefined;
        "transition-duration"?: string | undefined;
        "transition-property"?: string | undefined;
        "transition-timing-function"?: string | undefined;
        "unicode-bidi"?: import("csstype").UnicodeBidiProperty | undefined;
        "user-select"?: import("csstype").UserSelectProperty | undefined;
        "vertical-align"?: import("csstype").VerticalAlignProperty<string | number> | undefined;
        "white-space"?: import("csstype").WhiteSpaceProperty | undefined;
        "will-change"?: string | undefined;
        "word-break"?: import("csstype").WordBreakProperty | undefined;
        "word-spacing"?: import("csstype").WordSpacingProperty<string | number> | undefined;
        "word-wrap"?: import("csstype").WordWrapProperty | undefined;
        "writing-mode"?: import("csstype").WritingModeProperty | undefined;
        "z-index"?: import("csstype").ZIndexProperty | undefined;
        "background-position"?: import("csstype").BackgroundPositionProperty<string | number> | undefined;
        "border-block"?: import("csstype").BorderBlockProperty<string | number> | undefined;
        "border-block-end"?: import("csstype").BorderBlockEndProperty<string | number> | undefined;
        "border-block-start"?: import("csstype").BorderBlockStartProperty<string | number> | undefined;
        "border-bottom"?: import("csstype").BorderBottomProperty<string | number> | undefined;
        "border-color"?: string | undefined;
        "border-image"?: import("csstype").BorderImageProperty | undefined;
        "border-inline"?: import("csstype").BorderInlineProperty<string | number> | undefined;
        "border-inline-end"?: import("csstype").BorderInlineEndProperty<string | number> | undefined;
        "border-inline-start"?: import("csstype").BorderInlineStartProperty<string | number> | undefined;
        "border-left"?: import("csstype").BorderLeftProperty<string | number> | undefined;
        "border-radius"?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        "border-right"?: import("csstype").BorderRightProperty<string | number> | undefined;
        "border-style"?: string | undefined;
        "border-top"?: import("csstype").BorderTopProperty<string | number> | undefined;
        "border-width"?: import("csstype").BorderWidthProperty<string | number> | undefined;
        "column-rule"?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        "flex-flow"?: string | undefined;
        "grid-area"?: import("csstype").GridAreaProperty | undefined;
        "grid-column"?: import("csstype").GridColumnProperty | undefined;
        "grid-row"?: import("csstype").GridRowProperty | undefined;
        "grid-template"?: string | undefined;
        "line-clamp"?: import("csstype").LineClampProperty | undefined;
        "list-style"?: string | undefined;
        "mask-border"?: import("csstype").MaskBorderProperty | undefined;
        "overscroll-behavior"?: string | undefined;
        "place-items"?: string | undefined;
        "place-self"?: string | undefined;
        "text-decoration"?: import("csstype").TextDecorationProperty<string | number> | undefined;
        "text-emphasis"?: string | undefined;
        "-moz-animation-delay"?: string | undefined;
        "-moz-animation-direction"?: string | undefined;
        "-moz-animation-duration"?: string | undefined;
        "-moz-animation-fill-mode"?: string | undefined;
        "-moz-animation-iteration-count"?: import("csstype").AnimationIterationCountProperty | undefined;
        "-moz-animation-name"?: string | undefined;
        "-moz-animation-play-state"?: string | undefined;
        "-moz-animation-timing-function"?: string | undefined;
        "-moz-appearance"?: import("csstype").MozAppearanceProperty | undefined;
        "-moz-backface-visibility"?: import("csstype").BackfaceVisibilityProperty | undefined;
        "-moz-border-bottom-colors"?: string | undefined;
        "-moz-border-end-color"?: string | undefined;
        "-moz-border-end-style"?: import("csstype").BorderInlineEndStyleProperty | undefined;
        "-moz-border-end-width"?: import("csstype").BorderInlineEndWidthProperty<string | number> | undefined;
        "-moz-border-left-colors"?: string | undefined;
        "-moz-border-right-colors"?: string | undefined;
        "-moz-border-start-color"?: string | undefined;
        "-moz-border-start-style"?: import("csstype").BorderInlineStartStyleProperty | undefined;
        "-moz-border-top-colors"?: string | undefined;
        "-moz-box-sizing"?: import("csstype").BoxSizingProperty | undefined;
        "-moz-column-count"?: import("csstype").ColumnCountProperty | undefined;
        "-moz-column-fill"?: import("csstype").ColumnFillProperty | undefined;
        "-moz-column-gap"?: import("csstype").ColumnGapProperty<string | number> | undefined;
        "-moz-column-rule-color"?: string | undefined;
        "-moz-column-rule-style"?: string | undefined;
        "-moz-column-rule-width"?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        "-moz-column-width"?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        "-moz-context-properties"?: string | undefined;
        "-moz-font-feature-settings"?: string | undefined;
        "-moz-font-language-override"?: string | undefined;
        "-moz-hyphens"?: import("csstype").HyphensProperty | undefined;
        "-moz-image-region"?: string | undefined;
        "-moz-margin-end"?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        "-moz-margin-start"?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        "-moz-orient"?: import("csstype").MozOrientProperty | undefined;
        "-moz-osx-font-smoothing"?: import("csstype").FontSmoothProperty<string | number> | undefined;
        "-moz-padding-end"?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        "-moz-padding-start"?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        "-moz-perspective"?: import("csstype").PerspectiveProperty<string | number> | undefined;
        "-moz-perspective-origin"?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        "-moz-stack-sizing"?: import("csstype").MozStackSizingProperty | undefined;
        "-moz-tab-size"?: import("csstype").TabSizeProperty<string | number> | undefined;
        "-moz-text-blink"?: import("csstype").MozTextBlinkProperty | undefined;
        "-moz-text-size-adjust"?: string | undefined;
        "-moz-transform-origin"?: import("csstype").TransformOriginProperty<string | number> | undefined;
        "-moz-transform-style"?: import("csstype").TransformStyleProperty | undefined;
        "-moz-transition-delay"?: string | undefined;
        "-moz-transition-duration"?: string | undefined;
        "-moz-transition-property"?: string | undefined;
        "-moz-transition-timing-function"?: string | undefined;
        "-moz-user-focus"?: import("csstype").MozUserFocusProperty | undefined;
        "-moz-user-modify"?: import("csstype").MozUserModifyProperty | undefined;
        "-moz-user-select"?: import("csstype").UserSelectProperty | undefined;
        "-moz-window-dragging"?: import("csstype").MozWindowDraggingProperty | undefined;
        "-moz-window-shadow"?: import("csstype").MozWindowShadowProperty | undefined;
        "-ms-accelerator"?: import("csstype").MsAcceleratorProperty | undefined;
        "-ms-align-self"?: string | undefined;
        "-ms-block-progression"?: import("csstype").MsBlockProgressionProperty | undefined;
        "-ms-content-zoom-chaining"?: import("csstype").MsContentZoomChainingProperty | undefined;
        "-ms-content-zoom-limit-max"?: string | undefined;
        "-ms-content-zoom-limit-min"?: string | undefined;
        "-ms-content-zoom-snap-points"?: string | undefined;
        "-ms-content-zoom-snap-type"?: import("csstype").MsContentZoomSnapTypeProperty | undefined;
        "-ms-content-zooming"?: import("csstype").MsContentZoomingProperty | undefined;
        "-ms-filter"?: string | undefined;
        "-ms-flex-direction"?: import("csstype").FlexDirectionProperty | undefined;
        "-ms-flex-positive"?: import("csstype").GlobalsNumber | undefined;
        "-ms-flow-from"?: string | undefined;
        "-ms-flow-into"?: string | undefined;
        "-ms-grid-columns"?: import("csstype").MsGridColumnsProperty<string | number> | undefined;
        "-ms-grid-rows"?: import("csstype").MsGridRowsProperty<string | number> | undefined;
        "-ms-high-contrast-adjust"?: import("csstype").MsHighContrastAdjustProperty | undefined;
        "-ms-hyphenate-limit-chars"?: import("csstype").MsHyphenateLimitCharsProperty | undefined;
        "-ms-hyphenate-limit-lines"?: import("csstype").MsHyphenateLimitLinesProperty | undefined;
        "-ms-hyphenate-limit-zone"?: import("csstype").MsHyphenateLimitZoneProperty<string | number> | undefined;
        "-ms-hyphens"?: import("csstype").HyphensProperty | undefined;
        "-ms-ime-align"?: import("csstype").MsImeAlignProperty | undefined;
        "-ms-justify-self"?: string | undefined;
        "-ms-line-break"?: import("csstype").LineBreakProperty | undefined;
        "-ms-order"?: import("csstype").GlobalsNumber | undefined;
        "-ms-overflow-style"?: import("csstype").MsOverflowStyleProperty | undefined;
        "-ms-overflow-x"?: import("csstype").OverflowXProperty | undefined;
        "-ms-overflow-y"?: import("csstype").OverflowYProperty | undefined;
        "-ms-scroll-chaining"?: import("csstype").MsScrollChainingProperty | undefined;
        "-ms-scroll-limit-x-max"?: import("csstype").MsScrollLimitXMaxProperty<string | number> | undefined;
        "-ms-scroll-limit-x-min"?: import("csstype").MsScrollLimitXMinProperty<string | number> | undefined;
        "-ms-scroll-limit-y-max"?: import("csstype").MsScrollLimitYMaxProperty<string | number> | undefined;
        "-ms-scroll-limit-y-min"?: import("csstype").MsScrollLimitYMinProperty<string | number> | undefined;
        "-ms-scroll-rails"?: import("csstype").MsScrollRailsProperty | undefined;
        "-ms-scroll-snap-points-x"?: string | undefined;
        "-ms-scroll-snap-points-y"?: string | undefined;
        "-ms-scroll-snap-type"?: import("csstype").MsScrollSnapTypeProperty | undefined;
        "-ms-scroll-translation"?: import("csstype").MsScrollTranslationProperty | undefined;
        "-ms-scrollbar-3dlight-color"?: string | undefined;
        "-ms-scrollbar-arrow-color"?: string | undefined;
        "-ms-scrollbar-base-color"?: string | undefined;
        "-ms-scrollbar-darkshadow-color"?: string | undefined;
        "-ms-scrollbar-face-color"?: string | undefined;
        "-ms-scrollbar-highlight-color"?: string | undefined;
        "-ms-scrollbar-shadow-color"?: string | undefined;
        "-ms-text-autospace"?: import("csstype").MsTextAutospaceProperty | undefined;
        "-ms-text-combine-horizontal"?: string | undefined;
        "-ms-text-overflow"?: string | undefined;
        "-ms-touch-action"?: string | undefined;
        "-ms-touch-select"?: import("csstype").MsTouchSelectProperty | undefined;
        "-ms-transform"?: string | undefined;
        "-ms-transform-origin"?: import("csstype").TransformOriginProperty<string | number> | undefined;
        "-ms-transition-delay"?: string | undefined;
        "-ms-transition-duration"?: string | undefined;
        "-ms-transition-property"?: string | undefined;
        "-ms-transition-timing-function"?: string | undefined;
        "-ms-user-select"?: import("csstype").MsUserSelectProperty | undefined;
        "-ms-word-break"?: import("csstype").WordBreakProperty | undefined;
        "-ms-wrap-flow"?: import("csstype").MsWrapFlowProperty | undefined;
        "-ms-wrap-margin"?: import("csstype").MsWrapMarginProperty<string | number> | undefined;
        "-ms-wrap-through"?: import("csstype").MsWrapThroughProperty | undefined;
        "-ms-writing-mode"?: import("csstype").WritingModeProperty | undefined;
        "-webkit-align-content"?: string | undefined;
        "-webkit-align-items"?: string | undefined;
        "-webkit-align-self"?: string | undefined;
        "-webkit-animation-delay"?: string | undefined;
        "-webkit-animation-direction"?: string | undefined;
        "-webkit-animation-duration"?: string | undefined;
        "-webkit-animation-fill-mode"?: string | undefined;
        "-webkit-animation-iteration-count"?: import("csstype").AnimationIterationCountProperty | undefined;
        "-webkit-animation-name"?: string | undefined;
        "-webkit-animation-play-state"?: string | undefined;
        "-webkit-animation-timing-function"?: string | undefined;
        "-webkit-appearance"?: import("csstype").WebkitAppearanceProperty | undefined;
        "-webkit-backdrop-filter"?: string | undefined;
        "-webkit-backface-visibility"?: import("csstype").BackfaceVisibilityProperty | undefined;
        "-webkit-background-clip"?: string | undefined;
        "-webkit-background-origin"?: string | undefined;
        "-webkit-background-size"?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        "-webkit-border-before-color"?: string | undefined;
        "-webkit-border-before-style"?: string | undefined;
        "-webkit-border-before-width"?: import("csstype").WebkitBorderBeforeWidthProperty<string | number> | undefined;
        "-webkit-border-bottom-left-radius"?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        "-webkit-border-bottom-right-radius"?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        "-webkit-border-image-slice"?: import("csstype").BorderImageSliceProperty | undefined;
        "-webkit-border-top-left-radius"?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        "-webkit-border-top-right-radius"?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        "-webkit-box-decoration-break"?: import("csstype").BoxDecorationBreakProperty | undefined;
        "-webkit-box-reflect"?: import("csstype").WebkitBoxReflectProperty<string | number> | undefined;
        "-webkit-box-shadow"?: string | undefined;
        "-webkit-box-sizing"?: import("csstype").BoxSizingProperty | undefined;
        "-webkit-clip-path"?: string | undefined;
        "-webkit-column-count"?: import("csstype").ColumnCountProperty | undefined;
        "-webkit-column-fill"?: import("csstype").ColumnFillProperty | undefined;
        "-webkit-column-gap"?: import("csstype").ColumnGapProperty<string | number> | undefined;
        "-webkit-column-rule-color"?: string | undefined;
        "-webkit-column-rule-style"?: string | undefined;
        "-webkit-column-rule-width"?: import("csstype").ColumnRuleWidthProperty<string | number> | undefined;
        "-webkit-column-span"?: import("csstype").ColumnSpanProperty | undefined;
        "-webkit-column-width"?: import("csstype").ColumnWidthProperty<string | number> | undefined;
        "-webkit-filter"?: string | undefined;
        "-webkit-flex-basis"?: import("csstype").FlexBasisProperty<string | number> | undefined;
        "-webkit-flex-direction"?: import("csstype").FlexDirectionProperty | undefined;
        "-webkit-flex-grow"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-flex-shrink"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-flex-wrap"?: import("csstype").FlexWrapProperty | undefined;
        "-webkit-font-feature-settings"?: string | undefined;
        "-webkit-font-kerning"?: import("csstype").FontKerningProperty | undefined;
        "-webkit-font-smoothing"?: import("csstype").FontSmoothProperty<string | number> | undefined;
        "-webkit-font-variant-ligatures"?: string | undefined;
        "-webkit-hyphens"?: import("csstype").HyphensProperty | undefined;
        "-webkit-initial-letter"?: import("csstype").InitialLetterProperty | undefined;
        "-webkit-justify-content"?: string | undefined;
        "-webkit-line-break"?: import("csstype").LineBreakProperty | undefined;
        "-webkit-line-clamp"?: import("csstype").WebkitLineClampProperty | undefined;
        "-webkit-margin-end"?: import("csstype").MarginInlineEndProperty<string | number> | undefined;
        "-webkit-margin-start"?: import("csstype").MarginInlineStartProperty<string | number> | undefined;
        "-webkit-mask-attachment"?: string | undefined;
        "-webkit-mask-box-image-outset"?: import("csstype").MaskBorderOutsetProperty<string | number> | undefined;
        "-webkit-mask-box-image-repeat"?: string | undefined;
        "-webkit-mask-box-image-slice"?: import("csstype").MaskBorderSliceProperty | undefined;
        "-webkit-mask-box-image-source"?: string | undefined;
        "-webkit-mask-box-image-width"?: import("csstype").MaskBorderWidthProperty<string | number> | undefined;
        "-webkit-mask-clip"?: string | undefined;
        "-webkit-mask-composite"?: string | undefined;
        "-webkit-mask-image"?: string | undefined;
        "-webkit-mask-origin"?: string | undefined;
        "-webkit-mask-position"?: import("csstype").WebkitMaskPositionProperty<string | number> | undefined;
        "-webkit-mask-position-x"?: import("csstype").WebkitMaskPositionXProperty<string | number> | undefined;
        "-webkit-mask-position-y"?: import("csstype").WebkitMaskPositionYProperty<string | number> | undefined;
        "-webkit-mask-repeat"?: string | undefined;
        "-webkit-mask-repeat-x"?: import("csstype").WebkitMaskRepeatXProperty | undefined;
        "-webkit-mask-repeat-y"?: import("csstype").WebkitMaskRepeatYProperty | undefined;
        "-webkit-mask-size"?: import("csstype").WebkitMaskSizeProperty<string | number> | undefined;
        "-webkit-max-inline-size"?: import("csstype").MaxInlineSizeProperty<string | number> | undefined;
        "-webkit-order"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-overflow-scrolling"?: import("csstype").WebkitOverflowScrollingProperty | undefined;
        "-webkit-padding-end"?: import("csstype").PaddingInlineEndProperty<string | number> | undefined;
        "-webkit-padding-start"?: import("csstype").PaddingInlineStartProperty<string | number> | undefined;
        "-webkit-perspective"?: import("csstype").PerspectiveProperty<string | number> | undefined;
        "-webkit-perspective-origin"?: import("csstype").PerspectiveOriginProperty<string | number> | undefined;
        "-webkit-print-color-adjust"?: import("csstype").ColorAdjustProperty | undefined;
        "-webkit-ruby-position"?: string | undefined;
        "-webkit-scroll-snap-type"?: string | undefined;
        "-webkit-shape-margin"?: import("csstype").ShapeMarginProperty<string | number> | undefined;
        "-webkit-tap-highlight-color"?: string | undefined;
        "-webkit-text-combine"?: string | undefined;
        "-webkit-text-decoration-color"?: string | undefined;
        "-webkit-text-decoration-line"?: string | undefined;
        "-webkit-text-decoration-skip"?: string | undefined;
        "-webkit-text-decoration-style"?: import("csstype").TextDecorationStyleProperty | undefined;
        "-webkit-text-emphasis-color"?: string | undefined;
        "-webkit-text-emphasis-position"?: string | undefined;
        "-webkit-text-emphasis-style"?: string | undefined;
        "-webkit-text-fill-color"?: string | undefined;
        "-webkit-text-orientation"?: import("csstype").TextOrientationProperty | undefined;
        "-webkit-text-size-adjust"?: string | undefined;
        "-webkit-text-stroke-color"?: string | undefined;
        "-webkit-text-stroke-width"?: import("csstype").WebkitTextStrokeWidthProperty<string | number> | undefined;
        "-webkit-text-underline-position"?: string | undefined;
        "-webkit-touch-callout"?: import("csstype").WebkitTouchCalloutProperty | undefined;
        "-webkit-transform"?: string | undefined;
        "-webkit-transform-origin"?: import("csstype").TransformOriginProperty<string | number> | undefined;
        "-webkit-transform-style"?: import("csstype").TransformStyleProperty | undefined;
        "-webkit-transition-delay"?: string | undefined;
        "-webkit-transition-duration"?: string | undefined;
        "-webkit-transition-property"?: string | undefined;
        "-webkit-transition-timing-function"?: string | undefined;
        "-webkit-user-modify"?: import("csstype").WebkitUserModifyProperty | undefined;
        "-webkit-user-select"?: import("csstype").UserSelectProperty | undefined;
        "-webkit-writing-mode"?: import("csstype").WritingModeProperty | undefined;
        "-moz-animation"?: import("csstype").AnimationProperty | undefined;
        "-moz-border-image"?: import("csstype").BorderImageProperty | undefined;
        "-moz-column-rule"?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        "-moz-columns"?: import("csstype").ColumnsProperty<string | number> | undefined;
        "-moz-transition"?: string | undefined;
        "-ms-content-zoom-limit"?: string | undefined;
        "-ms-content-zoom-snap"?: string | undefined;
        "-ms-flex"?: import("csstype").FlexProperty<string | number> | undefined;
        "-ms-scroll-limit"?: string | undefined;
        "-ms-scroll-snap-x"?: string | undefined;
        "-ms-scroll-snap-y"?: string | undefined;
        "-ms-transition"?: string | undefined;
        "-webkit-animation"?: import("csstype").AnimationProperty | undefined;
        "-webkit-border-before"?: import("csstype").WebkitBorderBeforeProperty<string | number> | undefined;
        "-webkit-border-image"?: import("csstype").BorderImageProperty | undefined;
        "-webkit-border-radius"?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        "-webkit-column-rule"?: import("csstype").ColumnRuleProperty<string | number> | undefined;
        "-webkit-columns"?: import("csstype").ColumnsProperty<string | number> | undefined;
        "-webkit-flex"?: import("csstype").FlexProperty<string | number> | undefined;
        "-webkit-flex-flow"?: string | undefined;
        "-webkit-mask"?: import("csstype").WebkitMaskProperty<string | number> | undefined;
        "-webkit-mask-box-image"?: import("csstype").MaskBorderProperty | undefined;
        "-webkit-text-emphasis"?: string | undefined;
        "-webkit-text-stroke"?: import("csstype").WebkitTextStrokeProperty<string | number> | undefined;
        "-webkit-transition"?: string | undefined;
        "box-align"?: import("csstype").BoxAlignProperty | undefined;
        "box-direction"?: import("csstype").BoxDirectionProperty | undefined;
        "box-flex"?: import("csstype").GlobalsNumber | undefined;
        "box-flex-group"?: import("csstype").GlobalsNumber | undefined;
        "box-lines"?: import("csstype").BoxLinesProperty | undefined;
        "box-ordinal-group"?: import("csstype").GlobalsNumber | undefined;
        "box-orient"?: import("csstype").BoxOrientProperty | undefined;
        "box-pack"?: import("csstype").BoxPackProperty | undefined;
        "font-variant-alternates"?: string | undefined;
        "grid-column-gap"?: import("csstype").GridColumnGapProperty<string | number> | undefined;
        "grid-gap"?: import("csstype").GridGapProperty<string | number> | undefined;
        "grid-row-gap"?: import("csstype").GridRowGapProperty<string | number> | undefined;
        "ime-mode"?: import("csstype").ImeModeProperty | undefined;
        "offset-block"?: import("csstype").InsetBlockProperty<string | number> | undefined;
        "offset-block-end"?: import("csstype").InsetBlockEndProperty<string | number> | undefined;
        "offset-block-start"?: import("csstype").InsetBlockStartProperty<string | number> | undefined;
        "offset-inline"?: import("csstype").InsetInlineProperty<string | number> | undefined;
        "offset-inline-end"?: import("csstype").InsetInlineEndProperty<string | number> | undefined;
        "offset-inline-start"?: import("csstype").InsetInlineStartProperty<string | number> | undefined;
        "scroll-snap-coordinate"?: import("csstype").ScrollSnapCoordinateProperty<string | number> | undefined;
        "scroll-snap-destination"?: import("csstype").ScrollSnapDestinationProperty<string | number> | undefined;
        "scroll-snap-points-x"?: string | undefined;
        "scroll-snap-points-y"?: string | undefined;
        "scroll-snap-type-x"?: import("csstype").ScrollSnapTypeXProperty | undefined;
        "scroll-snap-type-y"?: import("csstype").ScrollSnapTypeYProperty | undefined;
        "scrollbar-track-color"?: string | undefined;
        "-khtml-box-align"?: import("csstype").BoxAlignProperty | undefined;
        "-khtml-box-direction"?: import("csstype").BoxDirectionProperty | undefined;
        "-khtml-box-flex"?: import("csstype").GlobalsNumber | undefined;
        "-khtml-box-flex-group"?: import("csstype").GlobalsNumber | undefined;
        "-khtml-box-lines"?: import("csstype").BoxLinesProperty | undefined;
        "-khtml-box-ordinal-group"?: import("csstype").GlobalsNumber | undefined;
        "-khtml-box-orient"?: import("csstype").BoxOrientProperty | undefined;
        "-khtml-box-pack"?: import("csstype").BoxPackProperty | undefined;
        "-khtml-line-break"?: import("csstype").LineBreakProperty | undefined;
        "-khtml-opacity"?: import("csstype").OpacityProperty | undefined;
        "-khtml-user-select"?: import("csstype").UserSelectProperty | undefined;
        "-moz-background-clip"?: string | undefined;
        "-moz-background-inline-policy"?: import("csstype").BoxDecorationBreakProperty | undefined;
        "-moz-background-origin"?: string | undefined;
        "-moz-background-size"?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        "-moz-binding"?: string | undefined;
        "-moz-border-radius"?: import("csstype").BorderRadiusProperty<string | number> | undefined;
        "-moz-border-radius-bottomleft"?: import("csstype").BorderBottomLeftRadiusProperty<string | number> | undefined;
        "-moz-border-radius-bottomright"?: import("csstype").BorderBottomRightRadiusProperty<string | number> | undefined;
        "-moz-border-radius-topleft"?: import("csstype").BorderTopLeftRadiusProperty<string | number> | undefined;
        "-moz-border-radius-topright"?: import("csstype").BorderTopRightRadiusProperty<string | number> | undefined;
        "-moz-box-align"?: import("csstype").BoxAlignProperty | undefined;
        "-moz-box-direction"?: import("csstype").BoxDirectionProperty | undefined;
        "-moz-box-flex"?: import("csstype").GlobalsNumber | undefined;
        "-moz-box-ordinal-group"?: import("csstype").GlobalsNumber | undefined;
        "-moz-box-orient"?: import("csstype").BoxOrientProperty | undefined;
        "-moz-box-pack"?: import("csstype").BoxPackProperty | undefined;
        "-moz-box-shadow"?: string | undefined;
        "-moz-float-edge"?: import("csstype").MozFloatEdgeProperty | undefined;
        "-moz-force-broken-image-icon"?: import("csstype").MozForceBrokenImageIconProperty | undefined;
        "-moz-opacity"?: import("csstype").OpacityProperty | undefined;
        "-moz-outline"?: import("csstype").OutlineProperty<string | number> | undefined;
        "-moz-outline-color"?: string | undefined;
        "-moz-outline-radius"?: import("csstype").MozOutlineRadiusProperty<string | number> | undefined;
        "-moz-outline-radius-bottomleft"?: import("csstype").MozOutlineRadiusBottomleftProperty<string | number> | undefined;
        "-moz-outline-radius-bottomright"?: import("csstype").MozOutlineRadiusBottomrightProperty<string | number> | undefined;
        "-moz-outline-radius-topleft"?: import("csstype").MozOutlineRadiusTopleftProperty<string | number> | undefined;
        "-moz-outline-radius-topright"?: import("csstype").MozOutlineRadiusToprightProperty<string | number> | undefined;
        "-moz-outline-style"?: string | undefined;
        "-moz-outline-width"?: import("csstype").OutlineWidthProperty<string | number> | undefined;
        "-moz-text-align-last"?: import("csstype").TextAlignLastProperty | undefined;
        "-moz-text-decoration-color"?: string | undefined;
        "-moz-text-decoration-line"?: string | undefined;
        "-moz-text-decoration-style"?: import("csstype").TextDecorationStyleProperty | undefined;
        "-moz-user-input"?: import("csstype").MozUserInputProperty | undefined;
        "-ms-ime-mode"?: import("csstype").ImeModeProperty | undefined;
        "-ms-scrollbar-track-color"?: string | undefined;
        "-o-animation"?: import("csstype").AnimationProperty | undefined;
        "-o-animation-delay"?: string | undefined;
        "-o-animation-direction"?: string | undefined;
        "-o-animation-duration"?: string | undefined;
        "-o-animation-fill-mode"?: string | undefined;
        "-o-animation-iteration-count"?: import("csstype").AnimationIterationCountProperty | undefined;
        "-o-animation-name"?: string | undefined;
        "-o-animation-play-state"?: string | undefined;
        "-o-animation-timing-function"?: string | undefined;
        "-o-background-size"?: import("csstype").BackgroundSizeProperty<string | number> | undefined;
        "-o-border-image"?: import("csstype").BorderImageProperty | undefined;
        "-o-object-fit"?: import("csstype").ObjectFitProperty | undefined;
        "-o-object-position"?: import("csstype").ObjectPositionProperty<string | number> | undefined;
        "-o-tab-size"?: import("csstype").TabSizeProperty<string | number> | undefined;
        "-o-text-overflow"?: string | undefined;
        "-o-transform"?: string | undefined;
        "-o-transform-origin"?: import("csstype").TransformOriginProperty<string | number> | undefined;
        "-o-transition"?: string | undefined;
        "-o-transition-delay"?: string | undefined;
        "-o-transition-duration"?: string | undefined;
        "-o-transition-property"?: string | undefined;
        "-o-transition-timing-function"?: string | undefined;
        "-webkit-box-align"?: import("csstype").BoxAlignProperty | undefined;
        "-webkit-box-direction"?: import("csstype").BoxDirectionProperty | undefined;
        "-webkit-box-flex"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-box-flex-group"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-box-lines"?: import("csstype").BoxLinesProperty | undefined;
        "-webkit-box-ordinal-group"?: import("csstype").GlobalsNumber | undefined;
        "-webkit-box-orient"?: import("csstype").BoxOrientProperty | undefined;
        "-webkit-box-pack"?: import("csstype").BoxPackProperty | undefined;
        "-webkit-scroll-snap-points-x"?: string | undefined;
        "-webkit-scroll-snap-points-y"?: string | undefined;
        "alignment-baseline"?: import("csstype").AlignmentBaselineProperty | undefined;
        "baseline-shift"?: import("csstype").BaselineShiftProperty<string | number> | undefined;
        "clip-rule"?: import("csstype").ClipRuleProperty | undefined;
        "color-interpolation"?: import("csstype").ColorInterpolationProperty | undefined;
        "color-rendering"?: import("csstype").ColorRenderingProperty | undefined;
        "dominant-baseline"?: import("csstype").DominantBaselineProperty | undefined;
        "fill-opacity"?: import("csstype").GlobalsNumber | undefined;
        "fill-rule"?: import("csstype").FillRuleProperty | undefined;
        "flood-color"?: string | undefined;
        "flood-opacity"?: import("csstype").GlobalsNumber | undefined;
        "glyph-orientation-vertical"?: import("csstype").GlyphOrientationVerticalProperty | undefined;
        "lighting-color"?: string | undefined;
        "marker-end"?: string | undefined;
        "marker-mid"?: string | undefined;
        "marker-start"?: string | undefined;
        "shape-rendering"?: import("csstype").ShapeRenderingProperty | undefined;
        "stop-color"?: string | undefined;
        "stop-opacity"?: import("csstype").GlobalsNumber | undefined;
        "stroke-dasharray"?: import("csstype").StrokeDasharrayProperty<string | number> | undefined;
        "stroke-dashoffset"?: import("csstype").StrokeDashoffsetProperty<string | number> | undefined;
        "stroke-linecap"?: import("csstype").StrokeLinecapProperty | undefined;
        "stroke-linejoin"?: import("csstype").StrokeLinejoinProperty | undefined;
        "stroke-miterlimit"?: import("csstype").GlobalsNumber | undefined;
        "stroke-opacity"?: import("csstype").GlobalsNumber | undefined;
        "stroke-width"?: import("csstype").StrokeWidthProperty<string | number> | undefined;
        "text-anchor"?: import("csstype").TextAnchorProperty | undefined;
        "vector-effect"?: import("csstype").VectorEffectProperty | undefined;
    }>;
    showInput: import("vue").Ref<boolean>;
    inputValue: import("vue").Ref<string>;
    inputPlaceholder: import("vue").Ref<string>;
    inputType: import("vue").Ref<string>;
    inputPattern: import("vue").Ref<{
        exec: (string: string) => RegExpExecArray | null;
        test: (string: string) => boolean;
        readonly source: string;
        readonly global: boolean;
        readonly ignoreCase: boolean;
        readonly multiline: boolean;
        lastIndex: number;
        compile: (pattern: string, flags?: string | undefined) => RegExp;
        readonly flags: string;
        readonly sticky: boolean;
        readonly unicode: boolean;
        readonly dotAll: boolean;
        [Symbol.match]: (string: string) => RegExpMatchArray | null;
        [Symbol.replace]: {
            (string: string, replaceValue: string): string;
            (string: string, replacer: (substring: string, ...args: any[]) => string): string;
        };
        [Symbol.search]: (string: string) => number;
        [Symbol.split]: (string: string, limit?: number | undefined) => string[];
        [Symbol.matchAll]: (str: string) => IterableIterator<RegExpMatchArray>;
    }>;
    inputValidator: import("vue").Ref<import("./message-box.type").MessageBoxInputValidator>;
    inputErrorMessage: import("vue").Ref<string>;
    showConfirmButton: import("vue").Ref<boolean>;
    showCancelButton: import("vue").Ref<boolean>;
    action: import("vue").Ref<Action>;
    dangerouslyUseHTMLString: import("vue").Ref<boolean>;
    confirmButtonText: import("vue").Ref<string>;
    cancelButtonText: import("vue").Ref<string>;
    confirmButtonLoading: import("vue").Ref<boolean>;
    cancelButtonLoading: import("vue").Ref<boolean>;
    confirmButtonClass: import("vue").Ref<string>;
    confirmButtonDisabled: import("vue").Ref<boolean>;
    cancelButtonClass: import("vue").Ref<string>;
    editorErrorMessage: import("vue").Ref<string>;
    beforeClose: import("vue").Ref<((action: Action, instance: MessageBoxState, done: () => void) => void) | null>;
    callback: import("vue").Ref<import("./message-box.type").Callback | null>;
    distinguishCancelAndClose: import("vue").Ref<boolean>;
    modalFade: import("vue").Ref<boolean>;
    modalClass: import("vue").Ref<string>;
    validateError: import("vue").Ref<boolean>;
    zIndex: import("vue").Ref<number>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("vanish" | "action")[], "action" | "vanish", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    buttonSize: {
        type: PropType<"default" | "small" | "large">;
        validator: (val: string) => val is "" | "default" | "small" | "large";
    };
    modal: {
        type: BooleanConstructor;
        default: boolean;
    };
    lockScroll: {
        type: BooleanConstructor;
        default: boolean;
    };
    showClose: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnClickModal: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnPressEscape: {
        type: BooleanConstructor;
        default: boolean;
    };
    closeOnHashChange: {
        type: BooleanConstructor;
        default: boolean;
    };
    center: BooleanConstructor;
    draggable: BooleanConstructor;
    roundButton: {
        default: boolean;
        type: BooleanConstructor;
    };
    container: {
        type: StringConstructor;
        default: string;
    };
    boxType: {
        type: PropType<MessageBoxType>;
        default: string;
    };
}>> & {
    onVanish?: ((...args: any[]) => any) | undefined;
    onAction?: ((...args: any[]) => any) | undefined;
}, {
    center: boolean;
    draggable: boolean;
    showClose: boolean;
    closeOnClickModal: boolean;
    closeOnPressEscape: boolean;
    lockScroll: boolean;
    modal: boolean;
    container: string;
    boxType: MessageBoxType;
    roundButton: boolean;
    closeOnHashChange: boolean;
}>;
export default _default;
