'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var core = require('@vueuse/core');
require('../../../utils/index.js');
require('../../../constants/index.js');
var index = require('../../icon/index.js');
require('../../../hooks/index.js');
var notification = require('./notification.js');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var icon = require('../../../utils/vue/icon.js');
var index$1 = require('../../../hooks/use-namespace/index.js');
var aria = require('../../../constants/aria.js');

const _sfc_main = vue.defineComponent({
  name: "ElNotification",
  components: {
    ElIcon: index.ElIcon,
    ...icon.TypeComponents
  },
  props: notification.notificationProps,
  emits: notification.notificationEmits,
  setup(props) {
    const ns = index$1.useNamespace("notification");
    const visible = vue.ref(false);
    let timer = void 0;
    const typeClass = vue.computed(() => {
      const type = props.type;
      return type && icon.TypeComponentsMap[props.type] ? ns.m(type) : "";
    });
    const iconComponent = vue.computed(() => {
      return icon.TypeComponentsMap[props.type] || props.icon || "";
    });
    const horizontalClass = vue.computed(() => props.position.endsWith("right") ? "right" : "left");
    const verticalProperty = vue.computed(() => props.position.startsWith("top") ? "top" : "bottom");
    const positionStyle = vue.computed(() => {
      return {
        [verticalProperty.value]: `${props.offset}px`,
        zIndex: props.zIndex
      };
    });
    function startTimer() {
      if (props.duration > 0) {
        ;
        ({ stop: timer } = core.useTimeoutFn(() => {
          if (visible.value)
            close();
        }, props.duration));
      }
    }
    function clearTimer() {
      timer == null ? void 0 : timer();
    }
    function close() {
      visible.value = false;
    }
    function onKeydown({ code }) {
      if (code === aria.EVENT_CODE.delete || code === aria.EVENT_CODE.backspace) {
        clearTimer();
      } else if (code === aria.EVENT_CODE.esc) {
        if (visible.value) {
          close();
        }
      } else {
        startTimer();
      }
    }
    vue.onMounted(() => {
      startTimer();
      visible.value = true;
    });
    core.useEventListener(document, "keydown", onKeydown);
    return {
      ns,
      horizontalClass,
      typeClass,
      iconComponent,
      positionStyle,
      visible,
      close,
      clearTimer,
      startTimer
    };
  }
});
const _hoisted_1 = ["id"];
const _hoisted_2 = ["textContent"];
const _hoisted_3 = { key: 0 };
const _hoisted_4 = ["innerHTML"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_icon = vue.resolveComponent("el-icon");
  const _component_close = vue.resolveComponent("close");
  return vue.openBlock(), vue.createBlock(vue.Transition, {
    name: _ctx.ns.b("fade"),
    onBeforeLeave: _ctx.onClose,
    onAfterLeave: _cache[3] || (_cache[3] = ($event) => _ctx.$emit("destroy"))
  }, {
    default: vue.withCtx(() => [
      vue.withDirectives(vue.createElementVNode("div", {
        id: _ctx.id,
        class: vue.normalizeClass([_ctx.ns.b(), _ctx.customClass, _ctx.horizontalClass]),
        style: vue.normalizeStyle(_ctx.positionStyle),
        role: "alert",
        onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.clearTimer && _ctx.clearTimer(...args)),
        onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.startTimer && _ctx.startTimer(...args)),
        onClick: _cache[2] || (_cache[2] = (...args) => _ctx.onClick && _ctx.onClick(...args))
      }, [
        _ctx.iconComponent ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
          key: 0,
          class: vue.normalizeClass([_ctx.ns.e("icon"), _ctx.typeClass])
        }, {
          default: vue.withCtx(() => [
            (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.iconComponent)))
          ]),
          _: 1
        }, 8, ["class"])) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("div", {
          class: vue.normalizeClass(_ctx.ns.e("group"))
        }, [
          vue.createElementVNode("h2", {
            class: vue.normalizeClass(_ctx.ns.e("title")),
            textContent: vue.toDisplayString(_ctx.title)
          }, null, 10, _hoisted_2),
          vue.withDirectives(vue.createElementVNode("div", {
            class: vue.normalizeClass(_ctx.ns.e("content")),
            style: vue.normalizeStyle(!!_ctx.title ? void 0 : { margin: 0 })
          }, [
            vue.renderSlot(_ctx.$slots, "default", {}, () => [
              !_ctx.dangerouslyUseHTMLString ? (vue.openBlock(), vue.createElementBlock("p", _hoisted_3, vue.toDisplayString(_ctx.message), 1)) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
                vue.createCommentVNode(" Caution here, message could've been compromized, nerver use user's input as message "),
                vue.createCommentVNode(" eslint-disable-next-line "),
                vue.createElementVNode("p", { innerHTML: _ctx.message }, null, 8, _hoisted_4)
              ], 2112))
            ])
          ], 6), [
            [vue.vShow, _ctx.message]
          ]),
          _ctx.showClose ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
            key: 0,
            class: vue.normalizeClass(_ctx.ns.e("closeBtn")),
            onClick: vue.withModifiers(_ctx.close, ["stop"])
          }, {
            default: vue.withCtx(() => [
              vue.createVNode(_component_close)
            ]),
            _: 1
          }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true)
        ], 2)
      ], 46, _hoisted_1), [
        [vue.vShow, _ctx.visible]
      ])
    ]),
    _: 3
  }, 8, ["name", "onBeforeLeave"]);
}
var NotificationConstructor = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render]]);

exports["default"] = NotificationConstructor;
//# sourceMappingURL=notification2.js.map
