'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
var index = require('../../checkbox/index.js');
var index$1 = require('../../input/index.js');
var iconsVue = require('@element-plus/icons-vue');
var useCheck = require('./useCheck.js');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var index$2 = require('../../../hooks/use-locale/index.js');
var index$3 = require('../../../hooks/use-namespace/index.js');

const _sfc_main = vue.defineComponent({
  name: "ElTransferPanel",
  components: {
    ElCheckboxGroup: index.ElCheckboxGroup,
    ElCheckbox: index.ElCheckbox,
    ElInput: index$1.ElInput,
    OptionContent: ({ option }) => option
  },
  props: useCheck.useCheckProps,
  emits: [useCheck.CHECKED_CHANGE_EVENT],
  setup(props, { slots }) {
    const { t } = index$2.useLocale();
    const ns = index$3.useNamespace("transfer");
    const panelState = vue.reactive({
      checked: [],
      allChecked: false,
      query: "",
      inputHover: false,
      checkChangeByUser: true
    });
    const {
      labelProp,
      keyProp,
      disabledProp,
      filteredData,
      checkedSummary,
      isIndeterminate,
      handleAllCheckedChange
    } = useCheck.useCheck(props, panelState);
    const hasNoMatch = vue.computed(() => {
      return panelState.query.length > 0 && filteredData.value.length === 0;
    });
    const hasFooter = vue.computed(() => !!slots.default()[0].children.length);
    const { checked, allChecked, query, inputHover, checkChangeByUser } = vue.toRefs(panelState);
    return {
      ns,
      labelProp,
      keyProp,
      disabledProp,
      filteredData,
      checkedSummary,
      isIndeterminate,
      handleAllCheckedChange,
      checked,
      allChecked,
      query,
      inputHover,
      checkChangeByUser,
      hasNoMatch,
      SearchIcon: iconsVue.Search,
      hasFooter,
      t
    };
  }
});
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_checkbox = vue.resolveComponent("el-checkbox");
  const _component_el_input = vue.resolveComponent("el-input");
  const _component_option_content = vue.resolveComponent("option-content");
  const _component_el_checkbox_group = vue.resolveComponent("el-checkbox-group");
  return vue.openBlock(), vue.createElementBlock("div", {
    class: vue.normalizeClass(_ctx.ns.b("panel"))
  }, [
    vue.createElementVNode("p", {
      class: vue.normalizeClass(_ctx.ns.be("panel", "header"))
    }, [
      vue.createVNode(_component_el_checkbox, {
        modelValue: _ctx.allChecked,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.allChecked = $event),
        indeterminate: _ctx.isIndeterminate,
        onChange: _ctx.handleAllCheckedChange
      }, {
        default: vue.withCtx(() => [
          vue.createTextVNode(vue.toDisplayString(_ctx.title) + " ", 1),
          vue.createElementVNode("span", null, vue.toDisplayString(_ctx.checkedSummary), 1)
        ]),
        _: 1
      }, 8, ["modelValue", "indeterminate", "onChange"])
    ], 2),
    vue.createElementVNode("div", {
      class: vue.normalizeClass([_ctx.ns.be("panel", "body"), _ctx.ns.is("with-footer", _ctx.hasFooter)])
    }, [
      _ctx.filterable ? (vue.openBlock(), vue.createBlock(_component_el_input, {
        key: 0,
        modelValue: _ctx.query,
        "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => _ctx.query = $event),
        class: vue.normalizeClass(_ctx.ns.be("panel", "filter")),
        size: "default",
        placeholder: _ctx.placeholder,
        "prefix-icon": _ctx.SearchIcon,
        clearable: "",
        onMouseenter: _cache[2] || (_cache[2] = ($event) => _ctx.inputHover = true),
        onMouseleave: _cache[3] || (_cache[3] = ($event) => _ctx.inputHover = false)
      }, null, 8, ["modelValue", "class", "placeholder", "prefix-icon"])) : vue.createCommentVNode("v-if", true),
      vue.withDirectives(vue.createVNode(_component_el_checkbox_group, {
        modelValue: _ctx.checked,
        "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.checked = $event),
        class: vue.normalizeClass([_ctx.ns.is("filterable", _ctx.filterable), _ctx.ns.be("panel", "list")])
      }, {
        default: vue.withCtx(() => [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.filteredData, (item) => {
            return vue.openBlock(), vue.createBlock(_component_el_checkbox, {
              key: item[_ctx.keyProp],
              class: vue.normalizeClass(_ctx.ns.be("panel", "item")),
              label: item[_ctx.keyProp],
              disabled: item[_ctx.disabledProp]
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_option_content, {
                  option: _ctx.optionRender(item)
                }, null, 8, ["option"])
              ]),
              _: 2
            }, 1032, ["class", "label", "disabled"]);
          }), 128))
        ]),
        _: 1
      }, 8, ["modelValue", "class"]), [
        [vue.vShow, !_ctx.hasNoMatch && _ctx.data.length > 0]
      ]),
      vue.withDirectives(vue.createElementVNode("p", {
        class: vue.normalizeClass(_ctx.ns.be("panel", "empty"))
      }, vue.toDisplayString(_ctx.hasNoMatch ? _ctx.t("el.transfer.noMatch") : _ctx.t("el.transfer.noData")), 3), [
        [vue.vShow, _ctx.hasNoMatch || _ctx.data.length === 0]
      ])
    ], 2),
    _ctx.hasFooter ? (vue.openBlock(), vue.createElementBlock("p", {
      key: 0,
      class: vue.normalizeClass(_ctx.ns.be("panel", "footer"))
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 2)) : vue.createCommentVNode("v-if", true)
  ], 2);
}
var TransferPanel = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render]]);

exports["default"] = TransferPanel;
//# sourceMappingURL=transfer-panel.js.map
