import { defineComponent, ref, watch, watchEffect, openBlock, createElementBlock, createElementVNode, Fragment, renderList, normalizeClass, normalizeStyle } from 'vue';
import { useOptions } from '../useOption.mjs';
import Color from '../color.mjs';
import _export_sfc from '../../../../_virtual/plugin-vue_export-helper.mjs';

const _sfc_main = defineComponent({
  props: {
    colors: { type: Array, required: true },
    color: {
      type: Object,
      required: true
    }
  },
  setup(props) {
    const { currentColor } = useOptions();
    const rgbaColors = ref(parseColors(props.colors, props.color));
    watch(() => currentColor.value, (val) => {
      const color = new Color();
      color.fromString(val);
      rgbaColors.value.forEach((item) => {
        item.selected = color.compare(item);
      });
    });
    watchEffect(() => {
      rgbaColors.value = parseColors(props.colors, props.color);
    });
    function handleSelect(index) {
      props.color.fromString(props.colors[index]);
    }
    function parseColors(colors, color) {
      return colors.map((value) => {
        const c = new Color();
        c.enableAlpha = true;
        c.format = "rgba";
        c.fromString(value);
        c.selected = c.value === color.value;
        return c;
      });
    }
    return {
      rgbaColors,
      handleSelect
    };
  }
});
const _hoisted_1 = { class: "el-color-predefine" };
const _hoisted_2 = { class: "el-color-predefine__colors" };
const _hoisted_3 = ["onClick"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1, [
    createElementVNode("div", _hoisted_2, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.rgbaColors, (item, index) => {
        return openBlock(), createElementBlock("div", {
          key: _ctx.colors[index],
          class: normalizeClass(["el-color-predefine__color-selector", { selected: item.selected, "is-alpha": item._alpha < 100 }]),
          onClick: ($event) => _ctx.handleSelect(index)
        }, [
          createElementVNode("div", {
            style: normalizeStyle({ backgroundColor: item.value })
          }, null, 4)
        ], 10, _hoisted_3);
      }), 128))
    ])
  ]);
}
var Predefine = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render], ["__file", "/home/runner/work/element-plus/element-plus/packages/components/color-picker/src/components/predefine.vue"]]);

export { Predefine as default };
//# sourceMappingURL=predefine.mjs.map
