import { isClient } from '@vueuse/core';
import '../../../utils/index.mjs';
import { off, on } from '../../../utils/dom/event.mjs';

let isDragging = false;
function draggable(element, options) {
  if (!isClient)
    return;
  const moveFn = function(event) {
    var _a;
    (_a = options.drag) == null ? void 0 : _a.call(options, event);
  };
  const upFn = function(event) {
    var _a;
    off(document, "mousemove", moveFn);
    off(document, "mouseup", upFn);
    off(document, "touchmove", moveFn);
    off(document, "touchend", upFn);
    document.onselectstart = null;
    document.ondragstart = null;
    isDragging = false;
    (_a = options.end) == null ? void 0 : _a.call(options, event);
  };
  const downFn = function(event) {
    var _a;
    if (isDragging)
      return;
    event.preventDefault();
    document.onselectstart = () => false;
    document.ondragstart = () => false;
    on(document, "mousemove", moveFn);
    on(document, "mouseup", upFn);
    on(document, "touchmove", moveFn);
    on(document, "touchend", upFn);
    isDragging = true;
    (_a = options.start) == null ? void 0 : _a.call(options, event);
  };
  on(element, "mousedown", downFn);
  on(element, "touchstart", downFn);
}

export { draggable as default };
//# sourceMappingURL=draggable.mjs.map
