import type { CSSProperties, Ref } from 'vue';
import type { Column, Columns, KeyType } from './types';
declare type AnyColumn = Columns<any>;
declare function useColumns(columns: Ref<AnyColumn>, fixed: Ref<boolean>): {
    columns: Ref<AnyColumn>;
    columnsStyles: import("vue").ComputedRef<Record<KeyType, CSSProperties>>;
    columnsTotalWidth: import("vue").ComputedRef<number>;
    fixedColumnsOnLeft: import("vue").ComputedRef<Column<any>[]>;
    fixedColumnOnRight: import("vue").ComputedRef<Column<any>[]>;
    hasFixedColumns: import("vue").ComputedRef<number>;
    mainColumns: import("vue").ComputedRef<AnyColumn>;
    normalColumns: import("vue").ComputedRef<Column<any>[]>;
    visibleColumns: import("vue").ComputedRef<Column<any>[]>;
    getColumn: (key: KeyType) => Column<any> | undefined;
    getColumnStyle: (key: KeyType) => CSSProperties;
    updateColumnWidth: (column: Column<any>, width: number) => void;
};
export { useColumns };
