import { computed, unref } from 'vue';
import { placeholderSign } from './private.mjs';

const calcColumnStyle = (column, fixedColumn) => {
  var _a;
  const flex = {
    flexGrow: 0,
    flexShrink: 0
  };
  if (column.fixed) {
    flex.flexShrink = 1;
  }
  const style = {
    ...(_a = column.style) != null ? _a : {},
    ...flex,
    flexBasis: "auto",
    width: column.width
  };
  if (!fixedColumn) {
    if (column.maxWidth)
      style.maxWidth = column.maxWidth;
    if (column.minWidth)
      style.maxWidth = column.minWidth;
  }
  return style;
};
function useColumns(columns, fixed) {
  const visibleColumns = computed(() => {
    return unref(columns).filter((column) => !column.hidden);
  });
  const fixedColumnsOnLeft = computed(() => unref(visibleColumns).filter((column) => column.fixed === "left" || column.fixed === true));
  const fixedColumnOnRight = computed(() => unref(visibleColumns).filter((column) => column.fixed === "right"));
  const normalColumns = computed(() => unref(visibleColumns).filter((column) => !column.fixed));
  const mainColumns = computed(() => {
    const ret = [];
    unref(fixedColumnsOnLeft).forEach((column) => {
      ret.push({
        ...column,
        placeholderSign
      });
    });
    unref(normalColumns).forEach((column) => {
      ret.push(column);
    });
    unref(fixedColumnOnRight).forEach((column) => {
      ret.push({
        ...column,
        placeholderSign
      });
    });
    return ret;
  });
  const hasFixedColumns = computed(() => {
    return unref(fixedColumnsOnLeft).length || unref(fixedColumnOnRight).length;
  });
  const columnsStyles = computed(() => {
    const _columns = unref(columns);
    return _columns.reduce((style, column) => {
      style[column.key] = calcColumnStyle(column, unref(fixed));
      return style;
    }, {});
  });
  const columnsTotalWidth = computed(() => {
    return unref(visibleColumns).reduce((width, column) => width + column.width, 0);
  });
  const getColumn = (key) => {
    return unref(columns).find((column) => column.key === key);
  };
  const getColumnStyle = (key) => {
    return unref(columnsStyles)[key];
  };
  const updateColumnWidth = (column, width) => {
    column.width = width;
  };
  return {
    columns,
    columnsStyles,
    columnsTotalWidth,
    fixedColumnsOnLeft,
    fixedColumnOnRight,
    hasFixedColumns,
    mainColumns,
    normalColumns,
    visibleColumns,
    getColumn,
    getColumnStyle,
    updateColumnWidth
  };
}

export { useColumns };
//# sourceMappingURL=use-columns.mjs.map
