import { defineComponent, reactive, computed, toRefs, resolveComponent, openBlock, createElementBlock, normalizeClass, createElementVNode, createVNode, withCtx, createTextVNode, toDisplayString, createBlock, createCommentVNode, withDirectives, Fragment, renderList, vShow, renderSlot } from 'vue';
import '../../../hooks/index.mjs';
import { ElCheckboxGroup, ElCheckbox } from '../../checkbox/index.mjs';
import { ElInput } from '../../input/index.mjs';
import { Search } from '@element-plus/icons-vue';
import { useCheckProps, CHECKED_CHANGE_EVENT, useCheck } from './useCheck.mjs';
import _export_sfc from '../../../_virtual/plugin-vue_export-helper.mjs';
import { useLocale } from '../../../hooks/use-locale/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

const _sfc_main = defineComponent({
  name: "ElTransferPanel",
  components: {
    ElCheckboxGroup,
    ElCheckbox,
    ElInput,
    OptionContent: ({ option }) => option
  },
  props: useCheckProps,
  emits: [CHECKED_CHANGE_EVENT],
  setup(props, { slots }) {
    const { t } = useLocale();
    const ns = useNamespace("transfer");
    const panelState = reactive({
      checked: [],
      allChecked: false,
      query: "",
      inputHover: false,
      checkChangeByUser: true
    });
    const {
      labelProp,
      keyProp,
      disabledProp,
      filteredData,
      checkedSummary,
      isIndeterminate,
      handleAllCheckedChange
    } = useCheck(props, panelState);
    const hasNoMatch = computed(() => {
      return panelState.query.length > 0 && filteredData.value.length === 0;
    });
    const hasFooter = computed(() => !!slots.default()[0].children.length);
    const { checked, allChecked, query, inputHover, checkChangeByUser } = toRefs(panelState);
    return {
      ns,
      labelProp,
      keyProp,
      disabledProp,
      filteredData,
      checkedSummary,
      isIndeterminate,
      handleAllCheckedChange,
      checked,
      allChecked,
      query,
      inputHover,
      checkChangeByUser,
      hasNoMatch,
      SearchIcon: Search,
      hasFooter,
      t
    };
  }
});
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_checkbox = resolveComponent("el-checkbox");
  const _component_el_input = resolveComponent("el-input");
  const _component_option_content = resolveComponent("option-content");
  const _component_el_checkbox_group = resolveComponent("el-checkbox-group");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.ns.b("panel"))
  }, [
    createElementVNode("p", {
      class: normalizeClass(_ctx.ns.be("panel", "header"))
    }, [
      createVNode(_component_el_checkbox, {
        modelValue: _ctx.allChecked,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.allChecked = $event),
        indeterminate: _ctx.isIndeterminate,
        onChange: _ctx.handleAllCheckedChange
      }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(_ctx.title) + " ", 1),
          createElementVNode("span", null, toDisplayString(_ctx.checkedSummary), 1)
        ]),
        _: 1
      }, 8, ["modelValue", "indeterminate", "onChange"])
    ], 2),
    createElementVNode("div", {
      class: normalizeClass([_ctx.ns.be("panel", "body"), _ctx.ns.is("with-footer", _ctx.hasFooter)])
    }, [
      _ctx.filterable ? (openBlock(), createBlock(_component_el_input, {
        key: 0,
        modelValue: _ctx.query,
        "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => _ctx.query = $event),
        class: normalizeClass(_ctx.ns.be("panel", "filter")),
        size: "default",
        placeholder: _ctx.placeholder,
        "prefix-icon": _ctx.SearchIcon,
        clearable: "",
        onMouseenter: _cache[2] || (_cache[2] = ($event) => _ctx.inputHover = true),
        onMouseleave: _cache[3] || (_cache[3] = ($event) => _ctx.inputHover = false)
      }, null, 8, ["modelValue", "class", "placeholder", "prefix-icon"])) : createCommentVNode("v-if", true),
      withDirectives(createVNode(_component_el_checkbox_group, {
        modelValue: _ctx.checked,
        "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.checked = $event),
        class: normalizeClass([_ctx.ns.is("filterable", _ctx.filterable), _ctx.ns.be("panel", "list")])
      }, {
        default: withCtx(() => [
          (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.filteredData, (item) => {
            return openBlock(), createBlock(_component_el_checkbox, {
              key: item[_ctx.keyProp],
              class: normalizeClass(_ctx.ns.be("panel", "item")),
              label: item[_ctx.keyProp],
              disabled: item[_ctx.disabledProp]
            }, {
              default: withCtx(() => [
                createVNode(_component_option_content, {
                  option: _ctx.optionRender(item)
                }, null, 8, ["option"])
              ]),
              _: 2
            }, 1032, ["class", "label", "disabled"]);
          }), 128))
        ]),
        _: 1
      }, 8, ["modelValue", "class"]), [
        [vShow, !_ctx.hasNoMatch && _ctx.data.length > 0]
      ]),
      withDirectives(createElementVNode("p", {
        class: normalizeClass(_ctx.ns.be("panel", "empty"))
      }, toDisplayString(_ctx.hasNoMatch ? _ctx.t("el.transfer.noMatch") : _ctx.t("el.transfer.noData")), 3), [
        [vShow, _ctx.hasNoMatch || _ctx.data.length === 0]
      ])
    ], 2),
    _ctx.hasFooter ? (openBlock(), createElementBlock("p", {
      key: 0,
      class: normalizeClass(_ctx.ns.be("panel", "footer"))
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var TransferPanel = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render], ["__file", "/home/runner/work/element-plus/element-plus/packages/components/transfer/src/transfer-panel.vue"]]);

export { TransferPanel as default };
//# sourceMappingURL=transfer-panel.mjs.map
