import { watch, nextTick, computed, toRefs } from 'vue';
import { isEqual, pick } from 'lodash-unified';
import '../../../constants/index.mjs';
import '../../../utils/index.mjs';
import _Tree from '../../tree/index.mjs';
import component from './tree-select-option.mjs';
import { isFunction } from '@vue/shared';
import { UPDATE_MODEL_EVENT } from '../../../constants/event.mjs';

const useTree = (props, { attrs, slots, emit }, {
  select,
  tree,
  key
}) => {
  watch(() => props.modelValue, () => {
    if (props.showCheckbox) {
      nextTick(() => {
        const treeInstance = tree.value;
        if (treeInstance && !isEqual(treeInstance.getCheckedKeys(), toValidArray(props.modelValue))) {
          treeInstance.setCheckedKeys(toValidArray(props.modelValue));
        }
      });
    }
  }, {
    immediate: true,
    deep: true
  });
  const propsMap = computed(() => ({
    value: key.value,
    ...props.props
  }));
  const getNodeValByProp = (prop, data) => {
    var _a;
    const propVal = propsMap.value[prop];
    if (isFunction(propVal)) {
      return propVal(data, (_a = tree.value) == null ? void 0 : _a.getNode(getNodeValByProp("value", data)));
    } else {
      return data[propVal];
    }
  };
  return {
    ...pick(toRefs(props), Object.keys(_Tree.props)),
    ...attrs,
    nodeKey: key,
    expandOnClickNode: computed(() => {
      return !props.checkStrictly;
    }),
    defaultExpandedKeys: computed(() => {
      const values = toValidArray(props.modelValue);
      const parentKeys = tree.value ? values.map((item) => {
        var _a, _b, _c;
        return (_c = (_b = (_a = tree.value) == null ? void 0 : _a.getNode(item)) == null ? void 0 : _b.parent) == null ? void 0 : _c.key;
      }).filter((item) => isValidValue(item)) : values;
      return props.defaultExpandedKeys ? props.defaultExpandedKeys.concat(parentKeys) : parentKeys;
    }),
    renderContent: (h, { node, data, store }) => {
      return h(component, {
        value: getNodeValByProp("value", data),
        label: getNodeValByProp("label", data),
        disabled: getNodeValByProp("disabled", data)
      }, props.renderContent ? () => props.renderContent(h, { node, data, store }) : slots.default ? () => slots.default({ node, data, store }) : void 0);
    },
    filterNodeMethod: (value, data, node) => {
      var _a;
      if (props.filterNodeMethod)
        return props.filterNodeMethod(value, data, node);
      if (!value)
        return true;
      return (_a = getNodeValByProp("label", data)) == null ? void 0 : _a.includes(value);
    },
    onNodeClick: (data, node, e) => {
      var _a, _b, _c;
      (_a = attrs.onNodeClick) == null ? void 0 : _a.call(attrs, data, node, e);
      if (props.checkStrictly || node.isLeaf) {
        if (!getNodeValByProp("disabled", data)) {
          const option = (_b = select.value) == null ? void 0 : _b.options.get(getNodeValByProp("value", data));
          (_c = select.value) == null ? void 0 : _c.handleOptionSelect(option, true);
        }
      } else {
        e.proxy.handleExpandIconClick();
      }
    },
    onCheck: (data, params) => {
      var _a, _b;
      (_a = attrs.onCheck) == null ? void 0 : _a.call(attrs, data, params);
      const checkedKeys = !props.checkStrictly ? (_b = tree.value) == null ? void 0 : _b.getCheckedKeys(true) : params.checkedKeys;
      const value = getNodeValByProp("value", data);
      emit(UPDATE_MODEL_EVENT, props.multiple ? checkedKeys : checkedKeys.includes(value) ? value : void 0);
    }
  };
};
function isValidValue(val) {
  return val || val === 0;
}
function toValidArray(val) {
  return Array.isArray(val) ? val : isValidValue(val) ? [val] : [];
}

export { useTree };
//# sourceMappingURL=tree.mjs.map
