import normalizeWheel from 'normalize-wheel-es';
import '../../utils/index.mjs';
import { isFirefox } from '../../utils/browser.mjs';

const mousewheel = function(element, callback) {
  if (element && element.addEventListener) {
    const fn = function(event) {
      const normalized = normalizeWheel(event);
      callback && Reflect.apply(callback, this, [event, normalized]);
    };
    if (isFirefox()) {
      element.addEventListener("DOMMouseScroll", fn);
    } else {
      element.onmousewheel = fn;
    }
  }
};
const Mousewheel = {
  beforeMount(el, binding) {
    mousewheel(el, binding.value);
  }
};

export { Mousewheel as default };
//# sourceMappingURL=index.mjs.map
