'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('../../../utils/index.js');
require('../../time-picker/index.js');
var dateUtils = require('../../time-picker/src/common/date-utils.js');
var props = require('../../../utils/vue/props.js');
var shared = require('@vue/shared');

const getPrevMonthLastDays = (date, count) => {
  const lastDay = date.subtract(1, "month").endOf("month").date();
  return dateUtils.rangeArr(count).map((_, index) => lastDay - (count - index - 1));
};
const getMonthDays = (date) => {
  const days = date.daysInMonth();
  return dateUtils.rangeArr(days).map((_, index) => index + 1);
};
const toNestedArr = (days) => dateUtils.rangeArr(days.length / 7).map((index) => {
  const start = index * 7;
  return days.slice(start, start + 7);
});
const dateTableProps = props.buildProps({
  selectedDay: {
    type: props.definePropType(Object)
  },
  range: {
    type: props.definePropType(Array)
  },
  date: {
    type: props.definePropType(Object),
    required: true
  },
  hideHeader: {
    type: Boolean
  }
});
const dateTableEmits = {
  pick: (value) => shared.isObject(value)
};

exports.dateTableEmits = dateTableEmits;
exports.dateTableProps = dateTableProps;
exports.getMonthDays = getMonthDays;
exports.getPrevMonthLastDays = getPrevMonthLastDays;
exports.toNestedArr = toNestedArr;
//# sourceMappingURL=date-table.js.map
