import type { InjectionKey, SetupContext } from 'vue';
import type { Dayjs } from 'dayjs';
export declare type IDatePickerType = 'year' | 'month' | 'date' | 'dates' | 'week' | 'datetime' | 'datetimerange' | 'daterange' | 'monthrange';
declare type DateCellType = 'normal' | 'today' | 'week' | 'next-month' | 'prev-month';
export interface DateCell {
    column?: number;
    customClass?: string;
    disabled?: boolean;
    end?: boolean;
    inRange?: boolean;
    row?: number;
    selected?: Dayjs;
    isCurrent?: boolean;
    isSelected?: boolean;
    start?: boolean;
    text?: number;
    timestamp?: number;
    date?: Date;
    dayjs?: Dayjs;
    type?: DateCellType;
}
interface DatePickerContext {
    ctx: SetupContext;
}
export declare const ROOT_PICKER_INJECTION_KEY: InjectionKey<DatePickerContext>;
export {};
