import type { Arrayable } from 'element-plus/es/utils';
import type { FormItemContext, FormValidateCallback, FormValidationResult } from 'element-plus/es/tokens';
import type { FormItemProp } from './form-item';
declare const _default: import("vue").DefineComponent<{
    readonly model: ObjectConstructor;
    readonly rules: import("element-plus/es/utils").BuildPropReturn<import("element-plus/es/utils").PropWrapper<Partial<Record<string, Arrayable<import("element-plus/es/tokens").FormItemRule>>>>, unknown, unknown, unknown, unknown>;
    readonly labelPosition: StringConstructor;
    readonly labelWidth: import("element-plus/es/utils").BuildPropReturn<readonly [StringConstructor, NumberConstructor], "", unknown, unknown, unknown>;
    readonly labelSuffix: import("element-plus/es/utils").BuildPropReturn<StringConstructor, "", unknown, unknown, unknown>;
    readonly inline: BooleanConstructor;
    readonly inlineMessage: BooleanConstructor;
    readonly statusIcon: BooleanConstructor;
    readonly showMessage: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
    readonly size: import("element-plus/es/utils").BuildPropReturn<StringConstructor, unknown, unknown, "" | "default" | "small" | "large", unknown>;
    readonly disabled: BooleanConstructor;
    readonly validateOnRuleChange: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
    readonly hideRequiredAsterisk: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, false, unknown, unknown, unknown>;
    readonly scrollToError: BooleanConstructor;
}, {
    COMPONENT_NAME: string;
    props: Readonly<import("@vue/shared").LooseRequired<Readonly<import("vue").ExtractPropTypes<{
        readonly model: ObjectConstructor;
        readonly rules: import("element-plus/es/utils").BuildPropReturn<import("element-plus/es/utils").PropWrapper<Partial<Record<string, Arrayable<import("element-plus/es/tokens").FormItemRule>>>>, unknown, unknown, unknown, unknown>;
        readonly labelPosition: StringConstructor;
        readonly labelWidth: import("element-plus/es/utils").BuildPropReturn<readonly [StringConstructor, NumberConstructor], "", unknown, unknown, unknown>;
        readonly labelSuffix: import("element-plus/es/utils").BuildPropReturn<StringConstructor, "", unknown, unknown, unknown>;
        readonly inline: BooleanConstructor;
        readonly inlineMessage: BooleanConstructor;
        readonly statusIcon: BooleanConstructor;
        readonly showMessage: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
        readonly size: import("element-plus/es/utils").BuildPropReturn<StringConstructor, unknown, unknown, "" | "default" | "small" | "large", unknown>;
        readonly disabled: BooleanConstructor;
        readonly validateOnRuleChange: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
        readonly hideRequiredAsterisk: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, false, unknown, unknown, unknown>;
        readonly scrollToError: BooleanConstructor;
    }>> & {
        onValidate?: ((prop: FormItemProp, isValid: boolean, message: string) => any) | undefined;
    }>>;
    emit: (event: "validate", prop: FormItemProp, isValid: boolean, message: string) => void;
    fields: FormItemContext[];
    formSize: import("vue").ComputedRef<"" | "default" | "small" | "large">;
    ns: {
        namespace: import("vue").ComputedRef<string>;
        b: (blockSuffix?: string) => string;
        e: (element?: string | undefined) => string;
        m: (modifier?: string | undefined) => string;
        be: (blockSuffix?: string | undefined, element?: string | undefined) => string;
        em: (element?: string | undefined, modifier?: string | undefined) => string;
        bm: (blockSuffix?: string | undefined, modifier?: string | undefined) => string;
        bem: (blockSuffix?: string | undefined, element?: string | undefined, modifier?: string | undefined) => string;
        is: {
            (name: string, state: boolean | undefined): string;
            (name: string): string;
        };
    };
    formClasses: import("vue").ComputedRef<(string | {
        [x: string]: string | boolean | undefined;
    })[]>;
    addField: (field: FormItemContext) => void;
    removeField: (field: FormItemContext) => void;
    resetFields: (props?: Arrayable<FormItemProp> | undefined) => void;
    clearValidate: (props?: Arrayable<FormItemProp> | undefined) => void;
    isValidatable: import("vue").ComputedRef<boolean>;
    obtainValidateFields: (props: Arrayable<FormItemProp>) => FormItemContext[];
    validate: (callback?: FormValidateCallback | undefined) => FormValidationResult;
    doValidateField: (props?: Arrayable<FormItemProp>) => Promise<boolean>;
    validateField: (props?: Arrayable<FormItemProp> | undefined, callback?: FormValidateCallback | undefined) => FormValidationResult;
    scrollToField: (prop: FormItemProp) => void;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
    validate: (prop: FormItemProp, isValid: boolean, message: string) => boolean;
}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    readonly model: ObjectConstructor;
    readonly rules: import("element-plus/es/utils").BuildPropReturn<import("element-plus/es/utils").PropWrapper<Partial<Record<string, Arrayable<import("element-plus/es/tokens").FormItemRule>>>>, unknown, unknown, unknown, unknown>;
    readonly labelPosition: StringConstructor;
    readonly labelWidth: import("element-plus/es/utils").BuildPropReturn<readonly [StringConstructor, NumberConstructor], "", unknown, unknown, unknown>;
    readonly labelSuffix: import("element-plus/es/utils").BuildPropReturn<StringConstructor, "", unknown, unknown, unknown>;
    readonly inline: BooleanConstructor;
    readonly inlineMessage: BooleanConstructor;
    readonly statusIcon: BooleanConstructor;
    readonly showMessage: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
    readonly size: import("element-plus/es/utils").BuildPropReturn<StringConstructor, unknown, unknown, "" | "default" | "small" | "large", unknown>;
    readonly disabled: BooleanConstructor;
    readonly validateOnRuleChange: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, true, unknown, unknown, unknown>;
    readonly hideRequiredAsterisk: import("element-plus/es/utils").BuildPropReturn<BooleanConstructor, false, unknown, unknown, unknown>;
    readonly scrollToError: BooleanConstructor;
}>> & {
    onValidate?: ((prop: FormItemProp, isValid: boolean, message: string) => any) | undefined;
}, {
    size: import("element-plus/es/utils").BuildPropType<StringConstructor, "" | "default" | "small" | "large", unknown>;
    disabled: boolean;
    rules: Partial<Record<string, Arrayable<import("element-plus/es/tokens").FormItemRule>>>;
    labelWidth: import("element-plus/es/utils").BuildPropType<readonly [StringConstructor, NumberConstructor], unknown, unknown>;
    labelSuffix: string;
    showMessage: import("element-plus/es/utils").BuildPropType<BooleanConstructor, unknown, unknown>;
    validateOnRuleChange: import("element-plus/es/utils").BuildPropType<BooleanConstructor, unknown, unknown>;
    hideRequiredAsterisk: import("element-plus/es/utils").BuildPropType<BooleanConstructor, unknown, unknown>;
    inline: boolean;
    inlineMessage: boolean;
    statusIcon: boolean;
    scrollToError: boolean;
}>;
export default _default;
