'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var core = require('@vueuse/core');
require('../../../utils/index.js');
require('../../../constants/index.js');
var index = require('../../badge/index.js');
var index$1 = require('../../icon/index.js');
require('../../../hooks/index.js');
var message = require('./message.js');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var icon = require('../../../utils/vue/icon.js');
var index$2 = require('../../../hooks/use-namespace/index.js');
var aria = require('../../../constants/aria.js');

const _sfc_main = vue.defineComponent({
  name: "ElMessage",
  components: {
    ElBadge: index.ElBadge,
    ElIcon: index$1.ElIcon,
    ...icon.TypeComponents
  },
  props: message.messageProps,
  emits: message.messageEmits,
  setup(props) {
    const ns = index$2.useNamespace("message");
    const visible = vue.ref(false);
    const badgeType = vue.ref(props.type ? props.type === "error" ? "danger" : props.type : "info");
    let stopTimer = void 0;
    const typeClass = vue.computed(() => {
      const type = props.type;
      return { [ns.bm("icon", type)]: type && icon.TypeComponentsMap[type] };
    });
    const iconComponent = vue.computed(() => {
      return props.icon || icon.TypeComponentsMap[props.type] || "";
    });
    const customStyle = vue.computed(() => ({
      top: `${props.offset}px`,
      zIndex: props.zIndex
    }));
    function startTimer() {
      if (props.duration > 0) {
        ;
        ({ stop: stopTimer } = core.useTimeoutFn(() => {
          if (visible.value)
            close();
        }, props.duration));
      }
    }
    function clearTimer() {
      stopTimer == null ? void 0 : stopTimer();
    }
    function close() {
      visible.value = false;
    }
    function keydown({ code }) {
      if (code === aria.EVENT_CODE.esc) {
        if (visible.value) {
          close();
        }
      } else {
        startTimer();
      }
    }
    vue.onMounted(() => {
      startTimer();
      visible.value = true;
    });
    vue.watch(() => props.repeatNum, () => {
      clearTimer();
      startTimer();
    });
    core.useEventListener(document, "keydown", keydown);
    return {
      ns,
      typeClass,
      iconComponent,
      customStyle,
      visible,
      badgeType,
      close,
      clearTimer,
      startTimer
    };
  }
});
const _hoisted_1 = ["id"];
const _hoisted_2 = ["innerHTML"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_badge = vue.resolveComponent("el-badge");
  const _component_el_icon = vue.resolveComponent("el-icon");
  const _component_close = vue.resolveComponent("close");
  return vue.openBlock(), vue.createBlock(vue.Transition, {
    name: _ctx.ns.b("fade"),
    onBeforeLeave: _ctx.onClose,
    onAfterLeave: _cache[2] || (_cache[2] = ($event) => _ctx.$emit("destroy"))
  }, {
    default: vue.withCtx(() => [
      vue.withDirectives(vue.createElementVNode("div", {
        id: _ctx.id,
        class: vue.normalizeClass([
          _ctx.ns.b(),
          { [_ctx.ns.m(_ctx.type)]: _ctx.type && !_ctx.icon },
          _ctx.ns.is("center", _ctx.center),
          _ctx.ns.is("closable", _ctx.showClose),
          _ctx.customClass
        ]),
        style: vue.normalizeStyle(_ctx.customStyle),
        role: "alert",
        onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.clearTimer && _ctx.clearTimer(...args)),
        onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.startTimer && _ctx.startTimer(...args))
      }, [
        _ctx.repeatNum > 1 ? (vue.openBlock(), vue.createBlock(_component_el_badge, {
          key: 0,
          value: _ctx.repeatNum,
          type: _ctx.badgeType,
          class: vue.normalizeClass(_ctx.ns.e("badge"))
        }, null, 8, ["value", "type", "class"])) : vue.createCommentVNode("v-if", true),
        _ctx.iconComponent ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
          key: 1,
          class: vue.normalizeClass([_ctx.ns.e("icon"), _ctx.typeClass])
        }, {
          default: vue.withCtx(() => [
            (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.iconComponent)))
          ]),
          _: 1
        }, 8, ["class"])) : vue.createCommentVNode("v-if", true),
        vue.renderSlot(_ctx.$slots, "default", {}, () => [
          !_ctx.dangerouslyUseHTMLString ? (vue.openBlock(), vue.createElementBlock("p", {
            key: 0,
            class: vue.normalizeClass(_ctx.ns.e("content"))
          }, vue.toDisplayString(_ctx.message), 3)) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
            vue.createCommentVNode(" Caution here, message could've been compromised, never use user's input as message "),
            vue.createElementVNode("p", {
              class: vue.normalizeClass(_ctx.ns.e("content")),
              innerHTML: _ctx.message
            }, null, 10, _hoisted_2)
          ], 2112))
        ]),
        _ctx.showClose ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
          key: 2,
          class: vue.normalizeClass(_ctx.ns.e("closeBtn")),
          onClick: vue.withModifiers(_ctx.close, ["stop"])
        }, {
          default: vue.withCtx(() => [
            vue.createVNode(_component_close)
          ]),
          _: 1
        }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true)
      ], 46, _hoisted_1), [
        [vue.vShow, _ctx.visible]
      ])
    ]),
    _: 3
  }, 8, ["name", "onBeforeLeave"]);
}
var MessageConstructor = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render], ["__file", "/home/runner/work/element-plus/element-plus/packages/components/message/src/message.vue"]]);

exports["default"] = MessageConstructor;
//# sourceMappingURL=message2.js.map
