'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var shared = require('@vue/shared');
require('../../../utils/index.js');
require('../../../constants/index.js');
var item = require('./item.js');
var useSpace = require('./use-space.js');
var props = require('../../../utils/vue/props.js');
var core = require('@vueuse/core');
var size = require('../../../constants/size.js');
var vnode = require('../../../utils/vue/vnode.js');

const spaceProps = props.buildProps({
  direction: {
    type: String,
    values: ["horizontal", "vertical"],
    default: "horizontal"
  },
  class: {
    type: props.definePropType([
      String,
      Object,
      Array
    ]),
    default: ""
  },
  style: {
    type: props.definePropType([String, Array, Object]),
    default: ""
  },
  alignment: {
    type: props.definePropType(String),
    default: "center"
  },
  prefixCls: {
    type: String
  },
  spacer: {
    type: props.definePropType([Object, String, Number, Array]),
    default: null,
    validator: (val) => vue.isVNode(val) || core.isNumber(val) || shared.isString(val)
  },
  wrap: {
    type: Boolean,
    default: false
  },
  fill: {
    type: Boolean,
    default: false
  },
  fillRatio: {
    type: Number,
    default: 100
  },
  size: {
    type: [String, Array, Number],
    values: size.componentSizes,
    validator: (val) => {
      return core.isNumber(val) || shared.isArray(val) && val.length === 2 && val.every((i) => core.isNumber(i));
    }
  }
});
var Space = vue.defineComponent({
  name: "ElSpace",
  props: spaceProps,
  setup(props, { slots }) {
    const { classes, containerStyle, itemStyle } = useSpace.useSpace(props);
    return () => {
      var _a;
      const { spacer, prefixCls, direction } = props;
      const children = vue.renderSlot(slots, "default", { key: 0 }, () => []);
      if (((_a = children.children) != null ? _a : []).length === 0)
        return null;
      if (shared.isArray(children.children)) {
        let extractedChildren = [];
        children.children.forEach((child, loopKey) => {
          if (vnode.isFragment(child)) {
            if (shared.isArray(child.children)) {
              child.children.forEach((nested, key) => {
                extractedChildren.push(vue.createVNode(item["default"], {
                  style: itemStyle.value,
                  prefixCls,
                  key: `nested-${key}`
                }, {
                  default: () => [nested]
                }, vnode.PatchFlags.PROPS | vnode.PatchFlags.STYLE, ["style", "prefixCls"]));
              });
            }
          } else if (vnode.isValidElementNode(child)) {
            extractedChildren.push(vue.createVNode(item["default"], {
              style: itemStyle.value,
              prefixCls,
              key: `LoopKey${loopKey}`
            }, {
              default: () => [child]
            }, vnode.PatchFlags.PROPS | vnode.PatchFlags.STYLE, ["style", "prefixCls"]));
          }
        });
        if (spacer) {
          const len = extractedChildren.length - 1;
          extractedChildren = extractedChildren.reduce((acc, child, idx) => {
            const children2 = [...acc, child];
            if (idx !== len) {
              children2.push(vue.createVNode("span", {
                style: [
                  itemStyle.value,
                  direction === "vertical" ? "width: 100%" : null
                ],
                key: idx
              }, [
                vue.isVNode(spacer) ? spacer : vue.createTextVNode(spacer, vnode.PatchFlags.TEXT)
              ], vnode.PatchFlags.STYLE));
            }
            return children2;
          }, []);
        }
        return vue.createVNode("div", {
          class: classes.value,
          style: containerStyle.value
        }, extractedChildren, vnode.PatchFlags.STYLE | vnode.PatchFlags.CLASS);
      }
      return children.children;
    };
  }
});

exports["default"] = Space;
exports.spaceProps = spaceProps;
//# sourceMappingURL=space.js.map
