'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('../../../utils/index.js');
require('../../virtual-list/index.js');
var common = require('./common.js');
var header = require('./header.js');
var row = require('./row.js');
var props = require('../../../utils/vue/props.js');
var props$1 = require('../../virtual-list/src/props.js');

const tableV2GridProps = props.buildProps({
  columns: common.columns,
  data: common.dataType,
  fixedData: common.fixedDataType,
  estimatedRowHeight: row.tableV2RowProps.estimatedRowHeight,
  width: common.requiredNumber,
  height: common.requiredNumber,
  headerWidth: common.requiredNumber,
  headerHeight: header.tableV2HeaderProps.headerHeight,
  bodyWidth: common.requiredNumber,
  rowHeight: common.requiredNumber,
  cache: props$1.virtualizedListProps.cache,
  useIsScrolling: Boolean,
  scrollbarAlwaysOn: props$1.virtualizedGridProps.scrollbarAlwaysOn,
  scrollbarStartGap: props$1.virtualizedGridProps.scrollbarStartGap,
  scrollbarEndGap: props$1.virtualizedGridProps.scrollbarEndGap,
  class: common.classType,
  style: common.styleType,
  containerStyle: common.styleType,
  onRowsRendered: {
    type: props.definePropType(Function)
  },
  onScroll: {
    type: props.definePropType(Function)
  }
});

exports.tableV2GridProps = tableV2GridProps;
//# sourceMappingURL=grid.js.map
