import type { CSSProperties, RendererElement, RendererNode, VNode } from 'vue';
export declare type Alignment = 'left' | 'center' | 'right';
export declare type FixedDirection = 'left' | 'right';
export declare type KeyType = string | number | symbol;
/**
 * Param types
 */
export declare type CellRendererParams<T> = {
    cellData: T;
} & RowCommonParams<T> & ColumnCommonParams<T>;
export declare type ColumnCommonParams<T> = {
    columns: Column<T>[];
    column: Column<T>;
    columnIndex: number;
};
export declare type HeaderCellRendererParams<T> = {
    headerIndex: number;
} & ColumnCommonParams<T>;
export declare type RowCommonParams<T> = {
    rowData: T[];
    rowIndex: number;
};
export declare type ClassNameGetterParams<T> = {
    cellData: T;
} & RowCommonParams<T> & ColumnCommonParams<T>;
export declare type DataGetterParams<T> = {
    columns: Column<T>[];
    column: Column<T>;
    columnIndex: number;
} & RowCommonParams<T>;
export declare type DataGetter<T> = (params: DataGetterParams<T>) => T;
export declare type ClassNameGetter<T> = (params: ClassNameGetterParams<T>) => string;
export declare type HeaderClassGetter<T> = (params: ColumnCommonParams<T> & {
    headerIndex: number;
}) => string;
/**
 * Renderer/Getter types
 */
export declare type CellRenderer<T> = (params: CellRendererParams<T>) => VNode;
export declare type HeaderCellRenderer<T> = (params: HeaderCellRendererParams<T>) => VNode;
export declare type Column<T = any> = {
    key: KeyType;
    /**
     * Attributes
     */
    align?: Alignment;
    class?: string | ClassNameGetter<T>;
    fixed?: true | FixedDirection;
    title?: string;
    hidden?: boolean;
    headerClass?: HeaderClassGetter<T> | string;
    maxWidth?: number;
    minWidth?: number;
    resizable?: boolean;
    style?: CSSProperties;
    sortable?: boolean;
    width: number;
    /**
     * Renderers
     */
    cellRenderer?: CellRenderer<T>;
    headerCellRenderer?: HeaderCellRenderer<T>;
    /**
     * Extendable sections
     */
    [key: string]: any;
};
export declare type Columns<T> = Column<T>[];
export declare type CustomizedCellsType = VNode<RendererNode, RendererElement, {
    [key: string]: any;
}>[];
export declare type DefaultCellsType = VNode<RendererNode, RendererElement, {
    [key: string]: any;
}>[][];
export declare type ColumnCellsType = DefaultCellsType | CustomizedCellsType;
