'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var _private = require('./private.js');

const calcColumnStyle = (column, fixedColumn) => {
  var _a;
  const flex = {
    flexGrow: 0,
    flexShrink: 0
  };
  if (column.fixed) {
    flex.flexShrink = 1;
  }
  const style = {
    ...(_a = column.style) != null ? _a : {},
    ...flex,
    flexBasis: "auto",
    width: column.width
  };
  if (!fixedColumn) {
    if (column.maxWidth)
      style.maxWidth = column.maxWidth;
    if (column.minWidth)
      style.maxWidth = column.minWidth;
  }
  return style;
};
function useColumns(columns, fixed) {
  const visibleColumns = vue.computed(() => {
    return vue.unref(columns).filter((column) => !column.hidden);
  });
  const fixedColumnsOnLeft = vue.computed(() => vue.unref(visibleColumns).filter((column) => column.fixed === "left" || column.fixed === true));
  const fixedColumnOnRight = vue.computed(() => vue.unref(visibleColumns).filter((column) => column.fixed === "right"));
  const normalColumns = vue.computed(() => vue.unref(visibleColumns).filter((column) => !column.fixed));
  const mainColumns = vue.computed(() => {
    const ret = [];
    vue.unref(fixedColumnsOnLeft).forEach((column) => {
      ret.push({
        ...column,
        placeholderSign: _private.placeholderSign
      });
    });
    vue.unref(normalColumns).forEach((column) => {
      ret.push(column);
    });
    vue.unref(fixedColumnOnRight).forEach((column) => {
      ret.push({
        ...column,
        placeholderSign: _private.placeholderSign
      });
    });
    return ret;
  });
  const hasFixedColumns = vue.computed(() => {
    return vue.unref(fixedColumnsOnLeft).length || vue.unref(fixedColumnOnRight).length;
  });
  const columnsStyles = vue.computed(() => {
    const _columns = vue.unref(columns);
    return _columns.reduce((style, column) => {
      style[column.key] = calcColumnStyle(column, vue.unref(fixed));
      return style;
    }, {});
  });
  const columnsTotalWidth = vue.computed(() => {
    return vue.unref(visibleColumns).reduce((width, column) => width + column.width, 0);
  });
  const getColumn = (key) => {
    return vue.unref(columns).find((column) => column.key === key);
  };
  const getColumnStyle = (key) => {
    return vue.unref(columnsStyles)[key];
  };
  const updateColumnWidth = (column, width) => {
    column.width = width;
  };
  return {
    columns,
    columnsStyles,
    columnsTotalWidth,
    fixedColumnsOnLeft,
    fixedColumnOnRight,
    hasFixedColumns,
    mainColumns,
    normalColumns,
    visibleColumns,
    getColumn,
    getColumnStyle,
    updateColumnWidth
  };
}

exports.useColumns = useColumns;
//# sourceMappingURL=use-columns.js.map
