import type { CSSProperties } from 'vue';
import type { FixedDirection, KeyType } from './types';
import type { TableV2Props } from './table';
import type { onRowRenderedParams } from './grid';
import type { RowExpandParams, RowHoverParams } from './row';
import type { TableGridInstance } from './table-grid';
declare type Nullable<T> = T | null;
declare type ScrollPos = {
    scrollLeft: number;
    scrollTop: number;
};
declare function useTable(props: TableV2Props): {
    columns: import("vue").Ref<import("./types").Column<any>[]>;
    containerRef: import("vue").Ref<any>;
    mainTableRef: import("vue").Ref<TableGridInstance | undefined>;
    leftTableRef: import("vue").Ref<TableGridInstance | undefined>;
    rightTableRef: import("vue").Ref<TableGridInstance | undefined>;
    isResetting: import("vue").ShallowRef<boolean>;
    isScrolling: import("vue").ShallowRef<boolean>;
    hoveringRowKey: import("vue").ShallowRef<Nullable<KeyType>>;
    hasFixedColumns: import("vue").ComputedRef<number>;
    columnsStyles: import("vue").ComputedRef<Record<KeyType, CSSProperties>>;
    columnsTotalWidth: import("vue").ComputedRef<number>;
    data: import("vue").ComputedRef<any[]>;
    expandedRowKeys: import("vue").Ref<KeyType[]>;
    depthMap: import("vue").Ref<{
        [x: string]: number;
        [x: number]: number;
        [x: symbol]: number;
    }>;
    fixedColumnsOnLeft: import("vue").ComputedRef<import("./types").Column<any>[]>;
    fixedColumnOnRight: import("vue").ComputedRef<import("./types").Column<any>[]>;
    mainColumns: import("vue").ComputedRef<import("./types").Column<any>[]>;
    bodyWidth: import("vue").ComputedRef<number>;
    rootStyle: import("vue").ComputedRef<CSSProperties>;
    headerWidth: import("vue").ComputedRef<number>;
    mainTableHeight: import("vue").ComputedRef<number>;
    fixedTableHeight: import("vue").ComputedRef<number>;
    leftTableWidth: import("vue").ComputedRef<number>;
    rightTableWidth: import("vue").ComputedRef<number>;
    scrollTo: (params: ScrollPos) => void;
    scrollToLeft: (scrollLeft: number) => void;
    scrollToTop: (scrollTop: number) => void;
    onColumnSorted: (e: MouseEvent) => void;
    onRowHovered: ({ hovered, rowKey }: RowHoverParams<any>) => void;
    onRowExpanded: ({ expanded, rowData, rowIndex, rowKey, }: RowExpandParams<any>) => void;
    onRowsRendered: (params: onRowRenderedParams) => void;
    onRowHeightChanged: (rowKey: KeyType, height: number, rowIdx: number) => void;
    onFixedRowHeightChanged: ({ rowKey, height, rowIndex, }: {
        rowKey: KeyType;
        height: number;
        rowIndex: number;
    }, fixedDir: FixedDirection) => void;
    onScroll: (params: ScrollPos) => void;
    onVerticalScroll: ({ scrollTop }: ScrollPos) => void;
};
export { useTable };
export declare type UseTableReturn = ReturnType<typeof useTable>;
