'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../utils/index.js');
var utils = require('./utils.js');
var useColumns = require('./use-columns.js');
var constants = require('./constants.js');
var core = require('@vueuse/core');
var types = require('../../../utils/types.js');
var shared = require('@vue/shared');

function useTable(props) {
  const emit = vue.getCurrentInstance().emit;
  const {
    columns,
    columnsStyles,
    columnsTotalWidth,
    fixedColumnsOnLeft,
    fixedColumnOnRight,
    hasFixedColumns,
    mainColumns,
    getColumn
  } = useColumns.useColumns(vue.toRef(props, "columns"), vue.toRef(props, "fixed"));
  const expandedRowKeys = vue.ref(props.defaultExpandedRowKeys || []);
  const depthMap = vue.ref({});
  const hoveringRowKey = vue.shallowRef(null);
  const resetIndex = vue.shallowRef(null);
  const isResetting = vue.shallowRef(false);
  const isScrolling = vue.shallowRef(false);
  const containerRef = vue.ref();
  const mainTableRef = vue.ref();
  const leftTableRef = vue.ref();
  const rightTableRef = vue.ref();
  const scrollPos = vue.ref({ scrollLeft: 0, scrollTop: 0 });
  const lastRenderedRowIndex = vue.ref(-1);
  const rowHeights = vue.shallowRef({});
  const leftTableHeights = vue.shallowRef({});
  const mainTableHeights = vue.shallowRef({});
  const rightTableHeights = vue.shallowRef({});
  const rowsHeight = vue.computed(() => {
    const { rowHeight, estimatedRowHeight } = props;
    const _data = vue.unref(data);
    if (core.isNumber(estimatedRowHeight)) {
      return _data.length * estimatedRowHeight;
    }
    return _data.length * rowHeight;
  });
  const flattenedData = vue.computed(() => {
    const depths = {};
    const { data: data2, rowKey } = props;
    const _expandedRowKeys = vue.unref(expandedRowKeys);
    if (!_expandedRowKeys || !_expandedRowKeys.length)
      return data2;
    const array = [];
    const keysSet = /* @__PURE__ */ new Set();
    _expandedRowKeys.forEach((x) => keysSet.add(x));
    let copy = data2.slice();
    copy.forEach((x) => depths[x[rowKey]] = 0);
    while (copy.length > 0) {
      const item = copy.shift();
      array.push(item);
      if (keysSet.has(item[rowKey]) && Array.isArray(item.children) && item.children.length > 0) {
        copy = [...item.children, ...copy];
        item.children.forEach((child) => depths[child[rowKey]] = depths[item[rowKey]] + 1);
      }
    }
    depthMap.value = depths;
    return array;
  });
  const data = vue.computed(() => {
    const { data: data2, expandColumnKey } = props;
    return expandColumnKey ? vue.unref(flattenedData) : data2;
  });
  const bodyWidth = vue.computed(() => {
    const { fixed, width, vScrollbarSize } = props;
    const ret = width - vScrollbarSize;
    return fixed ? Math.max(Math.round(vue.unref(columnsTotalWidth)), ret) : ret;
  });
  const rootStyle = vue.computed(() => {
    const { style = {}, height, width } = props;
    return utils.enforceUnit({
      ...style,
      height,
      width
    });
  });
  const headerWidth = vue.computed(() => vue.unref(bodyWidth) + (props.fixed ? props.vScrollbarSize : 0));
  const mainTableHeight = vue.computed(() => {
    const { height = 0, maxHeight = 0, footerHeight, hScrollbarSize } = props;
    if (maxHeight > 0) {
      const _fixedRowsHeight = vue.unref(fixedRowsHeight);
      const _rowsHeight = vue.unref(rowsHeight);
      const _headerHeight = vue.unref(headerHeight);
      const total = _headerHeight + _fixedRowsHeight + _rowsHeight + hScrollbarSize;
      return Math.min(total, maxHeight - footerHeight);
    }
    return height - footerHeight;
  });
  const fixedTableHeight = vue.computed(() => {
    const { maxHeight } = props;
    const tableHeight = vue.unref(mainTableHeight);
    if (core.isNumber(maxHeight) && maxHeight > 0)
      return tableHeight;
    const totalHeight = vue.unref(rowsHeight) + vue.unref(headerHeight) + vue.unref(fixedRowsHeight);
    return Math.min(tableHeight, totalHeight);
  });
  const mapColumn = (column) => column.width;
  const leftTableWidth = vue.computed(() => utils.sum(vue.unref(fixedColumnsOnLeft).map(mapColumn)));
  const rightTableWidth = vue.computed(() => utils.sum(vue.unref(fixedColumnOnRight).map(mapColumn)));
  const headerHeight = vue.computed(() => utils.sum(props.headerHeight));
  const fixedRowsHeight = vue.computed(() => {
    var _a;
    return (((_a = props.fixedData) == null ? void 0 : _a.length) || 0) * props.rowHeight;
  });
  const windowHeight = vue.computed(() => {
    return vue.unref(mainTableHeight) - vue.unref(headerHeight) - vue.unref(fixedRowsHeight);
  });
  function doScroll(params) {
    var _a, _b, _c;
    const { scrollTop } = params;
    (_a = mainTableRef.value) == null ? void 0 : _a.scrollTo(params);
    (_b = leftTableRef.value) == null ? void 0 : _b.scrollToTop(scrollTop);
    (_c = rightTableRef.value) == null ? void 0 : _c.scrollToTop(scrollTop);
  }
  function scrollTo(params) {
    scrollPos.value = params;
    doScroll(params);
  }
  function scrollToTop(scrollTop) {
    scrollPos.value.scrollTop = scrollTop;
    doScroll(vue.unref(scrollPos));
  }
  function scrollToLeft(scrollLeft) {
    var _a, _b;
    scrollPos.value.scrollLeft = scrollLeft;
    (_b = (_a = mainTableRef.value) == null ? void 0 : _a.scrollTo) == null ? void 0 : _b.call(_a, vue.unref(scrollPos));
  }
  function onMaybeEndReached() {
    const { onEndReached } = props;
    if (!onEndReached)
      return;
    const { scrollTop } = vue.unref(scrollPos);
    const _totalHeight = vue.unref(rowsHeight);
    const clientHeight = vue.unref(windowHeight);
    const heightUntilEnd = _totalHeight - (scrollTop + clientHeight) + props.hScrollbarSize;
    if (vue.unref(lastRenderedRowIndex) >= 0 && _totalHeight !== vue.unref(rowsHeight)) {
      onEndReached(heightUntilEnd);
    }
  }
  function updateRows() {
    isResetting.value = true;
    resetAfterIndex(vue.unref(resetIndex), false);
    resetIndex.value = null;
    isResetting.value = false;
  }
  function resetAfterIndex(index, forceUpdate = false) {
    if (types.isUndefined(props.estimatedRowHeight))
      return;
    [mainTableRef, leftTableRef, rightTableRef].forEach((tableRef) => {
      const table = vue.unref(tableRef);
      if (table)
        table.resetAfterRowIndex(index, forceUpdate);
    });
  }
  function onScroll(params) {
    var _a;
    scrollTo(params);
    (_a = props.onScroll) == null ? void 0 : _a.call(props, params);
  }
  function onVerticalScroll({ scrollTop }) {
    const { scrollTop: currentScrollTop } = vue.unref(scrollPos);
    if (scrollTop !== currentScrollTop)
      scrollToTop(scrollTop);
  }
  function onRowsRendered(params) {
    var _a;
    (_a = props.onRowRendered) == null ? void 0 : _a.call(props, params);
    if (params.rowCacheEnd > vue.unref(lastRenderedRowIndex)) {
      lastRenderedRowIndex.value = params.rowCacheEnd;
    }
  }
  function onRowHovered({ hovered, rowKey }) {
    hoveringRowKey.value = hovered ? rowKey : null;
  }
  function onRowExpanded({
    expanded,
    rowData,
    rowIndex,
    rowKey
  }) {
    var _a, _b;
    const _expandedRowKeys = [...vue.unref(expandedRowKeys)];
    const currentKeyIndex = _expandedRowKeys.indexOf(rowKey);
    if (expanded) {
      if (currentKeyIndex === -1)
        _expandedRowKeys.push(rowKey);
    } else {
      if (currentKeyIndex > -1)
        _expandedRowKeys.splice(currentKeyIndex, 1);
    }
    expandedRowKeys.value = _expandedRowKeys;
    emit("update:expandedRowKeys", _expandedRowKeys);
    (_a = props.onRowExpand) == null ? void 0 : _a.call(props, {
      expanded,
      rowData,
      rowIndex,
      rowKey
    });
    (_b = props.onExpandedRowsChange) == null ? void 0 : _b.call(props, _expandedRowKeys);
  }
  function onColumnSorted(e) {
    var _a;
    const { key } = e.currentTarget.dataset;
    if (!key)
      return;
    const { sortState, sortBy } = props;
    let order = constants.SortOrder.ASC;
    if (shared.isObject(sortState)) {
      order = constants.oppositeOrderMap[sortState[key]];
    } else {
      order = constants.oppositeOrderMap[sortBy.order];
    }
    (_a = props.onColumnSort) == null ? void 0 : _a.call(props, { column: getColumn(key), key, order });
  }
  function onRowHeightChanged(rowKey, height, rowIdx) {
    const resetIdx = vue.unref(resetIndex);
    if (resetIdx === null) {
      resetIndex.value = rowIdx;
    } else {
      if (resetIdx > rowIdx) {
        resetIndex.value = rowIdx;
      }
    }
    rowHeights.value[rowKey] = height;
  }
  function onFixedRowHeightChanged({
    rowKey,
    height,
    rowIndex
  }, fixedDir) {
    if (!fixedDir) {
      mainTableHeights.value[rowKey] = height;
    } else {
      if (fixedDir === "right") {
        rightTableHeights.value[rowKey] = height;
      } else {
        leftTableHeights.value[rowKey] = height;
      }
    }
    const _rowHeights = vue.unref(rowHeights);
    if (_rowHeights[rowKey] !== height) {
      onRowHeightChanged(rowKey, height, rowIndex);
    }
  }
  vue.watch(() => vue.unref(scrollPos).scrollTop, (cur, prev) => {
    if (cur > prev)
      onMaybeEndReached();
  });
  vue.watch(lastRenderedRowIndex, () => onMaybeEndReached());
  vue.watch(() => props.expandedRowKeys, (val) => expandedRowKeys.value = val, {
    deep: true
  });
  vue.watch(rowHeights, () => {
    updateRows();
  });
  return {
    columns,
    containerRef,
    mainTableRef,
    leftTableRef,
    rightTableRef,
    isResetting,
    isScrolling,
    hoveringRowKey,
    hasFixedColumns,
    columnsStyles,
    columnsTotalWidth,
    data,
    expandedRowKeys,
    depthMap,
    fixedColumnsOnLeft,
    fixedColumnOnRight,
    mainColumns,
    bodyWidth,
    rootStyle,
    headerWidth,
    mainTableHeight,
    fixedTableHeight,
    leftTableWidth,
    rightTableWidth,
    scrollTo,
    scrollToLeft,
    scrollToTop,
    onColumnSorted,
    onRowHovered,
    onRowExpanded,
    onRowsRendered,
    onRowHeightChanged,
    onFixedRowHeightChanged,
    onScroll,
    onVerticalScroll
  };
}

exports.useTable = useTable;
//# sourceMappingURL=use-table.js.map
