'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var lodashUnified = require('lodash-unified');
require('../../../constants/index.js');
require('../../../utils/index.js');
var index = require('../../tree/index.js');
var treeSelectOption = require('./tree-select-option.js');
var shared = require('@vue/shared');
var event = require('../../../constants/event.js');

const useTree = (props, { attrs, slots, emit }, {
  select,
  tree,
  key
}) => {
  vue.watch(() => props.modelValue, () => {
    if (props.showCheckbox) {
      vue.nextTick(() => {
        const treeInstance = tree.value;
        if (treeInstance && !lodashUnified.isEqual(treeInstance.getCheckedKeys(), toValidArray(props.modelValue))) {
          treeInstance.setCheckedKeys(toValidArray(props.modelValue));
        }
      });
    }
  }, {
    immediate: true,
    deep: true
  });
  const propsMap = vue.computed(() => ({
    value: key.value,
    ...props.props
  }));
  const getNodeValByProp = (prop, data) => {
    var _a;
    const propVal = propsMap.value[prop];
    if (shared.isFunction(propVal)) {
      return propVal(data, (_a = tree.value) == null ? void 0 : _a.getNode(getNodeValByProp("value", data)));
    } else {
      return data[propVal];
    }
  };
  return {
    ...lodashUnified.pick(vue.toRefs(props), Object.keys(index["default"].props)),
    ...attrs,
    nodeKey: key,
    expandOnClickNode: vue.computed(() => {
      return !props.checkStrictly;
    }),
    defaultExpandedKeys: vue.computed(() => {
      const values = toValidArray(props.modelValue);
      const parentKeys = tree.value ? values.map((item) => {
        var _a, _b, _c;
        return (_c = (_b = (_a = tree.value) == null ? void 0 : _a.getNode(item)) == null ? void 0 : _b.parent) == null ? void 0 : _c.key;
      }).filter((item) => isValidValue(item)) : values;
      return props.defaultExpandedKeys ? props.defaultExpandedKeys.concat(parentKeys) : parentKeys;
    }),
    renderContent: (h, { node, data, store }) => {
      return h(treeSelectOption["default"], {
        value: getNodeValByProp("value", data),
        label: getNodeValByProp("label", data),
        disabled: getNodeValByProp("disabled", data)
      }, props.renderContent ? () => props.renderContent(h, { node, data, store }) : slots.default ? () => slots.default({ node, data, store }) : void 0);
    },
    filterNodeMethod: (value, data, node) => {
      var _a;
      if (props.filterNodeMethod)
        return props.filterNodeMethod(value, data, node);
      if (!value)
        return true;
      return (_a = getNodeValByProp("label", data)) == null ? void 0 : _a.includes(value);
    },
    onNodeClick: (data, node, e) => {
      var _a, _b, _c;
      (_a = attrs.onNodeClick) == null ? void 0 : _a.call(attrs, data, node, e);
      if (props.checkStrictly || node.isLeaf) {
        if (!getNodeValByProp("disabled", data)) {
          const option = (_b = select.value) == null ? void 0 : _b.options.get(getNodeValByProp("value", data));
          (_c = select.value) == null ? void 0 : _c.handleOptionSelect(option, true);
        }
      } else {
        e.proxy.handleExpandIconClick();
      }
    },
    onCheck: (data, params) => {
      var _a, _b;
      (_a = attrs.onCheck) == null ? void 0 : _a.call(attrs, data, params);
      const checkedKeys = !props.checkStrictly ? (_b = tree.value) == null ? void 0 : _b.getCheckedKeys(true) : params.checkedKeys;
      const value = getNodeValByProp("value", data);
      emit(event.UPDATE_MODEL_EVENT, props.multiple ? checkedKeys : checkedKeys.includes(value) ? value : void 0);
    }
  };
};
function isValidValue(val) {
  return val || val === 0;
}
function toValidArray(val) {
  return Array.isArray(val) ? val : isValidValue(val) ? [val] : [];
}

exports.useTree = useTree;
//# sourceMappingURL=tree.js.map
