import type { Tree, TreeData, TreeKey, TreeNode, TreeNodeData, TreeProps } from '../types';
export declare function useTree(props: TreeProps, emit: any): {
    tree: import("vue").ShallowRef<Tree | undefined>;
    flattenTree: import("vue").ComputedRef<TreeNode[]>;
    isNotEmpty: import("vue").ComputedRef<boolean>;
    getKey: (node: TreeNodeData) => TreeKey;
    getChildren: (node: TreeNodeData) => TreeNodeData[];
    toggleExpand: (node: TreeNode) => void;
    toggleCheckbox: (node: TreeNode, isChecked: boolean, nodeClick?: boolean) => void;
    isExpanded: (node: TreeNode) => boolean;
    isChecked: (node: TreeNode) => boolean;
    isIndeterminate: (node: TreeNode) => boolean;
    isDisabled: (node: TreeNode) => boolean;
    isCurrent: (node: TreeNode) => boolean;
    isForceHiddenExpandIcon: (node: TreeNode) => boolean;
    handleNodeClick: (node: TreeNode, e: MouseEvent) => void;
    handleNodeCheck: (node: TreeNode, checked: boolean) => void;
    getCurrentNode: () => TreeNodeData | undefined;
    getCurrentKey: () => TreeKey | undefined;
    setCurrentKey: (key: TreeKey) => void;
    getCheckedKeys: (leafOnly?: boolean) => TreeKey[];
    getCheckedNodes: (leafOnly?: boolean) => TreeNodeData[];
    getHalfCheckedKeys: () => TreeKey[];
    getHalfCheckedNodes: () => TreeNodeData[];
    setChecked: (key: TreeKey, isChecked: boolean) => void;
    setCheckedKeys: (keys: TreeKey[]) => void;
    filter: (query: string) => void;
    setData: (data: TreeData) => void;
};
