(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define('element/locale/el', ['module', 'exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(module, exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod, mod.exports);
    global.ELEMENT.lang = global.ELEMENT.lang || {}; 
    global.ELEMENT.lang.el = mod.exports;
  }
})(this, function (module, exports) {
  'use strict';

  exports.__esModule = true;
  exports.default = {
    el: {
      colorpicker: {
        confirm: 'OK',
        clear: 'Καθαρισμός'
      },
      datepicker: {
        now: 'Τώρα',
        today: 'Σήμερα',
        cancel: 'Ακύρωση',
        clear: 'Καθαρισμός',
        confirm: 'OK',
        selectDate: 'Επιλέξτε ημέρα',
        selectTime: 'Επιλέξτε ώρα',
        startDate: 'Ημερομηνία Έναρξης',
        startTime: 'Ωρα Έναρξης',
        endDate: 'Ημερομηνία Λήξης',
        endTime: 'Ωρα Λήξης',
        year: 'Έτος',
        month1: 'Ιανουάριος',
        month2: 'Φεβρουάριος',
        month3: 'Μάρτιος',
        month4: 'Απρίλιος',
        month5: 'Μάιος',
        month6: 'Ιούνιος',
        month7: 'Ιούλιος',
        month8: 'Αύγουστος',
        month9: 'Σεπτέμβριος',
        month10: 'Οκτώβριος',
        month11: 'Νοέμβριος',
        month12: 'Δεκέμβριος',
        // week: 'εβδομάδα',
        weeks: {
          sun: 'Κυρ',
          mon: 'Δευ',
          tue: 'Τρι',
          wed: 'Τετ',
          thu: 'Πεμ',
          fri: 'Παρ',
          sat: 'Σαβ'
        },
        months: {
          jan: 'Ιαν',
          feb: 'Φεβ',
          mar: 'Μαρ',
          apr: 'Απρ',
          may: 'Μαϊ',
          jun: 'Ιουν',
          jul: 'Ιουλ',
          aug: 'Αυγ',
          sep: 'Σεπ',
          oct: 'Οκτ',
          nov: 'Νοε',
          dec: 'Δεκ'
        }
      },
      select: {
        loading: 'Φόρτωση',
        noMatch: 'Δεν βρέθηκαν αποτελέσματα',
        noData: 'Χωρίς δεδομένα',
        placeholder: 'Επιλογή'
      },
      cascader: {
        noMatch: 'Δεν βρέθηκαν αποτελέσματα',
        loading: 'Φόρτωση',
        placeholder: 'Επιλογή'
      },
      pagination: {
        goto: 'Μετάβαση σε',
        pagesize: '/σελίδα',
        total: 'Σύνολο {total}',
        pageClassifier: ''
      },
      messagebox: {
        title: 'Μήνυμα',
        confirm: 'OK',
        cancel: 'Ακύρωση',
        error: 'Άκυρη εισαγωγή'
      },
      upload: {
        delete: 'Διαγραφή',
        preview: 'Προεπισκόπηση',
        continue: 'Συνέχεια'
      },
      table: {
        emptyText: 'Χωρίς Δεδομένα',
        confirmFilter: 'Επιβεβαίωση',
        resetFilter: 'Επαναφορά',
        clearFilter: 'Όλα',
        sumText: 'Sum' // to be translated
      },
      tree: {
        emptyText: 'Χωρίς Δεδομένα'
      },
      transfer: {
        noMatch: 'Δεν βρέθηκαν αποτελέσματα',
        noData: 'Χωρίς δεδομένα',
        titles: ['List 1', 'List 2'], // to be translated
        filterPlaceholder: 'Enter keyword', // to be translated
        noCheckedFormat: '{total} items', // to be translated
        hasCheckedFormat: '{checked}/{total} checked' // to be translated
      }
    }
  };
  module.exports = exports['default'];
});