(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define('element/locale/fa', ['module', 'exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(module, exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod, mod.exports);
    global.ELEMENT.lang = global.ELEMENT.lang || {}; 
    global.ELEMENT.lang.fa = mod.exports;
  }
})(this, function (module, exports) {
  'use strict';

  exports.__esModule = true;
  exports.default = {
    el: {
      colorpicker: {
        confirm: 'باشد',
        clear: 'خذف'
      },
      datepicker: {
        now: 'اکنون',
        today: 'امروز',
        cancel: 'لغو',
        clear: 'خذف',
        confirm: 'باشد',
        selectDate: 'انتخاب تاریخ',
        selectTime: 'انتخاب زمان',
        startDate: 'تاریخ شروع',
        startTime: 'زمان شروع',
        endDate: 'تاریخ پایان',
        endTime: 'زمان پایان',
        prevYear: 'Previous Year', // to be translated
        nextYear: 'Next Year', // to be translated
        prevMonth: 'Previous Month', // to be translated
        nextMonth: 'Next Month', // to be translated
        year: 'سال',
        month1: 'ژانویه',
        month2: 'فوریه',
        month3: 'مارس',
        month4: 'آوریل',
        month5: 'مه',
        month6: 'ژوئن',
        month7: 'جولای',
        month8: 'اوت',
        month9: 'سپتامبر',
        month10: 'اکتبر',
        month11: 'نوامبر',
        month12: 'دسامبر',
        // week: 'week',
        weeks: {
          sun: 'یکشنبه',
          mon: 'دوشنبه',
          tue: 'سه​شنبه',
          wed: 'چهارشنبه',
          thu: 'پنج​شنبه',
          fri: 'جمعه',
          sat: 'شنبه'
        },
        months: {
          jan: 'ژانویه',
          feb: 'فوریه',
          mar: 'مارس',
          apr: 'آوریل',
          may: 'مه',
          jun: 'ژوئن',
          jul: 'جولای',
          aug: 'اوت',
          sep: 'سپتامبر',
          oct: 'اکتبر',
          nov: 'نوامبر',
          dec: 'دسامبر'
        }
      },
      select: {
        loading: 'بارگیری',
        noMatch: 'هیچ داده‌ای پیدا نشد',
        noData: 'اطلاعاتی وجود ندارد',
        placeholder: 'انتخاب کنید'
      },
      cascader: {
        noMatch: 'هیچ داده‌ای پیدا نشد',
        loading: 'بارگیری',
        placeholder: 'انتخاب کنید'
      },
      pagination: {
        goto: 'برو به',
        pagesize: '/صفحه',
        total: 'مجموع {total}',
        pageClassifier: ''
      },
      messagebox: {
        title: 'پیام',
        confirm: 'باشد',
        cancel: 'لغو',
        error: 'ورودی غیر مجاز'
      },
      upload: {
        deleteTip: 'press delete to remove', // to be translated
        delete: 'حذف',
        preview: 'پیش‌نمایش',
        continue: 'ادهمه'
      },
      table: {
        emptyText: 'اطلاعاتی وجود ندارد',
        confirmFilter: 'تایید',
        resetFilter: 'حذف',
        clearFilter: 'همه',
        sumText: 'Sum' // to be translated
      },
      tree: {
        emptyText: 'اطلاعاتی وجود ندارد'
      },
      transfer: {
        noMatch: 'هیچ داده‌ای پیدا نشد',
        noData: 'اطلاعاتی وجود ندارد',
        titles: ['List 1', 'List 2'], // to be translated
        filterPlaceholder: 'Enter keyword', // to be translated
        noCheckedFormat: '{total} items', // to be translated
        hasCheckedFormat: '{checked}/{total} checked' // to be translated
      }
    }
  };
  module.exports = exports['default'];
});