(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define('element/locale/fi', ['module', 'exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(module, exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod, mod.exports);
    global.ELEMENT.lang = global.ELEMENT.lang || {}; 
    global.ELEMENT.lang.fi = mod.exports;
  }
})(this, function (module, exports) {
  'use strict';

  exports.__esModule = true;
  exports.default = {
    el: {
      colorpicker: {
        confirm: 'OK',
        clear: 'Tyhjennä'
      },
      datepicker: {
        now: 'Nyt',
        today: 'Tänään',
        cancel: 'Peruuta',
        clear: 'Tyhjennä',
        confirm: 'OK',
        selectDate: 'Valitse päivä',
        selectTime: 'Valitse aika',
        startDate: 'Aloituspäivä',
        startTime: 'Aloitusaika',
        endDate: 'Lopetuspäivä',
        endTime: 'Lopetusaika',
        prevYear: 'Edellinen vuosi',
        nextYear: 'Seuraava vuosi',
        prevMonth: 'Edellinen kuukausi',
        nextMonth: 'Seuraava kuukausi',
        year: '',
        month1: 'tammikuu',
        month2: 'helmikuu',
        month3: 'maaliskuu',
        month4: 'huhtikuu',
        month5: 'toukokuu',
        month6: 'kesäkuu',
        month7: 'heinäkuu',
        month8: 'elokuu',
        month9: 'syyskuu',
        month10: 'lokakuu',
        month11: 'marraskuu',
        month12: 'joulukuu',
        // week: 'week',
        weeks: {
          sun: 'su',
          mon: 'ma',
          tue: 'ti',
          wed: 'ke',
          thu: 'to',
          fri: 'pe',
          sat: 'la'
        },
        months: {
          jan: 'tammi',
          feb: 'helmi',
          mar: 'maalis',
          apr: 'huhti',
          may: 'touko',
          jun: 'kesä',
          jul: 'heinä',
          aug: 'elo',
          sep: 'syys',
          oct: 'loka',
          nov: 'marras',
          dec: 'joulu'
        }
      },
      select: {
        loading: 'Lataa',
        noMatch: 'Ei vastaavia tietoja',
        noData: 'Ei tietoja',
        placeholder: 'Valitse'
      },
      cascader: {
        noMatch: 'Ei vastaavia tietoja',
        loading: 'Lataa',
        placeholder: 'Valitse'
      },
      pagination: {
        goto: 'Mene',
        pagesize: '/sivu',
        total: 'Yhteensä {total}',
        pageClassifier: ''
      },
      messagebox: {
        title: 'Viesti',
        confirm: 'OK',
        cancel: 'Peruuta',
        error: 'Virheellinen syöte'
      },
      upload: {
        deleteTip: 'Poista Delete-näppäimellä',
        delete: 'Poista',
        preview: 'Esikatsele',
        continue: 'Jatka'
      },
      table: {
        emptyText: 'Ei tietoja',
        confirmFilter: 'Vahvista',
        resetFilter: 'Tyhjennä',
        clearFilter: 'Kaikki',
        sumText: 'Summa'
      },
      tree: {
        emptyText: 'Ei tietoja'
      },
      transfer: {
        noMatch: 'Ei vastaavia tietoja',
        noData: 'Ei tietoja',
        titles: ['Luettelo 1', 'Luettelo 2'],
        filterPlaceholder: 'Syötä hakusana',
        noCheckedFormat: '{total} kohdetta',
        hasCheckedFormat: '{checked}/{total} valittu'
      }
    }
  };
  module.exports = exports['default'];
});