'use strict';

module.exports = {
  stub: function stub(obj, name, value, shouldInvoke) {
    var original = obj[name];

    obj[name] = function() {
      obj[name].called++;
      obj[name].calledWith.push(arguments);
      return shouldInvoke ? value.apply(this, arguments) : value;
    };

    obj[name]._restore = function() {
      obj[name] = original;
    };

    obj[name].called = 0;
    obj[name].calledWith = [];
    return obj[name];
  },
  stubPath: function stubPath(path) {
    return {
      basename: function() {
        return path;
      }
    };
  },
  stubBlueprint: function stubBlueprint() {
    return function Blueprint() {
      return {
        install: function() { }
      };
    };
  },
  safeRestore: function(obj, name) {
    var value = obj[name];
    if (value && value._restore) {
      value._restore();
    }
  }
};
