"use strict";
Object.defineProperty(exports, "__esModule", { value: !0 });
var weakMemoize = function(func) {
  var cache = new WeakMap();
  return function(arg) {
    if (cache.has(arg)) return cache.get(arg);
    var ret = func(arg);
    return cache.set(arg, ret), ret;
  };
};
exports.default = weakMemoize;
