/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import { ThreeGraphics } from '@enable3d/three-graphics/jsm';
import { Scene3D } from './scene3d';
import { ThreeGraphicsConfig } from '@enable3d/common/dist/types';
interface Scene3DConfig extends Omit<ThreeGraphicsConfig, 'camera' | 'usePhysics' | 'enableXR'> {
    parent?: string;
    scenes: typeof Scene3D[];
}
export declare class Project extends ThreeGraphics {
    private projectConfig;
    parent: HTMLElement;
    canvas: HTMLCanvasElement;
    scenes: Map<string, Scene3D>;
    constructor(projectConfig: Scene3DConfig);
}
export {};
//# sourceMappingURL=project.d.ts.map