/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import PhysicsBody from '@enable3d/common/dist/physicsBody';
import { XYZ } from '@enable3d/common/dist/types';
export default class Constraints {
    worldTransform: Ammo.btTransform;
    physicsWorld: Ammo.btDiscreteDynamicsWorld;
    tmpBtVector3: Ammo.btVector3;
    constructor(worldTransform: Ammo.btTransform, physicsWorld: Ammo.btDiscreteDynamicsWorld);
    private toAmmoV3;
    get addConstraints(): {
        lock: (bodyA: PhysicsBody, bodyB: PhysicsBody, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btGeneric6DofConstraint;
        fixed: (bodyA: PhysicsBody, bodyB: PhysicsBody, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btFixedConstraint;
        pointToPoint: (bodyA: PhysicsBody, bodyB: PhysicsBody, config: {
            pivotA?: XYZ;
            pivotB?: XYZ;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btPoint2PointConstraint;
        hinge: (bodyA: PhysicsBody, bodyB: PhysicsBody, config: {
            pivotA?: XYZ;
            pivotB?: XYZ;
            axisA?: XYZ;
            axisB?: XYZ;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btHingeConstraint;
        slider: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
            frameA?: XYZ;
            frameB?: XYZ;
            linearLowerLimit?: number;
            linearUpperLimit?: number;
            angularLowerLimit?: number;
            angularUpperLimit?: number;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btSliderConstraint;
        spring: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
            stiffness?: number;
            damping?: number;
            angularLock?: boolean;
            linearLowerLimit?: XYZ;
            linearUpperLimit?: XYZ;
            angularLowerLimit?: XYZ;
            angularUpperLimit?: XYZ;
            center?: boolean;
            offset?: XYZ;
            enableSpring?: boolean;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btGeneric6DofSpringConstraint;
        coneTwist: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
            frameA: XYZ;
            frameB: XYZ;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btConeTwistConstraint;
        dof: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
            linearLowerLimit?: XYZ;
            linearUpperLimit?: XYZ;
            angularLowerLimit?: XYZ;
            angularUpperLimit?: XYZ;
            center?: boolean;
            offset?: XYZ;
        }, disableCollisionsBetweenLinkedBodies?: boolean) => Ammo.btGeneric6DofConstraint;
    };
    private getTransform;
    private lock;
    private fixed;
    private pointToPoint;
    private hinge;
    private slider;
    private spring;
    private coneTwist;
    private dof;
}
//# sourceMappingURL=constraints.d.ts.map