/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @description  This is a modified version of the original code from Kevin Lee
 */
/**
 * @author       Kevin Lee (https://github.com/InfiniteLee)
 * @copyright    Copyright (c) 2019 Kevin Lee; Project Url: https://github.com/InfiniteLee/ammo-debug-drawer
 * @license      {@link https://github.com/InfiniteLee/ammo-debug-drawer/blob/master/LICENSE|MPL-2.0}
 */
import { BufferGeometry, LineSegments, Scene } from 'three';
/**
 * An implementation of the btIDebugDraw interface in Ammo.js, for debug rendering of Ammo shapes
 */
declare class DebugDrawer {
    scene: Scene;
    world: Ammo.btCollisionWorld;
    options: any;
    debugDrawMode: number;
    geometry: BufferGeometry;
    index: number;
    mesh: LineSegments;
    enabled: boolean;
    debugDrawer: Ammo.DebugDrawer;
    warnedOnce: boolean;
    constructor(scene: Scene, world: Ammo.btCollisionWorld, options?: any);
    enable(): void;
    disable(): void;
    update(): void;
    drawLine(from: any, to: any, color: any): void;
    drawContactPoint(pointOnB: any, normalOnB: any, distance: any, _lifeTime: any, color: any): void;
    reportErrorWarning(warningString: string): void;
    draw3dText(_location: any, _textString: any): void;
    setDebugMode(debugMode: any): void;
    getDebugMode(): number;
}
export default DebugDrawer;
//# sourceMappingURL=debugDrawer.d.ts.map