/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import PhysicsBody from '@enable3d/common/dist/physicsBody';
import { ExtendedObject3D } from '@enable3d/common/dist/extendedObject3D';
export { ExtendedObject3D };
import { ExtendedMesh } from '@enable3d/common/dist/extendedMesh';
export { ExtendedMesh };
import { ExtendedGroup } from '@enable3d/common/dist/extendedGroup';
export { ExtendedGroup };
import { Events } from '@yandeu/events';
import { Euler, Matrix4, Quaternion, Scene, Vector3 } from 'three';
import Factories from '@enable3d/common/dist/factories';
import { CollisionEvents } from './collisionEvents';
import DebugDrawer from './debugDrawer';
import { PhysicsLoader } from '@enable3d/common/dist/physicsLoader';
import DefaultMaterial from '@enable3d/common/dist/defaultMaterial';
export { PhysicsLoader };
import * as Types from '@enable3d/common/dist/types';
import { AllHitsRaycaster, ClosestRaycaster } from './raycaster/raycaster';
export { ClosestRaycaster, AllHitsRaycaster };
export { Types };
export { Clock } from './lib/Clock';
declare class AmmoPhysics extends Events {
    scene: Scene | 'headless';
    config: Types.ThreeGraphicsConfig;
    worldTransform: Ammo.btTransform;
    factory: Factories;
    isHeadless: boolean;
    rigidBodies: ExtendedObject3D[];
    protected earlierDetectedCollisions: {
        combinedName: string;
        collision: boolean;
    }[];
    protected gravity: {
        x: number;
        y: number;
        z: number;
    };
    protected tmpEuler: Euler;
    protected tmpQuaternion: Quaternion;
    protected tmpVector3: Vector3;
    protected tmpVector3a: Vector3;
    protected tmpMatrix4: Matrix4;
    protected tmpMatrix4a: Matrix4;
    protected tmpBtVector3: Ammo.btVector3;
    protected tmpBtQuaternion: Ammo.btQuaternion;
    physicsWorld: Ammo.btSoftRigidDynamicsWorld;
    protected debugDrawer: DebugDrawer;
    private convexBreaker;
    protected addRigidBody: (threeObject: ExtendedObject3D, physicsShape: any, mass: any, pos: any, quat: any) => void;
    private objectsToRemove;
    private numObjectsToRemove;
    protected emptyV3: Vector3;
    protected impactPoint: Vector3;
    protected impactNormal: Vector3;
    protected defaultMaterial: DefaultMaterial;
    private shapes;
    private constraints;
    collisionEvents: CollisionEvents;
    private readonly complexShapes;
    constructor(scene: Scene | 'headless', config?: Types.ThreeGraphicsConfig);
    /** @deprecated Use worldTransform instead of tmpTrans. */
    get tmpTrans(): Ammo.btTransform;
    /** @deprecated Use worldTransform instead of tmpTrans. */
    set tmpTrans(transform: Ammo.btTransform);
    /** Destroys a physics body. */
    destroy(body: PhysicsBody | ExtendedObject3D | ExtendedMesh): void;
    protected setup(): void;
    updateDebugger(): void;
    protected setupPhysicsWorld(): any;
    private createDebrisFromBreakableObject;
    private removeDebris;
    update(delta: number): void;
    private updatePhysics;
    private detectCollisions;
    setGravity(x?: number, y?: number, z?: number): void;
    get debug(): {
        enable: () => void;
        mode: (debugMode?: number) => void;
        disable: () => void;
    } | null;
    private start;
    get add(): {
        collider: (object1: ExtendedObject3D, object2: ExtendedObject3D, eventCallback: (event: Types.CollisionEvent) => void) => void;
        constraints: {
            lock: (bodyA: PhysicsBody, bodyB: PhysicsBody, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btGeneric6DofConstraint;
            fixed: (bodyA: PhysicsBody, bodyB: PhysicsBody, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btFixedConstraint;
            pointToPoint: (bodyA: PhysicsBody, bodyB: PhysicsBody, config: {
                pivotA?: Types.XYZ | undefined;
                pivotB?: Types.XYZ | undefined;
            }, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btPoint2PointConstraint;
            hinge: (bodyA: PhysicsBody, bodyB: PhysicsBody, config: {
                pivotA?: Types.XYZ | undefined;
                pivotB?: Types.XYZ | undefined;
                axisA?: Types.XYZ | undefined;
                axisB?: Types.XYZ | undefined;
            }, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btHingeConstraint;
            slider: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
                frameA?: Types.XYZ | undefined;
                frameB?: Types.XYZ | undefined;
                linearLowerLimit?: number | undefined;
                linearUpperLimit?: number | undefined;
                angularLowerLimit?: number | undefined;
                angularUpperLimit?: number | undefined;
            }, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btSliderConstraint;
            spring: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
                stiffness?: number | undefined;
                damping?: number | undefined;
                angularLock?: boolean | undefined;
                linearLowerLimit?: Types.XYZ | undefined;
                linearUpperLimit?: Types.XYZ | undefined;
                angularLowerLimit?: Types.XYZ | undefined;
                angularUpperLimit?: Types.XYZ | undefined;
                center?: boolean | undefined;
                offset?: Types.XYZ | undefined;
                enableSpring?: boolean | undefined;
            }, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btGeneric6DofSpringConstraint;
            coneTwist: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
                frameA: Types.XYZ;
                frameB: Types.XYZ;
            }, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btConeTwistConstraint;
            dof: (bodyA: PhysicsBody, bodyB: PhysicsBody, config?: {
                linearLowerLimit?: Types.XYZ | undefined;
                linearUpperLimit?: Types.XYZ | undefined;
                angularLowerLimit?: Types.XYZ | undefined;
                angularUpperLimit?: Types.XYZ | undefined;
                center?: boolean | undefined;
                offset?: Types.XYZ | undefined;
            } | undefined, disableCollisionsBetweenLinkedBodies?: boolean | undefined) => Ammo.btGeneric6DofConstraint;
        };
        existing: (object: ExtendedObject3D, config?: Types.AddExistingConfig) => any;
        plane: (planeConfig?: Types.PlaneConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        sphere: (sphereConfig?: Types.SphereConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        ground: (groundConfig?: Types.GroundConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        box: (boxConfig?: Types.BoxConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        cylinder: (cylinderConfig?: Types.CylinderConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        cone: (coneConfig?: Types.ConeConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        torus: (torusConfig?: Types.TorusConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        extrude: (extrudeConfig: Types.ExtrudeConfig, materialConfig?: Types.MaterialConfig) => ExtendedObject3D;
        /**
         * Creates a new Raycaster
         * @param type Returns only the closes body by default. Can be 'closest' or 'allHits'.
         */
        raycaster: (type?: string) => ClosestRaycaster | AllHitsRaycaster;
    };
    private prepareThreeObjectForCollisionShape;
    createCollisionShape(shape: string, params: any, object?: ExtendedObject3D): Ammo.btCollisionShape;
    mergeCollisionShapesToCompoundShape(collisionShapes: Ammo.btCollisionShape[]): Ammo.btCompoundShape;
    protected addExisting(object: ExtendedObject3D, config?: Types.AddExistingConfig): any;
    addRigidBodyToWorld(object: ExtendedObject3D, rigidBody: Ammo.btRigidBody, collisionFlags: number, collisionGroup: number, collisionMask: number, offset?: {
        x?: number;
        y?: number;
        z?: number;
    }): void;
    applyPosQuatScaleMargin(collisionShape: Ammo.btCollisionShape, pos?: Vector3, quat?: Quaternion, scale?: Vector3, margin?: number): Ammo.btTransform;
    collisionShapeToRigidBody(collisionShape: Ammo.btCollisionShape, localTransform: Ammo.btTransform, mass: number, disableDeactivation: boolean): Ammo.btRigidBody;
}
export { AmmoPhysics };
//# sourceMappingURL=physics.d.ts.map