/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import { logger } from '@enable3d/common/dist/logger';
export default class AllHitsRayResultCallback {
    constructor(physics) {
        this.physics = physics;
    }
    getHitPointsWorld() {
        const h = this._btRayCallback.get_m_hitPointWorld();
        const points = [];
        for (let i = h.size() - 1; i >= 0; i--) {
            const hh = h.at(i);
            points.push({ x: hh.x(), y: hh.y(), z: hh.z() });
        }
        return points;
    }
    // TODO: Remove this in future versions!
    getHitPointWorld() {
        logger('Use getHitPointsWorld() instead of getHitPointWorld() for the AllHitsRayCaster!');
        return this.getHitPointsWorld();
    }
    getHitNormalsWorld() {
        const h = this._btRayCallback.get_m_hitNormalWorld();
        const normals = [];
        for (let i = h.size() - 1; i >= 0; i--) {
            const hh = h.at(i);
            normals.push({ x: hh.x(), y: hh.y(), z: hh.z() });
        }
        return normals;
    }
    getCollisionObjects() {
        const threeObjects = [];
        const objects = this._btRayCallback.get_m_collisionObjects();
        for (let i = objects.size() - 1; i >= 0; i--) {
            // @ts-expect-error: castObject is not yet defined in the Ammo.js types.
            const rb = Ammo.castObject(objects.at(i), Ammo.btRigidBody);
            threeObjects.push(rb.threeObject);
        }
        return threeObjects;
    }
}
//# sourceMappingURL=allHitsRayResultCallback.js.map