/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
export default class ClosestRayResultCallback {
    constructor(physics) {
        this.physics = physics;
    }
    getHitPointWorld() {
        const h = this._btRayCallback.get_m_hitPointWorld();
        const point = { x: h.x(), y: h.y(), z: h.z() };
        return point;
    }
    getHitNormalWorld() {
        const h = this._btRayCallback.get_m_hitNormalWorld();
        const normal = { x: h.x(), y: h.y(), z: h.z() };
        return normal;
    }
    getCollisionObject() {
        // @ts-expect-error: castObject is not yet defined in the Ammo.js types.
        const rb = Ammo.castObject(this._btRayCallback.get_m_collisionObject(), Ammo.btRigidBody);
        return rb.threeObject;
    }
}
//# sourceMappingURL=closestRayResultCallback.js.map