/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import ClosestRayResultCallback from './closestRayResultCallback';
import AllHitsRayResultCallback from './allHitsRayResultCallback';
import { AmmoPhysics } from '../physics';
declare class Raycaster {
    protected physics: AmmoPhysics;
    readonly type: string;
    protected _btRayFrom: Ammo.btVector3;
    protected _btRayTo: Ammo.btVector3;
    protected _btRayCallback: Ammo.RayResultCallback;
    constructor(physics: AmmoPhysics);
    setRayFromWorld(x?: number, y?: number, z?: number): void;
    setRayToWorld(x?: number, y?: number, z?: number): void;
    hasHit(): boolean;
    rayTest(): void;
    destroy(): void;
}
interface ClosestRaycaster extends Raycaster, ClosestRayResultCallback {
}
interface AllHitsRaycaster extends Raycaster, AllHitsRayResultCallback {
}
declare class ClosestRaycaster implements Raycaster, ClosestRayResultCallback {
    protected physics: AmmoPhysics;
    readonly type = "closest";
    protected _btRayFrom: Ammo.btVector3;
    protected _btRayTo: Ammo.btVector3;
    protected _btRayCallback: Ammo.ClosestRayResultCallback;
    constructor(physics: AmmoPhysics);
}
declare class AllHitsRaycaster implements Raycaster, AllHitsRayResultCallback {
    protected physics: AmmoPhysics;
    readonly type = "allHits";
    protected _btRayFrom: Ammo.btVector3;
    protected _btRayTo: Ammo.btVector3;
    protected _btRayCallback: Ammo.AllHitsRayResultCallback;
    constructor(physics: AmmoPhysics);
}
export { ClosestRaycaster, AllHitsRaycaster };
//# sourceMappingURL=raycaster.d.ts.map