/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import applyMixins from '@enable3d/common/dist/applyMixins';
import ClosestRayResultCallback from './closestRayResultCallback';
import AllHitsRayResultCallback from './allHitsRayResultCallback';
class Raycaster {
    constructor(physics) {
        this.physics = physics;
    }
    setRayFromWorld(x = 0, y = 0, z = 0) {
        this._btRayFrom.setValue(x, y, z);
    }
    setRayToWorld(x = 0, y = 0, z = 0) {
        this._btRayTo.setValue(x, y, z);
    }
    hasHit() {
        return this._btRayCallback.hasHit();
    }
    rayTest() {
        if (typeof this._btRayCallback !== 'undefined')
            Ammo.destroy(this._btRayCallback);
        this._btRayCallback =
            this.type === 'closest'
                ? new Ammo.ClosestRayResultCallback(this._btRayFrom, this._btRayTo)
                : new Ammo.AllHitsRayResultCallback(this._btRayFrom, this._btRayTo);
        this.physics.physicsWorld.rayTest(this._btRayFrom, this._btRayTo, this._btRayCallback);
    }
    destroy() {
        if (typeof this._btRayFrom !== 'undefined')
            Ammo.destroy(this._btRayFrom);
        if (typeof this._btRayTo !== 'undefined')
            Ammo.destroy(this._btRayTo);
        if (typeof this._btRayCallback !== 'undefined')
            Ammo.destroy(this._btRayCallback);
    }
}
class ClosestRaycaster {
    constructor(physics) {
        this.physics = physics;
        this.type = 'closest';
        this._btRayFrom = new Ammo.btVector3(0, 0, 0);
        this._btRayTo = new Ammo.btVector3(0, 0, 0);
    }
}
class AllHitsRaycaster {
    constructor(physics) {
        this.physics = physics;
        this.type = 'allHits';
        this._btRayFrom = new Ammo.btVector3(0, 0, 0);
        this._btRayTo = new Ammo.btVector3(0, 0, 0);
    }
}
applyMixins(ClosestRaycaster, [Raycaster, ClosestRayResultCallback]);
applyMixins(AllHitsRaycaster, [Raycaster, AllHitsRayResultCallback]);
export { ClosestRaycaster, AllHitsRaycaster };
//# sourceMappingURL=raycaster.js.map