/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
import { AddExistingConfig, BoxConfig, ConeConfig, CylinderConfig, ExtendedObject3D, ExtrudeConfig, GroundConfig, MaterialConfig, PlaneConfig, SphereConfig, TorusConfig } from '@enable3d/common/dist/types';
import Factories from '@enable3d/common/dist/factories';
declare class Shapes {
    private factory;
    private addExisting;
    constructor(factory: Factories, addExisting: (object: ExtendedObject3D, config?: AddExistingConfig) => void);
    addPlane(planeConfig?: PlaneConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addSphere(sphereConfig?: SphereConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addBox(boxConfig?: BoxConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addGround(groundConfig: GroundConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addCylinder(cylinderConfig?: CylinderConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addCone(coneConfig?: ConeConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addTorus(torusConfig?: TorusConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
    addExtrude(extrudeConfig: ExtrudeConfig, materialConfig?: MaterialConfig): ExtendedObject3D;
}
export default Shapes;
//# sourceMappingURL=shapes.d.ts.map