/**
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2020 Yannick Deubel; Project Url: https://github.com/enable3d/enable3d
 * @license      {@link https://github.com/enable3d/enable3d/blob/master/LICENSE|GNU GPLv3}
 */
class Shapes {
    constructor(factory, addExisting) {
        this.factory = factory;
        this.addExisting = addExisting;
    }
    addPlane(planeConfig = {}, materialConfig = {}) {
        const plane = this.factory.add.plane(planeConfig, materialConfig);
        this.addExisting(plane, planeConfig);
        return plane;
    }
    addSphere(sphereConfig = {}, materialConfig = {}) {
        const sphere = this.factory.add.sphere(sphereConfig, materialConfig);
        this.addExisting(sphere, sphereConfig);
        return sphere;
    }
    addBox(boxConfig = {}, materialConfig = {}) {
        const box = this.factory.add.box(boxConfig, materialConfig);
        this.addExisting(box, boxConfig);
        return box;
    }
    addGround(groundConfig, materialConfig = {}) {
        const ground = this.factory.add.ground(groundConfig, materialConfig);
        const config = { ...groundConfig, mass: 0, collisionFlags: 1 };
        this.addExisting(ground, config);
        return ground;
    }
    addCylinder(cylinderConfig = {}, materialConfig = {}) {
        const cylinder = this.factory.add.cylinder(cylinderConfig, materialConfig);
        this.addExisting(cylinder, cylinderConfig);
        return cylinder;
    }
    addCone(coneConfig = {}, materialConfig = {}) {
        const cone = this.factory.add.cone(coneConfig, materialConfig);
        this.addExisting(cone, coneConfig);
        return cone;
    }
    addTorus(torusConfig = {}, materialConfig = {}) {
        const torus = this.factory.add.torus(torusConfig, materialConfig);
        this.addExisting(torus, torusConfig);
        return torus;
    }
    addExtrude(extrudeConfig, materialConfig = {}) {
        const object = this.factory.add.extrude(extrudeConfig, materialConfig);
        object.translateX(1);
        this.addExisting(object);
        return object;
    }
}
export default Shapes;
//# sourceMappingURL=shapes.js.map