# engine-handlebars [![NPM version](https://img.shields.io/npm/v/engine-handlebars.svg?style=flat)](https://www.npmjs.com/package/engine-handlebars) [![NPM monthly downloads](https://img.shields.io/npm/dm/engine-handlebars.svg?style=flat)](https://npmjs.org/package/engine-handlebars)  [![NPM total downloads](https://img.shields.io/npm/dt/engine-handlebars.svg?style=flat)](https://npmjs.org/package/engine-handlebars) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/engine-handlebars.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/engine-handlebars) [![Windows Build Status](https://img.shields.io/appveyor/ci/jonschlinkert/engine-handlebars.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/jonschlinkert/engine-handlebars)

> Handlebars engine, consolidate.js style but with enhancements. This works with Assemble, express.js, engine-cache or any application that follows consolidate.js conventions.

## Table of Contents

- [Install](#install)
- [Usage](#usage)
- [API](#api)
- [History](#history)
- [About](#about)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save engine-handlebars
```

**Heads up!** [Breaking changes in 0.8.0](#history).

## Usage

```js
var engine = require('engine-handlebars');
```

## API

### [.compile](index.js#L51)

Handlebars string support. Compile the given `str` and register helpers and partials from settings

**Params**

* `str` **{String}**: String or compiled function.
* `options` **{Object}**: object containing optional helpers and partials

**Example**

```js
var engine = require('engine-handlebars');
var fn = engine.compile('{{name}}', {});
```

### [.render](index.js#L84)

Handlebars string support. Render the given `str` and invoke the callback `cb(err, str)`.

**Params**

* `str` **{String|Function}**: String or compiled function.
* `locals` **{Object|Function}**: or callback.
* `cb` **{Function}**: callback function.

**Example**

```js
var engine = require('engine-handlebars');
engine.render('{{name}}', {name: 'Jon'}, function (err, content) {
  console.log(content); //=> 'Jon'
});
```

### [.renderFile](index.js#L125)

[Vinyl](https://github.com/gulpjs/vinyl) file support. Render tempates in the `contents` of the given `file` and invoke the callback `cb(err, file)`. If the file has a `data` object, it will be merged with locals and passed to templates as context. `data` wins over `locals`.

**Params**

* `file` **{Object}**: Vinyl file.
* `locals` **{Object|Function}**: or callback.
* `cb` **{Function}**: callback function.

**Example**

```js
var engine = require('engine-handlebars');
var file = new File({
  path: 'foo.hbs',
  contents: new Buffer('{{name}}')
});
engine.renderFile(file, {name: 'Foo'}, function (err, res) {
  console.log(res.contents.toString())
  //=> 'Foo'
});
```

### [.renderSync](index.js#L162)

Synchronously render Handlebars templates.

**Params**

* `str` **{Object|Function}**: The string to render or compiled function.
* `locals` **{Object}**
* `returns` **{String}**: Rendered string.

**Example**

```js
var engine = require('engine-handlebars');
engine.renderSync('<%= name %>', {name: 'Jon'});
//=> 'Jon'
```

## History

| **version** | **description** | 
| --- | --- |
| **v0.8.0**
 | `renderFile` now expects a [vinyl](https://github.com/gulpjs/vinyl) file. The old renderFile method is now exposed on `engine.__express` |
| **v0.7.0**
 | update to handlebars  0.4.0 |

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [handlebars-helpers](https://www.npmjs.com/package/handlebars-helpers): More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate… [more](https://github.com/assemble/handlebars-helpers) | [homepage](https://github.com/assemble/handlebars-helpers "More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate, Verb, Ghost, gulp-handlebars, grunt-handlebars, consolidate, or any node.js/Handlebars project.")
* [helper-cache](https://www.npmjs.com/package/helper-cache): Easily register and get helper functions to be passed to any template engine or node.js… [more](https://github.com/jonschlinkert/helper-cache) | [homepage](https://github.com/jonschlinkert/helper-cache "Easily register and get helper functions to be passed to any template engine or node.js application. Methods for both sync and async helpers.")
* [template-helpers](https://www.npmjs.com/package/template-helpers): Generic JavaScript helpers that can be used with any template engine. Handlebars, Lo-Dash, Underscore, or… [more](https://github.com/jonschlinkert/template-helpers) | [homepage](https://github.com/jonschlinkert/template-helpers "Generic JavaScript helpers that can be used with any template engine. Handlebars, Lo-Dash, Underscore, or any engine that supports helper functions.")
* [templates](https://www.npmjs.com/package/templates): System for creating and managing template collections, and rendering templates with any node.js template engine… [more](https://github.com/jonschlinkert/templates) | [homepage](https://github.com/jonschlinkert/templates "System for creating and managing template collections, and rendering templates with any node.js template engine. Can be used as the basis for creating a static site generator or blog framework.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- | --- | --- |
| 28 | [jonschlinkert](https://github.com/jonschlinkert) |
| 16 | [doowb](https://github.com/doowb) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
MIT

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.2, on February 21, 2017._