/*!
  * Tempus Dominus v6.1.2 (https://getdatepicker.com/)
  * Copyright 2013-2022 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).tempusDominus={})}(this,(function(t){"use strict";function e(t,e,s,i){return new(s||(s=Promise))((function(o,a){function n(t){try{d(i.next(t))}catch(t){a(t)}}function r(t){try{d(i.throw(t))}catch(t){a(t)}}function d(t){var e;t.done?o(t.value):(e=t.value,e instanceof s?e:new s((function(t){t(e)}))).then(n,r)}d((i=i.apply(t,e||[])).next())}))}var s;t.Unit=void 0,(s=t.Unit||(t.Unit={})).seconds="seconds",s.minutes="minutes",s.hours="hours",s.date="date",s.month="month",s.year="year";const i={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!0},o={hour:"2-digit",hour12:!1},a=t=>{switch(t){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}};class n extends Date{constructor(){super(...arguments),this.locale="default",this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335]}setLocale(t){return this.locale=t,this}static convert(t,e="default"){if(!t)throw new Error("A date is required");return new n(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()).setLocale(e)}static fromString(t,e){return new n(t)}get clone(){return new n(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocale(this.locale)}startOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":if(this.startOf(t.Unit.date),this.weekDay===s)break;let e=this.weekDay;0!==s&&0===this.weekDay&&(e=8-s),this.manipulate(s-e,t.Unit.date);break;case"month":this.startOf(t.Unit.date),this.setDate(1);break;case"year":this.startOf(t.Unit.date),this.setMonth(0,1)}return this}endOf(e,s=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":this.endOf(t.Unit.date),this.manipulate(6+s-this.weekDay,t.Unit.date);break;case"month":this.endOf(t.Unit.date),this.manipulate(1,t.Unit.month),this.setDate(0);break;case"year":this.endOf(t.Unit.date),this.manipulate(1,t.Unit.year),this.setDate(0)}return this}manipulate(t,e){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this[e]+=t,this}format(t,e=this.locale){return new Intl.DateTimeFormat(e,t).format(this)}isBefore(t,e){if(!e)return this.valueOf()<t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()<t.clone.startOf(e).valueOf()}isAfter(t,e){if(!e)return this.valueOf()>t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()>t.clone.startOf(e).valueOf()}isSame(t,e){if(!e)return this.valueOf()===t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return t=n.convert(t),this.clone.startOf(e).valueOf()===t.startOf(e).valueOf()}isBetween(t,e,s,i="()"){if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const o="("===i[0],a=")"===i[1];return(o?this.isAfter(t,s):!this.isBefore(t,s))&&(a?this.isBefore(e,s):!this.isAfter(e,s))||(o?this.isBefore(t,s):!this.isAfter(t,s))&&(a?this.isAfter(e,s):!this.isBefore(e,s))}parts(t=this.locale,e={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(t,e).formatToParts(this).filter((t=>"literal"!==t.type)).forEach((t=>s[t.type]=t.value)),s}get seconds(){return this.getSeconds()}set seconds(t){this.setSeconds(t)}get secondsFormatted(){return this.parts(void 0,i).second}get minutes(){return this.getMinutes()}set minutes(t){this.setMinutes(t)}get minutesFormatted(){return this.parts(void 0,i).minute}get hours(){return this.getHours()}set hours(t){this.setHours(t)}get hoursFormatted(){return this.parts(void 0,o).hour}get twelveHoursFormatted(){return this.parts(void 0,i).hour}meridiem(t=this.locale){var e;return null===(e=new Intl.DateTimeFormat(t,{hour:"numeric",hour12:!0}).formatToParts(this).find((t=>"dayPeriod"===t.type)))||void 0===e?void 0:e.value}get date(){return this.getDate()}set date(t){this.setDate(t)}get dateFormatted(){return this.parts(void 0,i).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(t){const e=new Date(this.year,t+1);e.setDate(0);const s=e.getDate();this.date>s&&(this.date=s),this.setMonth(t)}get monthFormatted(){return this.parts(void 0,i).month}get year(){return this.getFullYear()}set year(t){this.setFullYear(t)}get week(){const t=this.computeOrdinal(),e=this.getUTCDay();let s=Math.floor((t-e+10)/7);return s<1?s=this.weeksInWeekYear(this.year-1):s>this.weeksInWeekYear(this.year)&&(s=1),s}weeksInWeekYear(t){const e=(t+Math.floor(t/4)-Math.floor(t/100)+Math.floor(t/400))%7,s=t-1,i=(s+Math.floor(s/4)-Math.floor(s/100)+Math.floor(s/400))%7;return 4===e||3===i?53:52}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}}class r extends Error{}class d{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(t){const e=new r(`${this.base} Unexpected option: ${t} does not match a known option.`);throw e.code=1,e}unexpectedOptions(t){const e=new r(`${this.base}: ${t.join(", ")}`);throw e.code=1,e}unexpectedOptionValue(t,e,s){const i=new r(`${this.base} Unexpected option value: ${t} does not accept a value of "${e}". Valid values are: ${s.join(", ")}`);throw i.code=2,i}typeMismatch(t,e,s){const i=new r(`${this.base} Mismatch types: ${t} has a type of ${e} instead of the required ${s}`);throw i.code=3,i}numbersOutOfRage(t,e,s){const i=new r(`${this.base} ${t} expected an array of number between ${e} and ${s}.`);throw i.code=4,i}failedToParseDate(t,e,s=!1){const i=new r(`${this.base} Could not correctly parse "${e}" to a date for ${t}.`);if(i.code=5,!s)throw i;console.warn(i)}mustProvideElement(){const t=new r(`${this.base} No element was provided.`);throw t.code=6,t}subscribeMismatch(){const t=new r(`${this.base} The subscribed events does not match the number of callbacks`);throw t.code=7,t}conflictingConfiguration(t){const e=new r(`${this.base} A configuration value conflicts with another rule. ${t}`);throw e.code=8,e}customDateFormatError(t){const e=new r(`${this.base} customDateFormat: ${t}`);throw e.code=9,e}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string or use the customDateFormat plugin.`)}throwError(t){const e=new r(`${this.base} ${t}`);throw e.code=9,e}}const l="tempus-dominus";class c{}c.NAME=l,c.dataKey="td",c.events=new class{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},c.css=new class{constructor(){this.widget=`${l}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline",this.lightTheme="light",this.darkTheme="dark",this.isDarkPreferredQuery="(prefers-color-scheme: dark)"}},c.errorMessages=new d;class h{constructor(){this.cache=new Map}locate(t){const e=this.cache.get(t);if(e)return e;const s=new t;return this.cache.set(t,s),s}}let p;const u=[{name:"calendar",className:c.css.daysContainer,unit:t.Unit.month,step:1},{name:"months",className:c.css.monthsContainer,unit:t.Unit.year,step:1},{name:"years",className:c.css.yearsContainer,unit:t.Unit.year,step:10},{name:"decades",className:c.css.decadesContainer,unit:t.Unit.year,step:100}];class m{constructor(){this.viewDate=new n,this._currentCalendarViewMode=0,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(t){this._currentCalendarViewMode=t,this.currentView=u[t].name}refreshCurrentView(){this.currentView=u[this.currentCalendarViewMode].name}}class y{constructor(){this.optionsStore=p.locate(m)}isValid(e,s){var i;if(this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(e))return!1;if(this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(e))return!1;if(s!==t.Unit.month&&s!==t.Unit.year&&(null===(i=this.optionsStore.options.restrictions.daysOfWeekDisabled)||void 0===i?void 0:i.length)>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(e.weekDay))return!1;if(this.optionsStore.options.restrictions.minDate&&e.isBefore(this.optionsStore.options.restrictions.minDate,s))return!1;if(this.optionsStore.options.restrictions.maxDate&&e.isAfter(this.optionsStore.options.restrictions.maxDate,s))return!1;if(s===t.Unit.hours||s===t.Unit.minutes||s===t.Unit.seconds){if(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(e))return!1;if(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(e))return!1;if(this.optionsStore.options.restrictions.disabledTimeIntervals.length>0)for(let t of this.optionsStore.options.restrictions.disabledTimeIntervals)if(e.isBetween(t.from,t.to))return!1}return!0}_isInDisabledDates(e){if(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)return!1;const s=e.format(a(t.Unit.date));return this.optionsStore.options.restrictions.disabledDates.map((e=>e.format(a(t.Unit.date)))).find((t=>t===s))}_isInEnabledDates(e){if(!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length)return!0;const s=e.format(a(t.Unit.date));return this.optionsStore.options.restrictions.enabledDates.map((e=>e.format(a(t.Unit.date)))).find((t=>t===s))}_isInDisabledHours(t){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const e=t.hours;return this.optionsStore.options.restrictions.disabledHours.find((t=>t===e))}_isInEnabledHours(t){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const e=t.hours;return this.optionsStore.options.restrictions.enabledHours.find((t=>t===e))}}class v{constructor(){this.subscribers=[]}subscribe(t){return this.subscribers.push(t),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(t){this.subscribers.splice(t,1)}emit(t){this.subscribers.forEach((e=>{e(t)}))}destroy(){this.subscribers=null,this.subscribers=[]}}class g{constructor(){this.triggerEvent=new v,this.viewUpdate=new v,this.updateDisplay=new v,this.action=new v}destroy(){this.triggerEvent.destroy(),this.viewUpdate.destroy(),this.updateDisplay.destroy(),this.action.destroy()}}const S={restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:void 0},inline:!1,theme:"auto"},stepping:1,useCurrent:!0,defaultDate:void 0,localization:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",previousMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",previousYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",previousDecade:"Previous Decade",nextDecade:"Next Decade",previousCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",toggleMeridiem:"Toggle Meridiem",selectTime:"Select Time",selectDate:"Select Date",dayViewHeaderFormat:{month:"long",year:"2-digit"},locale:"default",startOfTheWeek:0,dateFormats:{LTS:"h:mm:ss T",LT:"h:mm T",L:"MM/dd/yyyy",LL:"MMMM d, yyyy",LLL:"MMMM d, yyyy h:mm T",LLLL:"dddd, MMMM d, yyyy h:mm T"},ordinal:t=>t,format:"L"},keepInvalid:!1,debug:!1,allowInputToggle:!1,viewDate:new n,multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,meta:{},container:void 0};class f{static deepCopy(t){const e={};return Object.keys(t).forEach((s=>{const i=t[s];e[s]=i,"object"!=typeof i||i instanceof HTMLElement||i instanceof Element||i instanceof Date||Array.isArray(i)||(e[s]=f.deepCopy(i))})),e}static objectPath(t,e){return"."===t.charAt(0)&&(t=t.slice(1)),t?t.split(".").reduce(((t,e)=>f.isValue(t)||f.isValue(t[e])?t[e]:void 0),e):e}static spread(t,e,s="",i){const o=f.objectPath(s,S),a=Object.keys(t).filter((t=>!Object.keys(o).includes(t)));if(a.length>0){const t=f.getFlattenDefaultOptions(),e=a.map((e=>{let i=`"${s}.${e}" in not a known option.`,o=t.find((t=>t.includes(e)));return o&&(i+=` Did you mean "${o}"?`),i}));c.errorMessages.unexpectedOptions(e)}Object.keys(t).filter((t=>"__proto__"!==t&&"constructor"!==t)).forEach((a=>{"."===(s+=`.${a}`).charAt(0)&&(s=s.slice(1));const n=o[a];let r=typeof t[a],d=typeof n,l=t[a];if(null==l)return e[a]=l,void(s=s.substring(0,s.lastIndexOf(`.${a}`)));"object"!=typeof n||Array.isArray(t[a])||n instanceof Date||f.ignoreProperties.includes(a)?e[a]=f.processKey(a,l,r,d,s,i):f.spread(t[a],e[a],s,i),s=s.substring(0,s.lastIndexOf(`.${a}`))}))}static processKey(t,e,s,i,o,a){switch(t){case"defaultDate":{const t=this.dateConversion(e,"defaultDate",a);if(void 0!==t)return t.setLocale(a.locale),t;c.errorMessages.typeMismatch("defaultDate",s,"DateTime or Date");break}case"viewDate":{const t=this.dateConversion(e,"viewDate",a);if(void 0!==t)return t.setLocale(a.locale),t;c.errorMessages.typeMismatch("viewDate",s,"DateTime or Date");break}case"minDate":{if(void 0===e)return e;const t=this.dateConversion(e,"restrictions.minDate",a);if(void 0!==t)return t.setLocale(a.locale),t;c.errorMessages.typeMismatch("restrictions.minDate",s,"DateTime or Date");break}case"maxDate":{if(void 0===e)return e;const t=this.dateConversion(e,"restrictions.maxDate",a);if(void 0!==t)return t.setLocale(a.locale),t;c.errorMessages.typeMismatch("restrictions.maxDate",s,"DateTime or Date");break}case"disabledHours":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.disabledHours",e,s),e.filter((t=>t<0||t>24)).length>0&&c.errorMessages.numbersOutOfRage("restrictions.disabledHours",0,23),e);case"enabledHours":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.enabledHours",e,s),e.filter((t=>t<0||t>24)).length>0&&c.errorMessages.numbersOutOfRage("restrictions.enabledHours",0,23),e);case"daysOfWeekDisabled":return void 0===e?[]:(this._typeCheckNumberArray("restrictions.daysOfWeekDisabled",e,s),e.filter((t=>t<0||t>6)).length>0&&c.errorMessages.numbersOutOfRage("restrictions.daysOfWeekDisabled",0,6),e);case"enabledDates":return void 0===e?[]:(this._typeCheckDateArray("restrictions.enabledDates",e,s,a),e);case"disabledDates":return void 0===e?[]:(this._typeCheckDateArray("restrictions.disabledDates",e,s,a),e);case"disabledTimeIntervals":if(void 0===e)return[];Array.isArray(e)||c.errorMessages.typeMismatch(t,s,"array of { from: DateTime|Date, to: DateTime|Date }");const n=e;for(let e=0;e<n.length;e++)Object.keys(n[e]).forEach((s=>{const i=`${t}[${e}].${s}`;let o=n[e][s];const r=this.dateConversion(o,i,a);r||c.errorMessages.typeMismatch(i,typeof o,"DateTime or Date"),r.setLocale(a.locale),n[e][s]=r}));return n;case"toolbarPlacement":case"type":case"viewMode":case"theme":const r={toolbarPlacement:["top","bottom","default"],type:["icons","sprites"],viewMode:["clock","calendar","months","years","decades"],theme:["light","dark","auto"]}[t];return r.includes(e)||c.errorMessages.unexpectedOptionValue(o.substring(1),e,r),e;case"meta":case"dayViewHeaderFormat":return e;case"container":return e&&!(e instanceof HTMLElement||e instanceof Element||(null==e?void 0:e.appendChild))&&c.errorMessages.typeMismatch(o.substring(1),typeof e,"HTMLElement"),e;case"useTwentyfourHour":if(void 0===e||"boolean"===s)return e;c.errorMessages.typeMismatch(o,s,i);break;default:switch(i){case"boolean":return"true"===e||!0===e;case"number":return+e;case"string":return e.toString();case"object":return{};case"function":return e;default:c.errorMessages.typeMismatch(o,s,i)}}}static _mergeOptions(t,e){var s;const i=f.deepCopy(e),o="default"!==(null===(s=e.localization)||void 0===s?void 0:s.locale)?e.localization:(null==t?void 0:t.localization)||S.localization;return f.spread(t,i,"",o),i}static _dataToOptions(t,e){const s=JSON.parse(JSON.stringify(t.dataset));if((null==s?void 0:s.tdTargetInput)&&delete s.tdTargetInput,(null==s?void 0:s.tdTargetToggle)&&delete s.tdTargetToggle,!s||0===Object.keys(s).length||s.constructor!==DOMStringMap)return e;let i={};const o=t=>{const e={};return Object.keys(t).forEach((t=>{e[t.toLowerCase()]=t})),e},a=(t,e,s,i)=>{const n=o(s)[t[e].toLowerCase()],r={};return void 0===n||(s[n].constructor===Object?(e++,r[n]=a(t,e,s[n],i)):r[n]=i),r},n=o(e);return Object.keys(s).filter((t=>t.startsWith(c.dataKey))).map((t=>t.substring(2))).forEach((t=>{let o=n[t.toLowerCase()];if(t.includes("_")){const r=t.split("_");o=n[r[0].toLowerCase()],void 0!==o&&e[o].constructor===Object&&(i[o]=a(r,1,e[o],s[`td${t}`]))}else void 0!==o&&(i[o]=s[`td${t}`])})),this._mergeOptions(i,e)}static _dateTypeCheck(t,e){if(t.constructor.name===n.name)return t;if(t.constructor.name===Date.name)return n.convert(t);if("string"==typeof t){const s=n.fromString(t,e);return"null"===JSON.stringify(s)?null:s}return null}static _typeCheckDateArray(t,e,s,i){var o;Array.isArray(e)||c.errorMessages.typeMismatch(t,s,"array of DateTime or Date");for(let s=0;s<e.length;s++){let a=e[s];const n=this.dateConversion(a,t,i);n||c.errorMessages.typeMismatch(t,typeof a,"DateTime or Date"),n.setLocale(null!==(o=null==i?void 0:i.locale)&&void 0!==o?o:"default"),e[s]=n}}static _typeCheckNumberArray(t,e,s){Array.isArray(e)&&!e.find((t=>"number"!=typeof t))||c.errorMessages.typeMismatch(t,s,"array of numbers")}static dateConversion(t,e,s){"string"==typeof t&&"input"!==e&&c.errorMessages.dateString();const i=this._dateTypeCheck(t,s);return i||c.errorMessages.failedToParseDate(e,t,"input"===e),i}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const t=(e,s=[])=>Array.isArray(e)?[]:Object(e)===e?Object.entries(e).flatMap((([e,i])=>t(i,[...s,e]))):s.join(".");return this._flattenDefaults=t(S),this._flattenDefaults}static _validateConflicts(t){!t.display.sideBySide||t.display.components.clock&&(t.display.components.hours||t.display.components.minutes||t.display.components.seconds)||c.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),t.restrictions.minDate&&t.restrictions.maxDate&&(t.restrictions.minDate.isAfter(t.restrictions.maxDate)&&c.errorMessages.conflictingConfiguration("minDate is after maxDate"),t.restrictions.maxDate.isBefore(t.restrictions.minDate)&&c.errorMessages.conflictingConfiguration("maxDate is before minDate"))}}f.ignoreProperties=["meta","dayViewHeaderFormat","container","dateForms","ordinal"],f.isValue=t=>null!=t;class w{constructor(){this._dates=[],this.optionsStore=p.locate(m),this.validation=p.locate(y),this._eventEmitters=p.locate(g)}get picked(){return this._dates}get lastPicked(){return this._dates[this.lastPickedIndex]}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(t){const e=this.optionsStore.options.display.components;return t?t.format({year:e.calendar&&e.year?"numeric":void 0,month:e.calendar&&e.month?"2-digit":void 0,day:e.calendar&&e.date?"2-digit":void 0,hour:e.clock&&e.hours?e.useTwentyfourHour?"2-digit":"numeric":void 0,minute:e.clock&&e.minutes?"2-digit":void 0,second:e.clock&&e.seconds?"2-digit":void 0,hour12:!e.useTwentyfourHour}):""}parseInput(t){return f.dateConversion(t,"input",this.optionsStore.options.localization)}setFromInput(t,e){if(!t)return void this.setValue(void 0,e);const s=this.parseInput(t);s&&(s.setLocale(this.optionsStore.options.localization.locale),this.setValue(s,e))}add(t){this._dates.push(t)}isPicked(t,e){if(!e)return void 0!==this._dates.find((e=>e===t));const s=a(e);let i=t.format(s);return void 0!==this._dates.map((t=>t.format(s))).find((t=>t===i))}pickedIndex(t,e){if(!e)return this._dates.indexOf(t);const s=a(e);let i=t.format(s);return this._dates.map((t=>t.format(s))).indexOf(i)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:c.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[]}static getStartEndYear(t,e){const s=t/10,i=Math.floor(e/t)*t;return[i,i+9*s,Math.floor(e/s)*s]}setValue(t,e){const s=void 0===e,i=!t&&s;let o=this.optionsStore.unset?null:this._dates[e];!o&&!this.optionsStore.unset&&s&&i&&(o=this.lastPicked);const a=()=>{if(!this.optionsStore.input)return;let e=this.formatInput(t);this.optionsStore.options.multipleDates&&(e=this._dates.map((t=>this.formatInput(t))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=e&&(this.optionsStore.input.value=e)};if(t&&(null==o?void 0:o.isSame(t)))a();else{if(!t)return!this.optionsStore.options.multipleDates||1===this._dates.length||i?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(e,1),a(),this._eventEmitters.triggerEvent.emit({type:c.events.change,date:void 0,oldDate:o,isClear:i,isValid:!0}),void this._eventEmitters.updateDisplay.emit("all");if(e=e||0,t=t.clone,1!==this.optionsStore.options.stepping&&(t.minutes=Math.round(t.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,t.seconds=0),this.validation.isValid(t))return this._dates[e]=t,this.optionsStore.viewDate=t.clone,a(),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),void this._eventEmitters.triggerEvent.emit({type:c.events.change,date:t,oldDate:o,isClear:i,isValid:!0});this.optionsStore.options.keepInvalid&&(this._dates[e]=t,this.optionsStore.viewDate=t.clone,a(),this._eventEmitters.triggerEvent.emit({type:c.events.change,date:t,oldDate:o,isClear:i,isValid:!1})),this._eventEmitters.triggerEvent.emit({type:c.events.error,reason:c.errorMessages.failedToSetInvalidDate,date:t,oldDate:o})}}}var b;!function(t){t.next="next",t.previous="previous",t.changeCalendarView="changeCalendarView",t.selectMonth="selectMonth",t.selectYear="selectYear",t.selectDecade="selectDecade",t.selectDay="selectDay",t.selectHour="selectHour",t.selectMinute="selectMinute",t.selectSecond="selectSecond",t.incrementHours="incrementHours",t.incrementMinutes="incrementMinutes",t.incrementSeconds="incrementSeconds",t.decrementHours="decrementHours",t.decrementMinutes="decrementMinutes",t.decrementSeconds="decrementSeconds",t.toggleMeridiem="toggleMeridiem",t.togglePicker="togglePicker",t.showClock="showClock",t.showHours="showHours",t.showMinutes="showMinutes",t.showSeconds="showSeconds",t.clear="clear",t.close="close",t.today="today"}(b||(b={}));var D=b;class k{constructor(){this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");if(t.classList.add(c.css.daysContainer),t.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(c.css.calendarWeeks,c.css.noHighlight),t.appendChild(e)}for(let e=0;e<42;e++){if(0!==e&&e%7==0&&this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(c.css.calendarWeeks,c.css.noHighlight),t.appendChild(e)}const s=document.createElement("div");s.setAttribute("data-action",D.selectDay),t.appendChild(s)}return t}_update(e,s){const i=e.getElementsByClassName(c.css.daysContainer)[0];if("calendar"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(c.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(c.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.optionsStore.options.display.components.month?s.classList.remove(c.css.disabled):s.classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.month),t.Unit.month)?e.classList.remove(c.css.disabled):e.classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.month),t.Unit.month)?o.classList.remove(c.css.disabled):o.classList.add(c.css.disabled)}let o=this.optionsStore.viewDate.clone.startOf(t.Unit.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,t.Unit.hours);i.querySelectorAll(`[data-action="${D.selectDay}"], .${c.css.calendarWeeks}`).forEach((e=>{if(this.optionsStore.options.display.calendarWeeks&&e.classList.contains(c.css.calendarWeeks)){if("#"===e.innerText)return;return void(e.innerText=`${o.week}`)}let i=[];i.push(c.css.day),o.isBefore(this.optionsStore.viewDate,t.Unit.month)&&i.push(c.css.old),o.isAfter(this.optionsStore.viewDate,t.Unit.month)&&i.push(c.css.new),!this.optionsStore.unset&&this.dates.isPicked(o,t.Unit.date)&&i.push(c.css.active),this.validation.isValid(o,t.Unit.date)||i.push(c.css.disabled),o.isSame(new n,t.Unit.date)&&i.push(c.css.today),0!==o.weekDay&&6!==o.weekDay||i.push(c.css.weekend),s(t.Unit.date,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.year}-${o.monthFormatted}-${o.dateFormatted}`),e.setAttribute("data-day",`${o.date}`),e.innerText=o.format({day:"numeric"}),o.manipulate(1,t.Unit.date)}))}_daysOfTheWeek(){let e=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(t.Unit.date);const s=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(c.css.calendarWeeks,c.css.noHighlight),t.innerText="#",s.push(t)}for(let i=0;i<7;i++){const i=document.createElement("div");i.classList.add(c.css.dayOfTheWeek,c.css.noHighlight),i.innerText=e.format({weekday:"short"}),e.manipulate(1,t.Unit.date),s.push(i)}return s}}class _{constructor(){this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.monthsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",D.selectMonth),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(c.css.monthsContainer)[0];if("months"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(c.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(c.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.optionsStore.options.display.components.year?s.classList.remove(c.css.disabled):s.classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),t.Unit.year)?e.classList.remove(c.css.disabled):e.classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.year),t.Unit.year)?o.classList.remove(c.css.disabled):o.classList.add(c.css.disabled)}let o=this.optionsStore.viewDate.clone.startOf(t.Unit.year);i.querySelectorAll(`[data-action="${D.selectMonth}"]`).forEach(((e,i)=>{let a=[];a.push(c.css.month),!this.optionsStore.unset&&this.dates.isPicked(o,t.Unit.month)&&a.push(c.css.active),this.validation.isValid(o,t.Unit.month)||a.push(c.css.disabled),s(t.Unit.month,o,a,e),e.classList.remove(...e.classList),e.classList.add(...a),e.setAttribute("data-value",`${i}`),e.innerText=`${o.format({month:"short"})}`,o.manipulate(1,t.Unit.month)}))}}class C{constructor(){this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.yearsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",D.selectYear),t.appendChild(e)}return t}_update(e,s){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,t.Unit.year);const i=e.getElementsByClassName(c.css.yearsContainer)[0];if("years"===this.optionsStore.currentView){const[e,s,o]=i.parentElement.getElementsByClassName(c.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(c.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.optionsStore.options.display.components.decades?s.classList.remove(c.css.disabled):s.classList.add(c.css.disabled),this.validation.isValid(this._startYear,t.Unit.year)?e.classList.remove(c.css.disabled):e.classList.add(c.css.disabled),this.validation.isValid(this._endYear,t.Unit.year)?o.classList.remove(c.css.disabled):o.classList.add(c.css.disabled)}let o=this.optionsStore.viewDate.clone.startOf(t.Unit.year).manipulate(-1,t.Unit.year);i.querySelectorAll(`[data-action="${D.selectYear}"]`).forEach((e=>{let i=[];i.push(c.css.year),!this.optionsStore.unset&&this.dates.isPicked(o,t.Unit.year)&&i.push(c.css.active),this.validation.isValid(o,t.Unit.year)||i.push(c.css.disabled),s(t.Unit.year,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.year}`),e.innerText=o.format({year:"numeric"}),o.manipulate(1,t.Unit.year)}))}}class M{constructor(){this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.decadesContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",D.selectDecade),t.appendChild(e)}return t}_update(e,s){const[i,o]=w.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._startDecade.year=i,this._endDecade=this.optionsStore.viewDate.clone.startOf(t.Unit.year),this._endDecade.year=o;const a=e.getElementsByClassName(c.css.decadesContainer)[0],[n,r,d]=a.parentElement.getElementsByClassName(c.css.calendarHeader)[0].getElementsByTagName("div");"decades"===this.optionsStore.currentView&&(r.setAttribute(c.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),this.validation.isValid(this._startDecade,t.Unit.year)?n.classList.remove(c.css.disabled):n.classList.add(c.css.disabled),this.validation.isValid(this._endDecade,t.Unit.year)?d.classList.remove(c.css.disabled):d.classList.add(c.css.disabled));const l=this.dates.picked.map((t=>t.year));a.querySelectorAll(`[data-action="${D.selectDecade}"]`).forEach(((e,i)=>{if(0===i)return e.classList.add(c.css.old),this._startDecade.year-10<0?(e.textContent=" ",n.classList.add(c.css.disabled),e.classList.add(c.css.disabled),void e.setAttribute("data-value","")):(e.innerText=this._startDecade.clone.manipulate(-10,t.Unit.year).format({year:"numeric"}),void e.setAttribute("data-value",`${this._startDecade.year}`));let o=[];o.push(c.css.decade);const a=this._startDecade.year,r=this._startDecade.year+9;!this.optionsStore.unset&&l.filter((t=>t>=a&&t<=r)).length>0&&o.push(c.css.active),s("decade",this._startDecade,o,e),e.classList.remove(...e.classList),e.classList.add(...o),e.setAttribute("data-value",`${this._startDecade.year}`),e.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,t.Unit.year)}))}}class E{constructor(){this._gridColumns="",this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y)}getPicker(t){const e=document.createElement("div");return e.classList.add(c.css.clockContainer),e.append(...this._grid(t)),e}_update(e){const s=e.getElementsByClassName(c.css.clockContainer)[0],i=(this.dates.lastPicked||this.optionsStore.viewDate).clone;if(s.querySelectorAll(".disabled").forEach((t=>t.classList.remove(c.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${D.incrementHours}]`).classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.hours),t.Unit.hours)||s.querySelector(`[data-action=${D.decrementHours}]`).classList.add(c.css.disabled),s.querySelector(`[data-time-component=${t.Unit.hours}]`).innerText=this.optionsStore.options.display.components.useTwentyfourHour?i.hoursFormatted:i.twelveHoursFormatted),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${D.incrementMinutes}]`).classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.minutes),t.Unit.minutes)||s.querySelector(`[data-action=${D.decrementMinutes}]`).classList.add(c.css.disabled),s.querySelector(`[data-time-component=${t.Unit.minutes}]`).innerText=i.minutesFormatted),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${D.incrementSeconds}]`).classList.add(c.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,t.Unit.seconds),t.Unit.seconds)||s.querySelector(`[data-action=${D.decrementSeconds}]`).classList.add(c.css.disabled),s.querySelector(`[data-time-component=${t.Unit.seconds}]`).innerText=i.secondsFormatted),!this.optionsStore.options.display.components.useTwentyfourHour){const e=s.querySelector(`[data-action=${D.toggleMeridiem}]`);e.innerText=i.meridiem(),this.validation.isValid(i.clone.manipulate(i.hours>=12?-12:12,t.Unit.hours))?e.classList.remove(c.css.disabled):e.classList.add(c.css.disabled)}s.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(e){this._gridColumns="";const s=[],i=[],o=[],a=document.createElement("div"),n=e(this.optionsStore.options.display.icons.up),r=e(this.optionsStore.options.display.icons.down);a.classList.add(c.css.separator,c.css.noHighlight);const d=a.cloneNode(!0);d.innerHTML=":";const l=(t=!1)=>t?d.cloneNode(!0):a.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementHour),e.setAttribute("data-action",D.incrementHours),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickHour),e.setAttribute("data-action",D.showHours),e.setAttribute("data-time-component",t.Unit.hours),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementHour),e.setAttribute("data-action",D.decrementHours),e.appendChild(r.cloneNode(!0)),o.push(e),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(s.push(l()),i.push(l(!0)),o.push(l()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementMinute),e.setAttribute("data-action",D.incrementMinutes),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickMinute),e.setAttribute("data-action",D.showMinutes),e.setAttribute("data-time-component",t.Unit.minutes),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementMinute),e.setAttribute("data-action",D.decrementMinutes),e.appendChild(r.cloneNode(!0)),o.push(e)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(s.push(l()),i.push(l(!0)),o.push(l()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementSecond),e.setAttribute("data-action",D.incrementSeconds),e.appendChild(n.cloneNode(!0)),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickSecond),e.setAttribute("data-action",D.showSeconds),e.setAttribute("data-time-component",t.Unit.seconds),i.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementSecond),e.setAttribute("data-action",D.decrementSeconds),e.appendChild(r.cloneNode(!0)),o.push(e)}if(!this.optionsStore.options.display.components.useTwentyfourHour){this._gridColumns+=" a";let t=l();s.push(t);let e=document.createElement("button");e.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),e.setAttribute("data-action",D.toggleMeridiem),e.setAttribute("tabindex","-1"),c.css.toggleMeridiem.includes(",")?e.classList.add(...c.css.toggleMeridiem.split(",")):e.classList.add(c.css.toggleMeridiem),t=document.createElement("div"),t.classList.add(c.css.noHighlight),t.appendChild(e),i.push(t),t=l(),o.push(t)}return this._gridColumns=this._gridColumns.trim(),[...s,...i,...o]}}class L{constructor(){this.optionsStore=p.locate(m),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.hourContainer);for(let e=0;e<(this.optionsStore.options.display.components.useTwentyfourHour?24:12);e++){const e=document.createElement("div");e.setAttribute("data-action",D.selectHour),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(c.css.hourContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.date);i.querySelectorAll(`[data-action="${D.selectHour}"]`).forEach((e=>{let i=[];i.push(c.css.hour),this.validation.isValid(o,t.Unit.hours)||i.push(c.css.disabled),s(t.Unit.hours,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.hours}`),e.innerText=this.optionsStore.options.display.components.useTwentyfourHour?o.hoursFormatted:o.twelveHoursFormatted,o.manipulate(1,t.Unit.hours)}))}}class T{constructor(){this.optionsStore=p.locate(m),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.minuteContainer);let e=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/e;s++){const e=document.createElement("div");e.setAttribute("data-action",D.selectMinute),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(c.css.minuteContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.hours),a=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;i.querySelectorAll(`[data-action="${D.selectMinute}"]`).forEach((e=>{let i=[];i.push(c.css.minute),this.validation.isValid(o,t.Unit.minutes)||i.push(c.css.disabled),s(t.Unit.minutes,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.minutes}`),e.innerText=o.minutesFormatted,o.manipulate(a,t.Unit.minutes)}))}}class U{constructor(){this.optionsStore=p.locate(m),this.validation=p.locate(y)}getPicker(){const t=document.createElement("div");t.classList.add(c.css.secondContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",D.selectSecond),t.appendChild(e)}return t}_update(e,s){const i=e.getElementsByClassName(c.css.secondContainer)[0];let o=this.optionsStore.viewDate.clone.startOf(t.Unit.minutes);i.querySelectorAll(`[data-action="${D.selectSecond}"]`).forEach((e=>{let i=[];i.push(c.css.second),this.validation.isValid(o,t.Unit.seconds)||i.push(c.css.disabled),s(t.Unit.seconds,o,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${o.seconds}`),e.innerText=o.secondsFormatted,o.manipulate(5,t.Unit.seconds)}))}}class A{static toggle(t){t.classList.contains(c.css.show)?this.hide(t):this.show(t)}static showImmediately(t){t.classList.remove(c.css.collapsing),t.classList.add(c.css.collapse,c.css.show),t.style.height=""}static show(t){if(t.classList.contains(c.css.collapsing)||t.classList.contains(c.css.show))return;t.style.height="0",t.classList.remove(c.css.collapse),t.classList.add(c.css.collapsing),setTimeout((()=>{A.showImmediately(t)}),this.getTransitionDurationFromElement(t)),t.style.height=`${t.scrollHeight}px`}static hideImmediately(t){t&&(t.classList.remove(c.css.collapsing,c.css.show),t.classList.add(c.css.collapse))}static hide(t){if(t.classList.contains(c.css.collapsing)||!t.classList.contains(c.css.show))return;t.style.height=`${t.getBoundingClientRect().height}px`;t.offsetHeight,t.classList.remove(c.css.collapse,c.css.show),t.classList.add(c.css.collapsing),t.style.height="",setTimeout((()=>{A.hideImmediately(t)}),this.getTransitionDurationFromElement(t))}}A.getTransitionDurationFromElement=t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),o=Number.parseFloat(s);return i||o?(e=e.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0};class ${constructor(){this._isVisible=!1,this._documentClickEvent=t=>{var e;this.optionsStore.options.debug||window.debug||!this._isVisible||t.composedPath().includes(this.widget)||(null===(e=t.composedPath())||void 0===e?void 0:e.includes(this.optionsStore.element))||this.hide()},this._actionsClickEvent=t=>{this._eventEmitters.action.emit({e:t})},this.optionsStore=p.locate(m),this.validation=p.locate(y),this.dates=p.locate(w),this.dateDisplay=p.locate(k),this.monthDisplay=p.locate(_),this.yearDisplay=p.locate(C),this.decadeDisplay=p.locate(M),this.timeDisplay=p.locate(E),this.hourDisplay=p.locate(L),this.minuteDisplay=p.locate(T),this.secondDisplay=p.locate(U),this._eventEmitters=p.locate(g),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((t=>{this._update(t)}))}get widget(){return this._widget}get isVisible(){return this._isVisible}_update(e){if(this.widget)switch(e){case t.Unit.seconds:this.secondDisplay._update(this.widget,this.paint);break;case t.Unit.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case t.Unit.hours:this.hourDisplay._update(this.widget,this.paint);break;case t.Unit.date:this.dateDisplay._update(this.widget,this.paint);break;case t.Unit.month:this.monthDisplay._update(this.widget,this.paint);break;case t.Unit.year:this.yearDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(t.Unit.hours),this._update(t.Unit.minutes),this._update(t.Unit.seconds);break;case"calendar":this._update(t.Unit.date),this._update(t.Unit.year),this._update(t.Unit.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(t,e,s,i){}show(){var e,s;if(null==this.widget){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const s=(new n).setLocale(this.optionsStore.options.localization.locale);if(!this.optionsStore.options.keepInvalid){let i=0,o=1;for((null===(e=this.optionsStore.options.restrictions.maxDate)||void 0===e?void 0:e.isBefore(s))&&(o=-1);!(this.validation.isValid(s)||(s.manipulate(o,t.Unit.date),i>31));)i++}this.dates.setValue(s)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}this._buildWidget(),this._updateTheme();const i=this._hasTime&&!this._hasDate;if(i&&(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:D.showClock})),this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),i||"clock"===this.optionsStore.options.display.viewMode||(this._hasTime&&(this.optionsStore.options.display.sideBySide?A.show(this.widget.querySelector(`div.${c.css.timeContainer}`)):A.hideImmediately(this.widget.querySelector(`div.${c.css.timeContainer}`))),A.show(this.widget.querySelector(`div.${c.css.dateContainer}`))),this._hasDate&&this._showMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{((null===(s=this.optionsStore.options)||void 0===s?void 0:s.container)||document.body).appendChild(this.widget),this.createPopup(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?"bottom-end":"bottom-start"}).then()}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:D.showClock}),this.widget.querySelectorAll("[data-action]").forEach((t=>t.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(c.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(c.css.show),this.optionsStore.options.display.inline||(this.updatePopup(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:c.events.show}),this._isVisible=!0}createPopup(t,s,i){return e(this,void 0,void 0,(function*(){const{createPopper:e}=yield import("@popperjs/core");this._popperInstance=e(t,s,i)}))}updatePopup(){var t;null===(t=this._popperInstance)||void 0===t||t.update()}_showMode(t){if(!this.widget)return;if(t){const e=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+t));if(this.optionsStore.currentCalendarViewMode==e)return;this.optionsStore.currentCalendarViewMode=e}this.widget.querySelectorAll(`.${c.css.dateContainer} > div:not(.${c.css.calendarHeader}), .${c.css.timeContainer} > div:not(.${c.css.clockContainer})`).forEach((t=>t.style.display="none"));const e=u[this.optionsStore.currentCalendarViewMode];let s=this.widget.querySelector(`.${e.className}`);switch(e.className){case c.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case c.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case c.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case c.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}s.style.display="grid",this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit()}_updateTheme(t){if(this.widget){if(t){if(this.optionsStore.options.display.theme===t)return;this.optionsStore.options.display.theme=t}this.widget.classList.remove("light","dark"),this.widget.classList.add(this._getThemeClass()),"auto"===this.optionsStore.options.display.theme?window.matchMedia(c.css.isDarkPreferredQuery).addEventListener("change",(()=>this._updateTheme())):window.matchMedia(c.css.isDarkPreferredQuery).removeEventListener("change",(()=>this._updateTheme()))}}_getThemeClass(){const t=this.optionsStore.options.display.theme||"auto",e=window.matchMedia&&window.matchMedia(c.css.isDarkPreferredQuery).matches;switch(t){case"light":return c.css.lightTheme;case"dark":return c.css.darkTheme;case"auto":return e?c.css.darkTheme:c.css.lightTheme}}_updateCalendarHeader(){const t=[...this.widget.querySelector(`.${c.css.dateContainer} div[style*="display: grid"]`).classList].find((t=>t.startsWith(c.css.dateContainer))),[e,s,i]=this.widget.getElementsByClassName(c.css.calendarHeader)[0].getElementsByTagName("div");switch(t){case c.css.decadesContainer:e.setAttribute("title",this.optionsStore.options.localization.previousCentury),s.setAttribute("title",""),i.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case c.css.yearsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousDecade),s.setAttribute("title",this.optionsStore.options.localization.selectDecade),i.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case c.css.monthsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousYear),s.setAttribute("title",this.optionsStore.options.localization.selectYear),i.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case c.css.daysContainer:e.setAttribute("title",this.optionsStore.options.localization.previousMonth),s.setAttribute("title",this.optionsStore.options.localization.selectMonth),i.setAttribute("title",this.optionsStore.options.localization.nextMonth),s.innerText=this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)}s.innerText=s.getAttribute(t)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(c.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:c.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?this.dates.lastPicked.clone:void 0}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent))}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((t=>t.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const t=document.createElement("div");t.classList.add(c.css.widget);const e=document.createElement("div");e.classList.add(c.css.dateContainer),e.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const s=document.createElement("div");s.classList.add(c.css.timeContainer),s.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),s.appendChild(this.hourDisplay.getPicker()),s.appendChild(this.minuteDisplay.getPicker()),s.appendChild(this.secondDisplay.getPicker());const i=document.createElement("div");if(i.classList.add(c.css.toolbar),i.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&t.classList.add(c.css.inline),this.optionsStore.options.display.calendarWeeks&&t.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){t.classList.add(c.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");return o.classList.add("td-row"),e.classList.add("td-half"),s.classList.add("td-half"),o.appendChild(e),o.appendChild(s),t.appendChild(o),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),void(this._widget=t)}"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i),this._hasDate&&(this._hasTime&&(e.classList.add(c.css.collapse),"clock"!==this.optionsStore.options.display.viewMode&&e.classList.add(c.css.show)),t.appendChild(e)),this._hasTime&&(this._hasDate&&(s.classList.add(c.css.collapse),"clock"===this.optionsStore.options.display.viewMode&&s.classList.add(c.css.show)),t.appendChild(s)),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(i);const o=document.createElement("div");o.classList.add("arrow"),o.setAttribute("data-popper-arrow",""),t.appendChild(o),this._widget=t}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}getToolbarElements(){const t=[];if(this.optionsStore.options.display.buttons.today){const e=document.createElement("div");e.setAttribute("data-action",D.today),e.setAttribute("title",this.optionsStore.options.localization.today),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),t.push(e)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let e,s;"clock"===this.optionsStore.options.display.viewMode?(e=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(e=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.setAttribute("data-action",D.togglePicker),i.setAttribute("title",e),i.appendChild(this._iconTag(s)),t.push(i)}if(this.optionsStore.options.display.buttons.clear){const e=document.createElement("div");e.setAttribute("data-action",D.clear),e.setAttribute("title",this.optionsStore.options.localization.clear),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),t.push(e)}if(this.optionsStore.options.display.buttons.close){const e=document.createElement("div");e.setAttribute("data-action",D.close),e.setAttribute("title",this.optionsStore.options.localization.close),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),t.push(e)}return t}getHeadTemplate(){const t=document.createElement("div");t.classList.add(c.css.calendarHeader);const e=document.createElement("div");e.classList.add(c.css.previous),e.setAttribute("data-action",D.previous),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.previous));const s=document.createElement("div");s.classList.add(c.css.switch),s.setAttribute("data-action",D.changeCalendarView);const i=document.createElement("div");return i.classList.add(c.css.next),i.setAttribute("data-action",D.next),i.appendChild(this._iconTag(this.optionsStore.options.display.icons.next)),t.append(e,s,i),t}_iconTag(t){if("sprites"===this.optionsStore.options.display.icons.type){const e=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",t),s.setAttribute("href",t),e.appendChild(s),e}const e=document.createElement("i");return e.classList.add(...t.split(" ")),e}_rebuild(){const t=this._isVisible;t&&this.hide(),this._dispose(),t&&this.show()}}class O{constructor(){this.optionsStore=p.locate(m),this.dates=p.locate(w),this.validation=p.locate(y),this.display=p.locate($),this._eventEmitters=p.locate(g),this._eventEmitters.action.subscribe((t=>{this.do(t.e,t.action)}))}do(e,s){var i,o;const a=null==e?void 0:e.currentTarget;if(null===(i=null==a?void 0:a.classList)||void 0===i?void 0:i.contains(c.css.disabled))return!1;s=s||(null===(o=null==a?void 0:a.dataset)||void 0===o?void 0:o.action);const r=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(s){case D.next:case D.previous:this.handleNextPrevious(s);break;case D.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case D.selectMonth:case D.selectYear:case D.selectDecade:const i=+a.dataset.value;switch(s){case D.selectMonth:this.optionsStore.viewDate.month=i;break;case D.selectYear:case D.selectDecade:this.optionsStore.viewDate.year=i}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1);break;case D.selectDay:const o=this.optionsStore.viewDate.clone;a.classList.contains(c.css.old)&&o.manipulate(-1,t.Unit.month),a.classList.contains(c.css.new)&&o.manipulate(1,t.Unit.month),o.date=+a.dataset.day;let d=0;this.optionsStore.options.multipleDates?(d=this.dates.pickedIndex(o,t.Unit.date),-1!==d?this.dates.setValue(null,d):this.dates.setValue(o,this.dates.lastPickedIndex+1)):this.dates.setValue(o,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.display.hide();break;case D.selectHour:let l=+a.dataset.value;r.hours>=12&&!this.optionsStore.options.display.components.useTwentyfourHour&&(l+=12),r.hours=l,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case D.selectMinute:r.minutes=+a.dataset.value,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case D.selectSecond:r.seconds=+a.dataset.value,this.dates.setValue(r,this.dates.lastPickedIndex),this.hideOrClock(e);break;case D.incrementHours:this.manipulateAndSet(r,t.Unit.hours);break;case D.incrementMinutes:this.manipulateAndSet(r,t.Unit.minutes,this.optionsStore.options.stepping);break;case D.incrementSeconds:this.manipulateAndSet(r,t.Unit.seconds);break;case D.decrementHours:this.manipulateAndSet(r,t.Unit.hours,-1);break;case D.decrementMinutes:this.manipulateAndSet(r,t.Unit.minutes,-1*this.optionsStore.options.stepping);break;case D.decrementSeconds:this.manipulateAndSet(r,t.Unit.seconds,-1);break;case D.toggleMeridiem:this.manipulateAndSet(r,t.Unit.hours,this.dates.lastPicked.hours>=12?-12:12);break;case D.togglePicker:a.getAttribute("title")===this.optionsStore.options.localization.selectDate?(a.setAttribute("title",this.optionsStore.options.localization.selectTime),a.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(a.setAttribute("title",this.optionsStore.options.localization.selectDate),a.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.handleShowClockContainers(D.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${c.css.dateContainer}, .${c.css.timeContainer}`).forEach((t=>A.toggle(t))),this._eventEmitters.viewUpdate.emit();break;case D.showClock:case D.showHours:case D.showMinutes:case D.showSeconds:this.optionsStore.options.display.sideBySide||"clock"===this.optionsStore.currentView||(A.hideImmediately(this.display.widget.querySelector(`div.${c.css.dateContainer}`)),A.showImmediately(this.display.widget.querySelector(`div.${c.css.timeContainer}`))),this.handleShowClockContainers(s);break;case D.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case D.close:this.display.hide();break;case D.today:const h=(new n).setLocale(this.optionsStore.options.localization.locale);this.optionsStore.viewDate=h,this.validation.isValid(h,t.Unit.date)&&this.dates.setValue(h,this.dates.lastPickedIndex)}}handleShowClockContainers(e){if(!this.display._hasTime)return void c.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${c.css.timeContainer} > div`).forEach((t=>t.style.display="none"));let s="";switch(e){case D.showClock:s=c.css.clockContainer,this.display._update("clock");break;case D.showHours:s=c.css.hourContainer,this.display._update(t.Unit.hours);break;case D.showMinutes:s=c.css.minuteContainer,this.display._update(t.Unit.minutes);break;case D.showSeconds:s=c.css.secondContainer,this.display._update(t.Unit.seconds)}this.display.widget.getElementsByClassName(s)[0].style.display="grid"}handleNextPrevious(t){const{unit:e,step:s}=u[this.optionsStore.currentCalendarViewMode];t===D.next?this.optionsStore.viewDate.manipulate(s,e):this.optionsStore.viewDate.manipulate(-1*s,e),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(t){!this.optionsStore.options.display.components.useTwentyfourHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(t,D.showClock):this.display.hide()}manipulateAndSet(t,e,s=1){const i=t.manipulate(s,e);this.validation.isValid(i,e)&&this.dates.setValue(i,this.dates.lastPickedIndex)}}class V{constructor(t,e={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=t=>{if(null==t?void 0:t.detail)return;const e=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked.clone)},s=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates)try{const t=s.split(this.optionsStore.options.multipleDatesSeparator);for(let e=0;e<t.length;e++)this.dates.setFromInput(t[e],e);e()}catch(t){console.warn("TD: Something went wrong trying to set the multipleDates values from the input field.")}else this.dates.setFromInput(s,0),e()},this._toggleClickEvent=()=>{var t,e;(null===(t=this.optionsStore.element)||void 0===t?void 0:t.disabled)||(null===(e=this.optionsStore.input)||void 0===e?void 0:e.disabled)||this.toggle()},p=new h,this._eventEmitters=p.locate(g),this.optionsStore=p.locate(m),this.display=p.locate($),this.dates=p.locate(w),this.actions=p.locate(O),t||c.errorMessages.mustProvideElement(),this.optionsStore.element=t,this._initializeOptions(e,S,!0),this.optionsStore.viewDate.setLocale(this.optionsStore.options.localization.locale),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((t=>{this._triggerEvent(t)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()}))}get viewDate(){return this.optionsStore.viewDate}updateOptions(t,e=!1){e?this._initializeOptions(t,S):this._initializeOptions(t,this.optionsStore.options),this.display._rebuild()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){var t;this._isDisabled=!0,null===(t=this.optionsStore.input)||void 0===t||t.setAttribute("disabled","disabled"),this.display.hide()}enable(){var t;this._isDisabled=!1,null===(t=this.optionsStore.input)||void 0===t||t.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(t,e){let s;"string"==typeof t&&(t=[t]),s=Array.isArray(e)?e:[e],t.length!==s.length&&c.errorMessages.subscribeMismatch();const i=[];for(let e=0;e<t.length;e++){const o=t[e];if(Array.isArray(this._subscribers[o])||(this._subscribers[o]=[]),this._subscribers[o].push(s[e]),i.push({unsubscribe:this._unsubscribe.bind(this,o,this._subscribers[o].length-1)}),1===t.length)return i[0]}return i}dispose(){var t,e,s;this.display.hide(),this.display._dispose(),null===(t=this.optionsStore.input)||void 0===t||t.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(null===(e=this.optionsStore.input)||void 0===e||e.removeEventListener("click",this._toggleClickEvent)),null===(s=this._toggle)||void 0===s||s.removeEventListener("click",this._toggleClickEvent),this._subscribers={}}locale(t){let e=H[t];e&&this.updateOptions({localization:e})}_triggerEvent(t){var e,s;t.viewMode=this.optionsStore.currentView;const i=t.type===c.events.change;if(i){const{date:i,oldDate:o,isClear:a}=t;if(i&&o&&i.isSame(o)||!a&&!i&&!o)return;this._handleAfterChangeEvent(t),null===(e=this.optionsStore.input)||void 0===e||e.dispatchEvent(new CustomEvent(t.type,{detail:t})),null===(s=this.optionsStore.input)||void 0===s||s.dispatchEvent(new CustomEvent("change",{detail:t}))}if(this.optionsStore.element.dispatchEvent(new CustomEvent(t.type,{detail:t})),window.jQuery){const e=window.jQuery;i&&this.optionsStore.input?e(this.optionsStore.input).trigger(t):e(this.optionsStore.element).trigger(t)}this._publish(t)}_publish(t){Array.isArray(this._subscribers[t.type])&&this._subscribers[t.type].forEach((e=>{e(t)}))}_viewUpdate(){this._triggerEvent({type:c.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(t,e){this._subscribers[t].splice(e,1)}_initializeOptions(t,e,s=!1){var i,o;let a=f.deepCopy(t);a=f._mergeOptions(a,e),s&&(a=f._dataToOptions(this.optionsStore.element,a)),f._validateConflicts(a),a.viewDate=a.viewDate.setLocale(a.localization.locale),this.optionsStore.viewDate.isSame(a.viewDate)||(this.optionsStore.viewDate=a.viewDate),a.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),a.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),a.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),u[this.optionsStore.currentCalendarViewMode].name!==a.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(u.findIndex((t=>t.name===a.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),(null===(i=this.display)||void 0===i?void 0:i.isVisible)&&this.display._update("all"),void 0===a.display.components.useTwentyfourHour&&(a.display.components.useTwentyfourHour=!(null===(o=a.viewDate.parts())||void 0===o?void 0:o.dayPeriod)),this.optionsStore.options=a}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{let t=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==t||"nearest"==t?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(t)}this.optionsStore.input&&(this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&this.optionsStore.input.addEventListener("click",this._toggleClickEvent),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let t=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==t&&(t='[data-td-toggle="datetimepicker"]'),this._toggle=null==t?this.optionsStore.element:this.optionsStore.element.querySelector(t),this._toggle.addEventListener("click",this._toggleClickEvent)}_handleAfterChangeEvent(t){var e,s;!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||(null===(e=this.display.widget)||void 0===e?void 0:e.getElementsByClassName(c.css.show)[0].classList.contains(c.css.timeContainer))||!t.oldDate&&this.optionsStore.options.useCurrent||t.oldDate&&(null===(s=t.date)||void 0===s?void 0:s.isSame(t.oldDate))||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector(`.${c.css.switch} div`)},action:D.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}}const H={},x=t=>{H[t.name]||(H[t.name]=t.localization)},P=t=>{let e=H[t];e&&(S.localization=e)},I=function(t,e){return t?(t.installed||(t(e,{TempusDominus:V,Dates:w,Display:$,DateTime:n,ErrorMessages:d},z),t.installed=!0),z):z},N="6.1.2",z={TempusDominus:V,extend:I,loadLocale:x,locale:P,Namespace:c,DefaultOptions:S,DateTime:n,Unit:t.Unit,version:N};t.DateTime=n,t.DefaultOptions=S,t.Namespace=c,t.TempusDominus=V,t.extend=I,t.loadLocale=x,t.locale=P,t.version=N,Object.defineProperty(t,"__esModule",{value:!0})}));
