/*!
  * Tempus Dominus v6.10.0 (https://getdatepicker.com/)
  * Copyright 2013-2025 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
class t extends Error{}const e="tempus-dominus";class s{}s.NAME=e,s.dataKey="td",s.events=new class{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},s.css=new class{constructor(){this.widget=`${e}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.rangeIn="range-in",this.rangeStart="range-start",this.rangeEnd="range-end",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline",this.lightTheme="light",this.darkTheme="dark",this.isDarkPreferredQuery="(prefers-color-scheme: dark)"}},s.errorMessages=new class{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(e){const s=new t(`${this.base} Unexpected option: ${e} does not match a known option.`);throw s.code=1,s}unexpectedOptions(e){const s=new t(`${this.base}: ${e.join(", ")}`);throw s.code=1,s}unexpectedOptionValue(e,s,i){const o=new t(`${this.base} Unexpected option value: ${e} does not accept a value of "${s}". Valid values are: ${i.join(", ")}`);throw o.code=2,o}typeMismatch(e,s,i){const o=new t(`${this.base} Mismatch types: ${e} has a type of ${s} instead of the required ${i}`);throw o.code=3,o}numbersOutOfRange(e,s,i){const o=new t(`${this.base} ${e} expected an array of number between ${s} and ${i}.`);throw o.code=4,o}failedToParseDate(e,s,i=!1){const o=new t(`${this.base} Could not correctly parse "${s}" to a date for ${e}.`);if(o.code=5,!i)throw o;console.warn(o)}mustProvideElement(){const e=new t(`${this.base} No element was provided.`);throw e.code=6,e}subscribeMismatch(){const e=new t(`${this.base} The subscribed events does not match the number of callbacks`);throw e.code=7,e}conflictingConfiguration(e){const s=new t(`${this.base} A configuration value conflicts with another rule. ${e}`);throw s.code=8,s}customDateFormatError(e){const s=new t(`${this.base} Custom Date Format: ${e}`);throw s.code=9,s}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string or use the customDateFormat plugin.`)}deprecatedWarning(t,e){console.warn(`${this.base} Warning ${t} is deprecated and will be removed in a future version. ${e}`)}throwError(e){const s=new t(`${this.base} ${e}`);throw s.code=9,s}};var i,o={...{dateFormats:{LTS:"h:mm:ss T",LT:"h:mm T",L:"MM/dd/yyyy",LL:"MMMM d, yyyy",LLL:"MMMM d, yyyy h:mm T",LLLL:"dddd, MMMM d, yyyy h:mm T"},format:"L LT",locale:"default",hourCycle:void 0,ordinal:t=>{const e=["th","st","nd","rd"],s=t%100;return`[${t}${e[(s-20)%10]||e[s]||e[0]}]`}}};!function(t){t.seconds="seconds",t.minutes="minutes",t.hours="hours",t.date="date",t.month="month",t.year="year"}(i||(i={}));const a={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit"},n=t=>{switch(t){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}},r=t=>{if(!t)return"h12";const e={hour:"2-digit",minute:"2-digit",numberingSystem:"latn"},s=(new d).setLocalization({locale:t});s.hours=0;const i=s.parts(void 0,e).hour;if("12"===i)return"h12";if("24"===i)return"h24";s.hours=23;const o=s.parts(void 0,e).hour;return"00"===i&&"11"===o?"h11":"00"===i&&"23"===o?"h23":void console.warn(`couldn't determine hour cycle for ${t}. start: ${i}. end: ${o}`)};class d extends Date{constructor(){super(...arguments),this.localization=o,this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335],this.dateTimeRegex=/(\[[^[\]]*])|y{1,4}|M{1,4}|d{1,4}|H{1,2}|h{1,2}|t|T|m{1,2}|s{1,2}|f{3}/g,this.formattingTokens=/(\[[^[\]]*])|([-_:/.,()\s]+)|(T|t|yyyy|yy?|MM?M?M?|Do|dd?d?d?|hh?|HH?|mm?|ss?)/g,this.match2=/\d\d/,this.match3=/\d{3}/,this.match4=/\d{4}/,this.match1to2=/\d\d?/,this.matchSigned=/[+-]?\d+/,this.matchOffset=/[+-]\d\d:?(\d\d)?|Z/,this.matchWord=/[^\d_:/,\-()\s]+/,this.zoneExpressions=[this.matchOffset,(t,e)=>{t.offset=this.offsetFromString(e)}],this.expressions={t:{pattern:void 0,parser:(t,e)=>{t.afternoon=this.meridiemMatch(e)}},T:{pattern:void 0,parser:(t,e)=>{t.afternoon=this.meridiemMatch(e)}},fff:{pattern:this.match3,parser:(t,e)=>{t.milliseconds=+e}},s:{pattern:this.match1to2,parser:this.addInput("seconds")},ss:{pattern:this.match1to2,parser:this.addInput("seconds")},m:{pattern:this.match1to2,parser:this.addInput("minutes")},mm:{pattern:this.match1to2,parser:this.addInput("minutes")},H:{pattern:this.match1to2,parser:this.addInput("hours")},h:{pattern:this.match1to2,parser:this.addInput("hours")},HH:{pattern:this.match1to2,parser:this.addInput("hours")},hh:{pattern:this.match1to2,parser:this.addInput("hours")},d:{pattern:this.match1to2,parser:this.addInput("day")},dd:{pattern:this.match2,parser:this.addInput("day")},Do:{pattern:this.matchWord,parser:(t,e)=>{if(t.day=+(e.match(/\d+/)[0]||1),this.localization.ordinal)for(let s=1;s<=31;s+=1)this.localization.ordinal(s).replace(/[[\]]/g,"")===e&&(t.day=s)}},M:{pattern:this.match1to2,parser:this.addInput("month")},MM:{pattern:this.match2,parser:this.addInput("month")},MMM:{pattern:this.matchWord,parser:(t,e)=>{const s=this.getAllMonths(),i=(this.getAllMonths("short")||s.map((t=>t.slice(0,3)))).indexOf(e)+1;if(i<1)throw new Error;t.month=i%12||i}},MMMM:{pattern:this.matchWord,parser:(t,e)=>{const s=this.getAllMonths().indexOf(e)+1;if(s<1)throw new Error;t.month=s%12||s}},y:{pattern:this.matchSigned,parser:this.addInput("year")},yy:{pattern:this.match2,parser:(t,e)=>{t.year=this.parseTwoDigitYear(+e)}},yyyy:{pattern:this.match4,parser:this.addInput("year")}}}setLocale(t){return this.localization||(this.localization=o,this.localization.locale=t),this}setLocalization(t){return this.localization=t,this}static convert(t,e="default",s=undefined){if(!t)throw new Error("A date is required");return s||((s=o).locale=e),new d(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()).setLocalization(s)}get clone(){return new d(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocalization(this.localization)}static isValid(t){return void 0!==t&&"null"!==JSON.stringify(t)&&t.constructor.name===d.name}startOf(t,e=0){if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);switch(t){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":{if(this.startOf(i.date),this.weekDay===e)break;const t=(this.weekDay-e+7)%7;this.manipulate(-1*t,i.date);break}case"month":this.startOf(i.date),this.setDate(1);break;case"year":this.startOf(i.date),this.setMonth(0,1)}return this}endOf(t,e=0){if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);switch(t){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":{this.endOf(i.date);const t=6+e;if(this.weekDay===t)break;this.manipulate(t-this.weekDay,i.date);break}case"month":this.endOf(i.date),this.manipulate(1,i.month),this.setDate(0);break;case"year":this.endOf(i.date),this.setMonth(11,31)}return this}manipulate(t,e){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this[e]+=t,this}isBefore(t,e){if(!d.isValid(t))return!1;if(!e)return this.valueOf()<t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()<t.clone.startOf(e).valueOf()}isAfter(t,e){if(!d.isValid(t))return!1;if(!e)return this.valueOf()>t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return this.clone.startOf(e).valueOf()>t.clone.startOf(e).valueOf()}isSame(t,e){if(!d.isValid(t))return!1;if(!e)return this.valueOf()===t.valueOf();if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);return t=d.convert(t),this.clone.startOf(e).valueOf()===t.startOf(e).valueOf()}isBetween(t,e,s,i="()"){if(!d.isValid(t)||!d.isValid(e))return!1;if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const o="("===i[0],a=")"===i[1],n=o?this.isAfter(t,s):!this.isBefore(t,s),r=a?this.isBefore(e,s):!this.isAfter(e,s);return n&&r}parts(t=this.localization.locale,e={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(t,e).formatToParts(this).filter((t=>"literal"!==t.type)).forEach((t=>s[t.type]=t.value)),s}get seconds(){return this.getSeconds()}set seconds(t){this.setSeconds(t)}get secondsFormatted(){return this.parts(void 0,a).second}get minutes(){return this.getMinutes()}set minutes(t){this.setMinutes(t)}get minutesFormatted(){return this.parts(void 0,a).minute}get hours(){return this.getHours()}set hours(t){this.setHours(t)}getHoursFormatted(t="h12"){return this.parts(void 0,{...a,hourCycle:t}).hour}meridiem(t=this.localization.locale){return new Intl.DateTimeFormat(t,{hour:"numeric",hour12:!0}).formatToParts(this).find((t=>"dayPeriod"===t.type))?.value}get date(){return this.getDate()}set date(t){this.setDate(t)}get dateFormatted(){return this.parts(void 0,a).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(t){const e=new Date(this.year,t+1);e.setDate(0);const s=e.getDate();this.date>s&&(this.date=s),this.setMonth(t)}get monthFormatted(){return this.parts(void 0,a).month}get year(){return this.getFullYear()}set year(t){this.setFullYear(t)}get week(){const t=this.computeOrdinal(),e=this.getUTCDay();let s=Math.floor((t-e+10)/7);return s<1?s=this.weeksInWeekYear():s>this.weeksInWeekYear()&&(s=1),s}weeksInWeekYear(){const t=(this.year+Math.floor(this.year/4)-Math.floor(this.year/100)+Math.floor(this.year/400))%7,e=this.year-1,s=(e+Math.floor(e/4)-Math.floor(e/100)+Math.floor(e/400))%7;return 4===t||3===s?53:52}dateToDataValue(){return d.isValid(this)?`${this.year}-${this.month.toString().padStart(2,"0")}-${this.date.toString().padStart(2,"0")}`:""}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}getAllMonths(t="long"){const e=new Intl.DateTimeFormat(this.localization.locale,{month:t}).format;return[...Array(12).keys()].map((t=>e(new Date(2021,t))))}replaceTokens(t,e){return t.replace(/(\[[^[\]]*])|(LTS?|l{1,4}|L{1,4})/g,((t,s,i)=>{const a=i&&i.toUpperCase();return s||e[a]||o.dateFormats[a]}))}parseTwoDigitYear(t){return t+(t>68?1900:2e3)}offsetFromString(t){if(!t)return 0;if("Z"===t)return 0;const[e,s,i]=t.match(/([+-]|\d\d)/g),o=60*+s+(+i||0);return 0===o?0:"+"===e?-o:o}zoneInformation(t,e){let s=t.parts(this.localization.locale,{timeZoneName:"longOffset"}).timeZoneName.replace("GMT","").replace(":","");const i=s.includes("-");return s=s.replace("-",""),"z"===e?s=s.substring(1,2):"zz"===e&&(s=s.substring(0,2)),`${i?"-":""}${s}`}addInput(t){return(e,s)=>{e[t]=+s}}getLocaleAfternoon(){return new Intl.DateTimeFormat(this.localization.locale,{hour:"numeric",hour12:!0}).formatToParts(new Date(2022,3,4,13)).find((t=>"dayPeriod"===t.type))?.value?.replace(/\s+/g," ")}meridiemMatch(t){return t.toLowerCase()===this.getLocaleAfternoon().toLowerCase()}correctHours(t){const{afternoon:e}=t;if(void 0!==e){const{hours:s}=t;e?s<12&&(t.hours+=12):12===s&&(t.hours=0),delete t.afternoon}}makeParser(t){const e=(t=this.replaceTokens(t,this.localization.dateFormats)).match(this.formattingTokens),{length:s}=e,i=[];for(let t=0;t<s;t+=1){const s=e[t],o=this.expressions[s];i[t]=o?.parser?o:s.replace(/^\[[^[\]]*]$/g,"")}return t=>{const e={hours:0,minutes:0,seconds:0,milliseconds:0};for(let o=0,a=0;o<s;o+=1){const s=i[o];if("string"==typeof s)a+=s.length;else{const i=t.slice(a);let o=i;if(s.pattern){o=s.pattern.exec(i)[0]}s.parser.call(this,e,o),t=t.replace(o,"")}}return this.correctHours(e),e}}static fromString(t,e){e?.format||s.errorMessages.customDateFormatError("No format was provided");try{const s=new d;if(s.setLocalization(e),["x","X"].indexOf(e.format)>-1)return new d(("X"===e.format?1e3:1)*+t);t=t.replace(/\s+/g," ");const i=s.makeParser(e.format),{year:o,month:a,day:n,hours:r,minutes:c,seconds:l,milliseconds:h,zone:p}=i(t),u=n||(o||a?1:s.getDate()),m=o||s.getFullYear();let y=0;return o&&!a||(y=a>0?a-1:s.getMonth()),p?new d(Date.UTC(m,y,u,r,c,l,h+60*p.offset*1e3)):new d(m,y,u,r,c,l,h)}catch(i){s.errorMessages.customDateFormatError(`Unable to parse provided input: ${t}, format: ${e.format}`)}}format(t,e=this.localization.locale){if(t&&"object"==typeof t)return new Intl.DateTimeFormat(e,t).format(this);const s=this.replaceTokens(t||this.localization.format||`${o.dateFormats.L}, ${o.dateFormats.LT}`,this.localization.dateFormats),i=t=>new Intl.DateTimeFormat(this.localization.locale,t).format(this);this.localization.hourCycle||(this.localization.hourCycle=r(this.localization.locale));const a=this.localization.hourCycle.startsWith("h1")?"h24":this.localization.hourCycle,n=this.localization.hourCycle.startsWith("h2")?"h12":this.localization.hourCycle,d={y:this.year,yy:i({year:"2-digit"}),yyyy:this.year,M:i({month:"numeric"}),MM:this.monthFormatted,MMM:this.getAllMonths("short")[this.getMonth()],MMMM:this.getAllMonths()[this.getMonth()],d:this.date,dd:this.dateFormatted,ddd:i({weekday:"short"}),dddd:i({weekday:"long"}),H:this.getHours(),HH:this.getHoursFormatted(a),h:this.hours>12?this.hours-12:this.hours,hh:this.getHoursFormatted(n),t:this.meridiem(),T:this.meridiem().toUpperCase(),m:this.minutes,mm:this.minutesFormatted,s:this.seconds,ss:this.secondsFormatted,fff:this.getMilliseconds()};return s.replace(this.dateTimeRegex,((t,e)=>e||d[t])).replace(/\[/g,"").replace(/]/g,"")}}class c{constructor(){this.cache=new Map}locate(t){const e=this.cache.get(t);if(e)return e;const s=new t;return this.cache.set(t,s),s}}let l;const h=[{name:"calendar",className:s.css.daysContainer,unit:i.month,step:1},{name:"months",className:s.css.monthsContainer,unit:i.year,step:1},{name:"years",className:s.css.yearsContainer,unit:i.year,step:10},{name:"decades",className:s.css.decadesContainer,unit:i.year,step:100}];class p{constructor(){this._currentCalendarViewMode=0,this._viewDate=new d,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(t){this._currentCalendarViewMode=t,this.currentView=h[t].name}get viewDate(){return this._viewDate}set viewDate(t){this._viewDate=t,this.options&&(this.options.viewDate=t)}refreshCurrentView(){this.currentView=h[this.currentCalendarViewMode].name}get isTwelveHour(){return["h12","h11"].includes(this.options.localization.hourCycle)}}class u{constructor(){this.optionsStore=l.locate(p)}isValid(t,e){if(!this._enabledDisabledDatesIsValid(e,t))return!1;if(e!==i.month&&e!==i.year&&this.optionsStore.options.restrictions.daysOfWeekDisabled?.length>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(t.weekDay))return!1;if(!this._minMaxIsValid(e,t))return!1;if(e===i.hours||e===i.minutes||e===i.seconds){if(!this._enabledDisabledHoursIsValid(t))return!1;if(0!==this.optionsStore.options.restrictions.disabledTimeIntervals?.filter((e=>t.isBetween(e.from,e.to))).length)return!1}return!0}_enabledDisabledDatesIsValid(t,e){return t!==i.date||!(this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(e))&&!(this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(e))}_isInDisabledDates(t){return!(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)&&!!this.optionsStore.options.restrictions.disabledDates.find((e=>e.isSame(t,i.date)))}_isInEnabledDates(t){return!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length||!!this.optionsStore.options.restrictions.enabledDates.find((e=>e.isSame(t,i.date)))}_minMaxIsValid(t,e){return(!this.optionsStore.options.restrictions.minDate||!e.isBefore(this.optionsStore.options.restrictions.minDate,t))&&(!this.optionsStore.options.restrictions.maxDate||!e.isAfter(this.optionsStore.options.restrictions.maxDate,t))}_enabledDisabledHoursIsValid(t){return!(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(t))&&!(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(t))}_isInDisabledHours(t){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const e=t.hours;return this.optionsStore.options.restrictions.disabledHours.includes(e)}_isInEnabledHours(t){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const e=t.hours;return this.optionsStore.options.restrictions.enabledHours.includes(e)}dateRangeIsValid(t,e,s){if(!this.optionsStore.options.dateRange)return!0;if(2!==t.length&&1!==e)return!0;const o=t[0].clone;if(o.isSame(s,i.date))return!0;for(o.manipulate(1,i.date);!o.isSame(s,i.date);){if(!this.isValid(o,i.date))return!1;o.manipulate(1,i.date)}return!0}}class m{constructor(){this.subscribers=[]}subscribe(t){return this.subscribers.push(t),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(t){this.subscribers.splice(t,1)}emit(t){this.subscribers.forEach((e=>{e(t)}))}destroy(){this.subscribers=null,this.subscribers=[]}}class y{constructor(){this.triggerEvent=new m,this.viewUpdate=new m,this.updateDisplay=new m,this.action=new m,this.updateViewDate=new m}destroy(){this.triggerEvent.destroy(),this.viewUpdate.destroy(),this.updateDisplay.destroy(),this.action.destroy(),this.updateViewDate.destroy()}}const g={clear:"Clear selection",close:"Close the picker",dateFormats:o.dateFormats,dayViewHeaderFormat:{month:"long",year:"2-digit"},decrementHour:"Decrement Hour",decrementMinute:"Decrement Minute",decrementSecond:"Decrement Second",format:o.format,hourCycle:o.hourCycle,incrementHour:"Increment Hour",incrementMinute:"Increment Minute",incrementSecond:"Increment Second",locale:o.locale,maxWeekdayLength:0,nextCentury:"Next Century",nextDecade:"Next Decade",nextMonth:"Next Month",nextYear:"Next Year",ordinal:o.ordinal,pickHour:"Pick Hour",pickMinute:"Pick Minute",pickSecond:"Pick Second",previousCentury:"Previous Century",previousDecade:"Previous Decade",previousMonth:"Previous Month",previousYear:"Previous Year",selectDate:"Select Date",selectDecade:"Select Decade",selectMonth:"Select Month",selectTime:"Select Time",selectYear:"Select Year",startOfTheWeek:0,today:"Go to today",toggleMeridiem:"Toggle Meridiem",toggleAriaLabel:"Change date"},v={allowInputToggle:!1,container:void 0,dateRange:!1,debug:!1,defaultDate:void 0,display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:void 0},inline:!1,theme:"auto",placement:"bottom",keyboardNavigation:!0},keepInvalid:!1,localization:g,meta:{},multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},stepping:1,useCurrent:!0,viewDate:new d},S={...g};function f(t,e){if(!t)return null;if(t.constructor.name===d.name)return t;if(t.constructor.name===Date.name)return d.convert(t);if("string"==typeof t){const s=d.fromString(t,e);return"null"===JSON.stringify(s)?null:s}return null}function w(t,e,i){"string"==typeof t&&"input"!==e&&s.errorMessages.dateString();const o=f(t,i);return o||s.errorMessages.failedToParseDate(e,t,"input"===e),o}function b(t,e,i,a=o){Array.isArray(e)||s.errorMessages.typeMismatch(t,i,"array of DateTime or Date");for(let s=0;s<e.length;s++){const i=w(e[s],t,a);i.setLocalization(a),e[s]=i}}function D(t,e,i){Array.isArray(e)&&!e.some((t=>"number"!=typeof t))||s.errorMessages.typeMismatch(t,i,"array of numbers")}function k(t){return({value:e,localization:s})=>{const i=w(e,t,s);if(void 0!==i)return i.setLocalization(s),i}}function _(t){const e=k(t);return t=>void 0===t.value?t.value:e(t)}function C(t,e,i){return({value:o,providedType:a})=>void 0===o?[]:(D(t,o,a),o.some((t=>t<e||t>i))&&s.errorMessages.numbersOutOfRange(t,e,i),o)}function E(t){return C(t,0,23)}function M(t){return({value:e,providedType:s,localization:i})=>void 0===e?[]:(b(t,e,s,i),e)}function L(t){return({value:e,path:i})=>(t.includes(e)||s.errorMessages.unexpectedOptionValue(i.substring(1),e,t),e)}const T=Object.freeze({defaultDate:k("defaultDate"),viewDate:k("viewDate"),minDate:_("restrictions.minDate"),maxDate:_("restrictions.maxDate"),disabledHours:E("restrictions.disabledHours"),enabledHours:E("restrictions.enabledHours"),disabledDates:M("restrictions.disabledDates"),enabledDates:M("restrictions.enabledDates"),daysOfWeekDisabled:C("restrictions.daysOfWeekDisabled",0,6),disabledTimeIntervals:({key:t,value:e,providedType:i,localization:o})=>{if(void 0===e)return[];Array.isArray(e)||s.errorMessages.typeMismatch(t,i,"array of { from: DateTime|Date, to: DateTime|Date }");const a=e;for(let e=0;e<a.length;e++)Object.keys(a[e]).forEach((s=>{const i=`${t}[${e}].${s}`,n=w(a[e][s],i,o);n.setLocalization(o),a[e][s]=n}));return a},toolbarPlacement:L(["top","bottom","default"]),type:L(["icons","sprites"]),viewMode:L(["clock","calendar","months","years","decades"]),theme:L(["light","dark","auto"]),placement:L(["top","bottom"]),meta:({value:t})=>t,dayViewHeaderFormat:({value:t})=>t,container:({value:t,path:e})=>(t&&!(t instanceof HTMLElement||t instanceof Element||t?.appendChild)&&s.errorMessages.typeMismatch(e.substring(1),typeof t,"HTMLElement"),t),useTwentyfourHour:({value:t,path:e,providedType:i,defaultType:o})=>{if(s.errorMessages.deprecatedWarning("useTwentyfourHour",'Please use "options.localization.hourCycle" instead'),void 0===t||"boolean"===i)return t;s.errorMessages.typeMismatch(e,i,o)},hourCycle:L(["h11","h12","h23","h24"])}),A=({value:t,defaultType:e,providedType:i,path:o})=>{switch(e){case"boolean":return"true"===t||!0===t;case"number":return+t;case"string":return t.toString();case"object":return{};case"function":return t;default:s.errorMessages.typeMismatch(o,i,e)}};class V{static deepCopy(t){const e={};return Object.keys(t).forEach((s=>{const i=t[s];i instanceof d?e[s]=i.clone:i instanceof Date?e[s]=new Date(i.valueOf()):(e[s]=i,"object"!=typeof i||i instanceof HTMLElement||i instanceof Element||Array.isArray(i)||(e[s]=V.deepCopy(i)))})),e}static objectPath(t,e){return"."===t.charAt(0)&&(t=t.slice(1)),t?t.split(".").reduce(((t,e)=>V.isValue(t)||V.isValue(t[e])?t[e]:void 0),e):e}static spread(t,e,i,o=""){const a=V.objectPath(o,v),n=Object.keys(t).filter((t=>!Object.keys(a).includes(t)));if(n.length>0){const t=V.getFlattenDefaultOptions(),e=n.map((e=>{let s=`"${o}.${e}" in not a known option.`;const i=t.find((t=>t.includes(e)));return i&&(s+=` Did you mean "${i}"?`),s}));s.errorMessages.unexpectedOptions(e)}Object.keys(t).filter((t=>"__proto__"!==t&&"constructor"!==t)).forEach((s=>{"."===(o+=`.${s}`).charAt(0)&&(o=o.slice(1));const n=a[s],r=typeof t[s],d=typeof n,c=t[s];if(null==c)return e[s]=c,void(o=o.substring(0,o.lastIndexOf(`.${s}`)));"object"!=typeof n||Array.isArray(t[s])||n instanceof Date||V.ignoreProperties.includes(s)?e[s]=V.processKey(s,c,r,d,o,i):V.spread(t[s],e[s],i,o),o=o.substring(0,o.lastIndexOf(`.${s}`))}))}static processKey(t,e,s,i,o,a){return(T[(n={key:t,value:e,providedType:s,defaultType:i,path:o,localization:a}).key]||A)(n);var n}static _mergeOptions(t,e){const s=V.deepCopy(e),i="default"!==e.localization?.locale?e.localization:t?.localization||v.localization;return V.spread(t,s,i,""),s}static _dataToOptions(t,e){const i=JSON.parse(JSON.stringify(t.dataset));if(i?.tdTargetInput&&delete i.tdTargetInput,i?.tdTargetToggle&&delete i.tdTargetToggle,!i||0===Object.keys(i).length)return e;const o={},a=t=>{const e={};return Object.keys(t).forEach((t=>{e[t.toLowerCase()]=t})),e},n=this.normalizeObject(a),r=a(e);return Object.keys(i).filter((t=>t.startsWith(s.dataKey))).map((t=>t.substring(2))).forEach((t=>{let s=r[t.toLowerCase()];if(t.includes("_")){const a=t.split("_");s=r[a[0].toLowerCase()],void 0!==s&&e[s].constructor===Object&&(o[s]=n(a,1,e[s],i[`td${t}`]))}else void 0!==s&&(o[s]=i[`td${t}`])})),this._mergeOptions(o,e)}static normalizeObject(t){const e=(s,i,o,a)=>{const n=t(o)[s[i].toLowerCase()],r={};return void 0===n||(o[n]?.constructor===Object?(i++,r[n]=e(s,i,o[n],a)):r[n]=a),r};return e}static _dateTypeCheck(t,e){return f(t,e)}static _typeCheckDateArray(t,e,s,i){return b(t,e,s,i)}static _typeCheckNumberArray(t,e,s){return D(t,e,s)}static dateConversion(t,e,s){return w(t,e,s)}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const t=(e,s=[])=>Array.isArray(e)?[]:Object(e)===e?Object.entries(e).flatMap((([e,i])=>t(i,[...s,e]))):s.join(".");return this._flattenDefaults=t(v),this._flattenDefaults}static _validateConflicts(t){!t.display.sideBySide||t.display.components.clock&&(t.display.components.hours||t.display.components.minutes||t.display.components.seconds)||s.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),t.restrictions.minDate&&t.restrictions.maxDate&&(t.restrictions.minDate.isAfter(t.restrictions.maxDate)&&s.errorMessages.conflictingConfiguration("minDate is after maxDate"),t.restrictions.maxDate.isBefore(t.restrictions.minDate)&&s.errorMessages.conflictingConfiguration("maxDate is before minDate")),t.multipleDates&&t.dateRange&&s.errorMessages.conflictingConfiguration('Cannot uss option "multipleDates" with "dateRange"')}}V.ignoreProperties=["meta","dayViewHeaderFormat","container","dateForms","ordinal"],V.isValue=t=>null!=t;class ${constructor(){this._dates=[],this.optionsStore=l.locate(p),this.validation=l.locate(u),this._eventEmitters=l.locate(y)}get picked(){return[...this._dates]}get lastPicked(){return this._dates[this.lastPickedIndex]?.clone}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(t){return t?(t.localization=this.optionsStore.options.localization,t.format()):""}parseInput(t){try{return V.dateConversion(t,"input",this.optionsStore.options.localization)}catch(e){return void this._eventEmitters.triggerEvent.emit({type:s.events.error,reason:s.errorMessages.failedToParseInput,format:this.optionsStore.options.localization.format,value:t})}}setFromInput(t,e){if(!t)return void this.setValue(void 0,e);const s=this.parseInput(t);s&&(s.setLocalization(this.optionsStore.options.localization),this.setValue(s,e))}add(t){this._dates.push(t)}isPicked(t,e){if(!d.isValid(t))return!1;if(!e)return void 0!==this._dates.find((e=>e.isSame(t)));const s=n(e),i=t.format(s);return void 0!==this._dates.map((t=>t.format(s))).find((t=>t===i))}pickedIndex(t,e){if(!d.isValid(t))return-1;if(!e)return this._dates.map((t=>t.valueOf())).indexOf(t.valueOf());const s=n(e),i=t.format(s);return this._dates.map((t=>t.format(s))).indexOf(i)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:s.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[],this.optionsStore.input&&(this.optionsStore.input.value=""),this._eventEmitters.updateDisplay.emit("all")}static getStartEndYear(t,e){const s=t/10,i=Math.floor(e/t)*t;return[i,i+9*s,Math.floor(e/s)*s]}updateInput(t){if(!this.optionsStore.input)return;let e=this.formatInput(t);(this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange)&&(e=this._dates.map((t=>this.formatInput(t))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=e&&(this.optionsStore.input.value=e)}setValue(t,e){const o=void 0===e,a=!t&&o;let n=this.optionsStore.unset?null:this._dates[e]?.clone;if(!n&&!this.optionsStore.unset&&o&&a&&(n=this.lastPicked),t&&n?.isSame(t))return void this.updateInput(t);if(!t)return void this._setValueNull(a,e,n);e=e||0,t=t.clone,1!==this.optionsStore.options.stepping&&(t.minutes=Math.round(t.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,t.startOf(i.minutes));const r=i=>{this._dates[e]=t,this._eventEmitters.updateViewDate.emit(t.clone),this.updateInput(t),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),this._eventEmitters.triggerEvent.emit({type:s.events.change,date:t,oldDate:n,isClear:a,isValid:i})};this.validation.isValid(t)&&this.validation.dateRangeIsValid(this.picked,e,t)?r(!0):(this.optionsStore.options.keepInvalid&&r(!1),this._eventEmitters.triggerEvent.emit({type:s.events.error,reason:s.errorMessages.failedToSetInvalidDate,date:t,oldDate:n}))}_setValueNull(t,e,i){!this.optionsStore.options.multipleDates||1===this._dates.length||t?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(e,1),this.updateInput(),this._eventEmitters.triggerEvent.emit({type:s.events.change,date:void 0,oldDate:i,isClear:t,isValid:!0}),this._eventEmitters.updateDisplay.emit("all")}}var x;!function(t){t.next="next",t.previous="previous",t.changeCalendarView="changeCalendarView",t.selectMonth="selectMonth",t.selectYear="selectYear",t.selectDecade="selectDecade",t.selectDay="selectDay",t.selectHour="selectHour",t.selectMinute="selectMinute",t.selectSecond="selectSecond",t.incrementHours="incrementHours",t.incrementMinutes="incrementMinutes",t.incrementSeconds="incrementSeconds",t.decrementHours="decrementHours",t.decrementMinutes="decrementMinutes",t.decrementSeconds="decrementSeconds",t.toggleMeridiem="toggleMeridiem",t.togglePicker="togglePicker",t.showClock="showClock",t.showHours="showHours",t.showMinutes="showMinutes",t.showSeconds="showSeconds",t.clear="clear",t.close="close",t.today="today"}(x||(x={}));var I=x;class z{constructor(){this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");if(t.classList.add(s.css.daysContainer),t.role="grid",t.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(s.css.calendarWeeks,s.css.noHighlight),t.appendChild(e)}const{rangeHoverEvent:e,rangeHoverOutEvent:i}=this.handleMouseEvents(t);for(let o=0;o<42;o++){if(0!==o&&o%7==0&&this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(s.css.calendarWeeks,s.css.noHighlight),e.tabIndex=-1,t.appendChild(e)}const a=document.createElement("div");a.setAttribute("data-action",I.selectDay),a.role="gridcell",a.tabIndex=-1,t.appendChild(a),matchMedia("(hover: hover)").matches&&this.optionsStore.options.dateRange&&(a.addEventListener("mouseover",e),a.addEventListener("mouseout",i))}return t}_update(t,e){const o=t.getElementsByClassName(s.css.daysContainer)[0];this._updateCalendarView(o);const a=this.optionsStore.viewDate.clone.startOf(i.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,i.hours);this._handleCalendarWeeks(o,a.clone),o.querySelectorAll(`[data-action="${I.selectDay}"]`).forEach((t=>{const o=[];o.push(s.css.day),a.isBefore(this.optionsStore.viewDate,i.month)&&o.push(s.css.old),a.isAfter(this.optionsStore.viewDate,i.month)&&o.push(s.css.new),this.optionsStore.unset||this.optionsStore.options.dateRange||!this.dates.isPicked(a,i.date)||o.push(s.css.active),this.validation.isValid(a,i.date)||o.push(s.css.disabled),a.isSame(new d,i.date)&&o.push(s.css.today),0!==a.weekDay&&6!==a.weekDay||o.push(s.css.weekend),this._handleDateRange(a,o),e(i.date,a,o,t),t.classList.remove(...t.classList),t.classList.add(...o),t.setAttribute("data-value",a.dateToDataValue()),t.setAttribute("data-day",`${a.date}`),t.innerText=a.parts(void 0,{day:"numeric"}).day,t.ariaLabel=a.format("MMMM dd, yyyy"),a.manipulate(1,i.date)}))}_handleDateRange(t,e){const o=this.dates.picked[0],a=this.dates.picked[1];this.optionsStore.options.dateRange&&(t.isBetween(o,a,i.date)&&e.push(s.css.rangeIn),t.isSame(o,i.date)&&e.push(s.css.rangeStart),t.isSame(a,i.date)&&e.push(s.css.rangeEnd))}handleMouseEvents(t){return{rangeHoverEvent:e=>{const o=e?.currentTarget;if(1!==this.dates.picked.length||o.classList.contains(s.css.disabled))return;const a=[...t.querySelectorAll(".day")],n=o.getAttribute("data-value"),r=d.fromString(n,{format:"yyyy-MM-dd"}),c=a.findIndex((t=>t.getAttribute("data-value")===n)),l=this.dates.picked[0],h=this.dates.picked[1],p=l.dateToDataValue(),u=a.findIndex((t=>t.getAttribute("data-value")===p)),m=a[u];let y;r.isSame(l,i.date)||o.classList.remove(s.css.rangeStart),r.isSame(h,i.date)||o.classList.remove(s.css.rangeEnd),r.isBefore(l)?(o.classList.add(s.css.rangeStart),m?.classList.remove(s.css.rangeStart),m?.classList.add(s.css.rangeEnd),y=(t,e)=>e>c&&e<u):(o.classList.add(s.css.rangeEnd),m?.classList.remove(s.css.rangeEnd),m?.classList.add(s.css.rangeStart),y=(t,e)=>e<c&&e>u),a.filter(y).forEach((t=>{t.classList.add(s.css.rangeIn)}))},rangeHoverOutEvent:e=>{const o=[...t.querySelectorAll(".day")];if(1===this.dates.picked.length&&o.forEach((t=>t.classList.remove(s.css.rangeIn))),1!==this.dates.picked.length)return;const a=e?.currentTarget,n=new d(a.getAttribute("data-value"));n.isSame(this.dates.picked[0],i.date)||a.classList.remove(s.css.rangeStart),n.isSame(this.dates.picked[1],i.date)||a.classList.remove(s.css.rangeEnd)}}}_updateCalendarView(t){if("calendar"!==this.optionsStore.currentView)return;const[e,o,a]=t.parentElement.getElementsByClassName(s.css.calendarHeader)[0].getElementsByTagName("div");o.setAttribute(s.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.optionsStore.options.display.components.month?o.classList.remove(s.css.disabled):o.classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,i.month),i.month)?e.classList.remove(s.css.disabled):e.classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,i.month),i.month)?a.classList.remove(s.css.disabled):a.classList.add(s.css.disabled)}_daysOfTheWeek(){const t=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(i.date),e=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(s.css.calendarWeeks,s.css.noHighlight),t.innerText="#",e.push(t)}for(let o=0;o<7;o++){const o=document.createElement("div");o.classList.add(s.css.dayOfTheWeek,s.css.noHighlight);let a=t.format({weekday:"short"});this.optionsStore.options.localization.maxWeekdayLength>0&&(a=a.substring(0,this.optionsStore.options.localization.maxWeekdayLength)),o.innerText=a,o.ariaLabel=t.format({weekday:"long"}),t.manipulate(1,i.date),e.push(o)}return e}_handleCalendarWeeks(t,e){[...t.querySelectorAll(`.${s.css.calendarWeeks}`)].filter((t=>"#"!==t.innerText)).forEach((t=>{t.innerText=`${e.week}`,e.manipulate(7,i.date)}))}}class O{constructor(){this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.monthsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.selectMonth),t.appendChild(e)}return t}_update(t,e){const o=t.getElementsByClassName(s.css.monthsContainer)[0];if("months"===this.optionsStore.currentView){const[t,e,a]=o.parentElement.getElementsByClassName(s.css.calendarHeader)[0].getElementsByTagName("div");e.setAttribute(s.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.optionsStore.options.display.components.year?e.classList.remove(s.css.disabled):e.classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,i.year),i.year)?t.classList.remove(s.css.disabled):t.classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,i.year),i.year)?a.classList.remove(s.css.disabled):a.classList.add(s.css.disabled)}const a=this.optionsStore.viewDate.clone.startOf(i.year);o.querySelectorAll(`[data-action="${I.selectMonth}"]`).forEach(((t,o)=>{const n=[];n.push(s.css.month),!this.optionsStore.unset&&this.dates.isPicked(a,i.month)&&n.push(s.css.active),this.validation.isValid(a,i.month)||n.push(s.css.disabled),e(i.month,a,n,t),t.classList.remove(...t.classList),t.classList.add(...n),t.setAttribute("data-value",`${o}`),t.innerText=`${a.format({month:"short"})}`,a.manipulate(1,i.month)}))}}class H{constructor(){this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.yearsContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.selectYear),t.appendChild(e)}return t}_update(t,e){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,i.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,i.year);const o=t.getElementsByClassName(s.css.yearsContainer)[0];if("years"===this.optionsStore.currentView){const[t,e,a]=o.parentElement.getElementsByClassName(s.css.calendarHeader)[0].getElementsByTagName("div");e.setAttribute(s.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.optionsStore.options.display.components.decades?e.classList.remove(s.css.disabled):e.classList.add(s.css.disabled),this.validation.isValid(this._startYear,i.year)?t.classList.remove(s.css.disabled):t.classList.add(s.css.disabled),this.validation.isValid(this._endYear,i.year)?a.classList.remove(s.css.disabled):a.classList.add(s.css.disabled)}const a=this.optionsStore.viewDate.clone.startOf(i.year).manipulate(-1,i.year);o.querySelectorAll(`[data-action="${I.selectYear}"]`).forEach((t=>{const o=[];o.push(s.css.year),!this.optionsStore.unset&&this.dates.isPicked(a,i.year)&&o.push(s.css.active),this.validation.isValid(a,i.year)||o.push(s.css.disabled),e(i.year,a,o,t),t.classList.remove(...t.classList),t.classList.add(...o),t.setAttribute("data-value",`${a.year}`),t.innerText=a.format({year:"numeric"}),a.manipulate(1,i.year)}))}}class P{constructor(){this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.decadesContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.selectDecade),t.appendChild(e)}return t}_update(t,e){const[o,a]=$.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(i.year),this._startDecade.year=o,this._endDecade=this.optionsStore.viewDate.clone.startOf(i.year),this._endDecade.year=a;const n=t.getElementsByClassName(s.css.decadesContainer)[0],[r,d,c]=n.parentElement.getElementsByClassName(s.css.calendarHeader)[0].getElementsByTagName("div"),l=this.validation.isValid(this._startDecade,i.year);"decades"===this.optionsStore.currentView&&(d.setAttribute(s.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),l?r.classList.remove(s.css.disabled):r.classList.add(s.css.disabled),this.validation.isValid(this._endDecade,i.year)?c.classList.remove(s.css.disabled):c.classList.add(s.css.disabled));const h=this.dates.picked.map((t=>t.year));n.querySelectorAll(`[data-action="${I.selectDecade}"]`).forEach(((t,o)=>{if(0===o)return t.classList.add(s.css.old),void(this._startDecade.year-10<0&&(t.textContent=" ",r.classList.add(s.css.disabled),t.classList.add(s.css.disabled),t.setAttribute("data-value","")));const a=[];a.push(s.css.decade);const n=this._startDecade.year,d=this._startDecade.year+9;!this.optionsStore.unset&&h.filter((t=>t>=n&&t<=d)).length>0&&a.push(s.css.active),l||this.validation.isValid(this._startDecade.clone.manipulate(10,i.year),i.year)||a.push(s.css.disabled),e("decade",this._startDecade,a,t),t.classList.remove(...t.classList),t.classList.add(...a),t.setAttribute("data-value",`${this._startDecade.year}`),t.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,i.year)}))}}class N{constructor(){this._gridColumns="",this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u)}getPicker(t){const e=document.createElement("div");return e.classList.add(s.css.clockContainer),e.append(...this._grid(t)),e}_update(t){const e=t.getElementsByClassName(s.css.clockContainer)[0];let o=this.dates.lastPicked?.clone;if(!o&&this.optionsStore.options.useCurrent&&(o=this.optionsStore.viewDate.clone),e.querySelectorAll(".disabled").forEach((t=>t.classList.remove(s.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,i.hours),i.hours)||e.querySelector(`[data-action=${I.incrementHours}]`).classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,i.hours),i.hours)||e.querySelector(`[data-action=${I.decrementHours}]`).classList.add(s.css.disabled),e.querySelector(`[data-time-component=${i.hours}]`).innerText=o?o.getHoursFormatted(this.optionsStore.options.localization.hourCycle):"--"),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,i.minutes),i.minutes)||e.querySelector(`[data-action=${I.incrementMinutes}]`).classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,i.minutes),i.minutes)||e.querySelector(`[data-action=${I.decrementMinutes}]`).classList.add(s.css.disabled),e.querySelector(`[data-time-component=${i.minutes}]`).innerText=o?o.minutesFormatted:"--"),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,i.seconds),i.seconds)||e.querySelector(`[data-action=${I.incrementSeconds}]`).classList.add(s.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,i.seconds),i.seconds)||e.querySelector(`[data-action=${I.decrementSeconds}]`).classList.add(s.css.disabled),e.querySelector(`[data-time-component=${i.seconds}]`).innerText=o?o.secondsFormatted:"--"),this.optionsStore.isTwelveHour){const t=e.querySelector(`[data-action=${I.toggleMeridiem}]`),a=(o||this.optionsStore.viewDate).clone;t.innerText=a.meridiem(),this.validation.isValid(a.manipulate(a.hours>=12?-12:12,i.hours))?t.classList.remove(s.css.disabled):t.classList.add(s.css.disabled)}e.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(t){this._gridColumns="";const e=[],o=[],a=[],n=document.createElement("div"),r=t(this.optionsStore.options.display.icons.up),d=t(this.optionsStore.options.display.icons.down);n.classList.add(s.css.separator,s.css.noHighlight);const c=n.cloneNode(!0);c.innerHTML=":";const l=(t=!1)=>t?c.cloneNode(!0):n.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let t=document.createElement("div");t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.incrementHour),t.setAttribute("data-action",I.incrementHours),t.appendChild(r.cloneNode(!0)),e.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.pickHour),t.setAttribute("data-action",I.showHours),t.setAttribute("data-time-component",i.hours),o.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.decrementHour),t.setAttribute("data-action",I.decrementHours),t.appendChild(d.cloneNode(!0)),a.push(t),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(e.push(l()),o.push(l(!0)),a.push(l()),this._gridColumns+=" a");let t=document.createElement("div");t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.incrementMinute),t.setAttribute("data-action",I.incrementMinutes),t.appendChild(r.cloneNode(!0)),e.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.pickMinute),t.setAttribute("data-action",I.showMinutes),t.setAttribute("data-time-component",i.minutes),o.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.decrementMinute),t.setAttribute("data-action",I.decrementMinutes),t.appendChild(d.cloneNode(!0)),a.push(t)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(e.push(l()),o.push(l(!0)),a.push(l()),this._gridColumns+=" a");let t=document.createElement("div");t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.incrementSecond),t.setAttribute("data-action",I.incrementSeconds),t.appendChild(r.cloneNode(!0)),e.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.pickSecond),t.setAttribute("data-action",I.showSeconds),t.setAttribute("data-time-component",i.seconds),o.push(t),t=document.createElement("div"),t.tabIndex=-1,t.setAttribute("title",this.optionsStore.options.localization.decrementSecond),t.setAttribute("data-action",I.decrementSeconds),t.appendChild(d.cloneNode(!0)),a.push(t)}if(this.optionsStore.isTwelveHour){this._gridColumns+=" a";let t=l();e.push(t);const i=document.createElement("button");i.tabIndex=-1,i.setAttribute("type","button"),i.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),i.setAttribute("data-action",I.toggleMeridiem),i.setAttribute("tabindex","-1"),s.css.toggleMeridiem.includes(",")?i.classList.add(...s.css.toggleMeridiem.split(",")):i.classList.add(s.css.toggleMeridiem),t=document.createElement("div"),t.classList.add(s.css.noHighlight),t.appendChild(i),o.push(t),t=l(),a.push(t)}return this._gridColumns=this._gridColumns.trim(),[...e,...o,...a]}}class F{constructor(){this.optionsStore=l.locate(p),this.validation=l.locate(u),this.dates=l.locate($)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.hourContainer);for(let e=0;e<(this.optionsStore.isTwelveHour?12:24);e++){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.selectHour),t.appendChild(e)}return t}_update(t,e){const o=t.getElementsByClassName(s.css.hourContainer)[0],a=this.optionsStore.viewDate.clone.startOf(i.date);o.querySelectorAll(`[data-action="${I.selectHour}"]`).forEach((t=>{const o=[];o.push(s.css.hour),this.validation.isValid(a,i.hours)||o.push(s.css.disabled),e(i.hours,a,o,t),t.classList.remove(...t.classList),t.classList.add(...o),t.setAttribute("data-value",`${a.hours}`),t.innerText=a.getHoursFormatted(this.optionsStore.options.localization.hourCycle),a.manipulate(1,i.hours)}))}}class B{constructor(){this.optionsStore=l.locate(p),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.minuteContainer);const e=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/e;s++){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.selectMinute),t.appendChild(e)}return t}_update(t,e){const o=t.getElementsByClassName(s.css.minuteContainer)[0],a=this.optionsStore.viewDate.clone.startOf(i.hours),n=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;o.querySelectorAll(`[data-action="${I.selectMinute}"]`).forEach((t=>{const o=[];o.push(s.css.minute),this.validation.isValid(a,i.minutes)||o.push(s.css.disabled),e(i.minutes,a,o,t),t.classList.remove(...t.classList),t.classList.add(...o),t.setAttribute("data-value",`${a.minutes}`),t.innerText=a.minutesFormatted,a.manipulate(n,i.minutes)}))}}class W{constructor(){this.optionsStore=l.locate(p),this.validation=l.locate(u)}getPicker(){const t=document.createElement("div");t.classList.add(s.css.secondContainer);for(let e=0;e<12;e++){const e=document.createElement("div");e.setAttribute("data-action",I.selectSecond),e.tabIndex=-1,t.appendChild(e)}return t}_update(t,e){const o=t.getElementsByClassName(s.css.secondContainer)[0],a=this.optionsStore.viewDate.clone.startOf(i.minutes);o.querySelectorAll(`[data-action="${I.selectSecond}"]`).forEach((t=>{const o=[];o.push(s.css.second),this.validation.isValid(a,i.seconds)||o.push(s.css.disabled),e(i.seconds,a,o,t),t.classList.remove(...t.classList),t.classList.add(...o),t.setAttribute("data-value",`${a.seconds}`),t.innerText=a.secondsFormatted,a.manipulate(5,i.seconds)}))}}class q{static toggle(t){t.classList.contains(s.css.show)?this.hide(t):this.show(t)}static showImmediately(t){t.classList.remove(s.css.collapsing),t.classList.add(s.css.collapse,s.css.show),t.style.height=""}static show(t){if(t.classList.contains(s.css.collapsing)||t.classList.contains(s.css.show))return;t.style.height="0",t.classList.remove(s.css.collapse),t.classList.add(s.css.collapsing),setTimeout((()=>{q.showImmediately(t)}),this.getTransitionDurationFromElement(t)),t.style.height=`${t.scrollHeight}px`}static hideImmediately(t){t&&(t.classList.remove(s.css.collapsing,s.css.show),t.classList.add(s.css.collapse))}static hide(t){if(t.classList.contains(s.css.collapsing)||!t.classList.contains(s.css.show))return;t.style.height=`${t.getBoundingClientRect().height}px`;t.offsetHeight,t.classList.remove(s.css.collapse,s.css.show),t.classList.add(s.css.collapsing),t.style.height="",setTimeout((()=>{q.hideImmediately(t)}),this.getTransitionDurationFromElement(t))}}q.getTransitionDurationFromElement=t=>{if(!t)return 0;let{transitionDuration:e,transitionDelay:s}=window.getComputedStyle(t);const i=Number.parseFloat(e),o=Number.parseFloat(s);return i||o?(e=e.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(e)+Number.parseFloat(s))):0};class Y{constructor(){this._isVisible=!1,this._keyboardEventBound=this._keyboardEvent.bind(this),this._documentClickEvent=t=>{this.optionsStore.options.debug||window.debug||!this._isVisible||t.composedPath().includes(this.widget)||t.composedPath()?.includes(this.optionsStore.element)||this.hide()},this._actionsClickEvent=t=>{this._eventEmitters.action.emit({e:t})},this.optionsStore=l.locate(p),this.validation=l.locate(u),this.dates=l.locate($),this.dateDisplay=l.locate(z),this.monthDisplay=l.locate(O),this.yearDisplay=l.locate(H),this.decadeDisplay=l.locate(P),this.timeDisplay=l.locate(N),this.hourDisplay=l.locate(F),this.minuteDisplay=l.locate(B),this.secondDisplay=l.locate(W),this._eventEmitters=l.locate(y),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((t=>{this._update(t)}))}get widget(){return this._widget}get dateContainer(){return this.widget?.querySelector(`div.${s.css.dateContainer}`)}get timeContainer(){return this.widget?.querySelector(`div.${s.css.timeContainer}`)}get isVisible(){return this._isVisible}_update(t){if(this.widget)switch(t){case i.seconds:this.secondDisplay._update(this.widget,this.paint);break;case i.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case i.hours:this.hourDisplay._update(this.widget,this.paint);break;case i.date:this.dateDisplay._update(this.widget,this.paint);break;case i.month:this.monthDisplay._update(this.widget,this.paint);break;case i.year:this.yearDisplay._update(this.widget,this.paint);break;case"decade":this.decadeDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(i.hours),this._update(i.minutes),this._update(i.seconds);break;case"calendar":this._update(i.date),this._update(i.year),this._update(i.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(t,e,s,i){}show(){if(null==this.widget){if(this._showSetDefaultIfNeeded(),this._buildWidget(),this._updateTheme(),this._showSetupViewMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{const t=this.optionsStore.options?.container||document.body,e=this.optionsStore.options?.display?.placement||"bottom";t.appendChild(this.widget),this.createPopup(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?`${e}-end`:`${e}-start`}).then((()=>{this._handleFocus()}))}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:I.showClock}),this.widget.querySelectorAll("[data-action]").forEach((t=>t.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(s.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(s.css.show),this.optionsStore.options.display.inline||(this.updatePopup(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:s.events.show}),this._isVisible=!0,this.optionsStore.options.display.keyboardNavigation&&this.widget.addEventListener("keydown",this._keyboardEventBound)}_showSetupViewMode(){const t=this._hasTime&&!this._hasDate;t?(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:I.showClock})):this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),t||"clock"===this.optionsStore.options.display.viewMode||(this._hasTime&&(this.optionsStore.options.display.sideBySide?q.show(this.timeContainer):q.hideImmediately(this.timeContainer)),q.show(this.dateContainer)),this._hasDate&&this._showMode()}_showSetDefaultIfNeeded(){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const t=(new d).setLocalization(this.optionsStore.options.localization);if(!this.optionsStore.options.keepInvalid){let e=0,s=1;for(this.optionsStore.options.restrictions.maxDate?.isBefore(t)&&(s=-1);!this.validation.isValid(t)&&e>31;)t.manipulate(s,i.date),e++}this.dates.setValue(t)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}}async createPopup(t,e,s){let i;if(window?.Popper)i=window?.Popper?.createPopper;else{const{createPopper:t}=await import("@popperjs/core");i=t}i&&(this._popperInstance=i(t,e,s))}updatePopup(){this._popperInstance&&(this._popperInstance.update(),this._handleFocus())}_showMode(t){if(!this.widget)return;if(t){const e=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+t));if(this.optionsStore.currentCalendarViewMode==e)return;this.optionsStore.currentCalendarViewMode=e}this.widget.querySelectorAll(`.${s.css.dateContainer} > div:not(.${s.css.calendarHeader}), .${s.css.timeContainer} > div:not(.${s.css.clockContainer})`).forEach((t=>t.style.display="none"));const e=h[this.optionsStore.currentCalendarViewMode],i=this.widget.querySelector(`.${e.className}`);switch(e.className){case s.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case s.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case s.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case s.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}i.style.display="grid",this.optionsStore.options.display.sideBySide&&(this.widget.querySelectorAll(`.${s.css.clockContainer}`)[0].style.display="grid"),this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit(),this.findViewDateElement()?.focus()}_updateTheme(t){if(this.widget){if(t){if(this.optionsStore.options.display.theme===t)return;this.optionsStore.options.display.theme=t}this.widget.classList.remove("light","dark"),this.widget.classList.add(this._getThemeClass()),"auto"===this.optionsStore.options.display.theme?window.matchMedia(s.css.isDarkPreferredQuery).addEventListener("change",(()=>this._updateTheme())):window.matchMedia(s.css.isDarkPreferredQuery).removeEventListener("change",(()=>this._updateTheme()))}}_getThemeClass(){const t=this.optionsStore.options.display.theme||"auto",e=window.matchMedia&&window.matchMedia(s.css.isDarkPreferredQuery).matches;switch(t){case"light":return s.css.lightTheme;case"dark":return s.css.darkTheme;case"auto":return e?s.css.darkTheme:s.css.lightTheme}}_updateCalendarHeader(){if(!this._hasDate)return;const t=[...this.widget.querySelector(`.${s.css.dateContainer} div[style*="display: grid"]`).classList].find((t=>t.startsWith(s.css.dateContainer))),[e,i,o]=this.widget.getElementsByClassName(s.css.calendarHeader)[0].getElementsByTagName("div");switch(t){case s.css.decadesContainer:e.setAttribute("title",this.optionsStore.options.localization.previousCentury),i.setAttribute("title",""),o.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case s.css.yearsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousDecade),i.setAttribute("title",this.optionsStore.options.localization.selectDecade),o.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case s.css.monthsContainer:e.setAttribute("title",this.optionsStore.options.localization.previousYear),i.setAttribute("title",this.optionsStore.options.localization.selectYear),o.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case s.css.daysContainer:e.setAttribute("title",this.optionsStore.options.localization.previousMonth),i.setAttribute("title",this.optionsStore.options.localization.selectMonth),o.setAttribute("title",this.optionsStore.options.localization.nextMonth),i.setAttribute(t,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat))}i.innerText=i.getAttribute(t)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(s.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:s.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?.clone}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent),this.optionsStore.options.display.keyboardNavigation&&this.widget.removeEventListener("keydown",this._keyboardEventBound),this.optionsStore.toggle.focus())}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((t=>t.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const t=document.createElement("div");t.tabIndex=-1,t.classList.add(s.css.widget),t.setAttribute("role","widget");const e=document.createElement("div");e.tabIndex=-1,e.classList.add(s.css.dateContainer),e.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const i=document.createElement("div");i.tabIndex=-1,i.classList.add(s.css.timeContainer),i.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),i.appendChild(this.hourDisplay.getPicker()),i.appendChild(this.minuteDisplay.getPicker()),i.appendChild(this.secondDisplay.getPicker());const o=document.createElement("div");if(o.tabIndex=-1,o.classList.add(s.css.toolbar),o.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&t.classList.add(s.css.inline),this.optionsStore.options.display.calendarWeeks&&t.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDateAndTime)return void this._buildWidgetSideBySide(t,e,i,o);"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(o);const a=(e,i,o,a)=>{e&&(i&&(o.classList.add(s.css.collapse),a&&o.classList.add(s.css.show)),t.appendChild(o))};a(this._hasDate,this._hasTime,e,"clock"!==this.optionsStore.options.display.viewMode),a(this._hasTime,this._hasDate,i,"clock"===this.optionsStore.options.display.viewMode),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(o);const n=document.createElement("div");n.classList.add("arrow"),n.setAttribute("data-popper-arrow",""),t.appendChild(n),this._widget=t}_buildWidgetSideBySide(t,e,i,o){t.classList.add(s.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(o);const a=document.createElement("div");a.classList.add("td-row"),e.classList.add("td-half"),i.classList.add("td-half"),a.appendChild(e),a.appendChild(i),t.appendChild(a),"bottom"===this.optionsStore.options.display.toolbarPlacement&&t.appendChild(o),this._widget=t}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}get _hasDateAndTime(){return this._hasDate&&this._hasTime}getToolbarElements(){const t=[];if(this.optionsStore.options.display.buttons.today){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.today),e.setAttribute("title",this.optionsStore.options.localization.today),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),t.push(e)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let e,s;"clock"===this.optionsStore.options.display.viewMode?(e=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(e=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.tabIndex=-1,i.setAttribute("data-action",I.togglePicker),i.setAttribute("title",e),i.appendChild(this._iconTag(s)),t.push(i)}if(this.optionsStore.options.display.buttons.clear){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.clear),e.setAttribute("title",this.optionsStore.options.localization.clear),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),t.push(e)}if(this.optionsStore.options.display.buttons.close){const e=document.createElement("div");e.tabIndex=-1,e.setAttribute("data-action",I.close),e.setAttribute("title",this.optionsStore.options.localization.close),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),t.push(e)}return t}getHeadTemplate(){const t=document.createElement("div");t.classList.add(s.css.calendarHeader);const e=document.createElement("div");e.classList.add(s.css.previous),e.setAttribute("data-action",I.previous),e.appendChild(this._iconTag(this.optionsStore.options.display.icons.previous)),e.tabIndex=-1;const i=document.createElement("div");i.classList.add(s.css.switch),i.setAttribute("data-action",I.changeCalendarView),i.tabIndex=-1;const o=document.createElement("div");return o.classList.add(s.css.next),o.setAttribute("data-action",I.next),o.appendChild(this._iconTag(this.optionsStore.options.display.icons.next)),o.tabIndex=-1,t.append(e,i,o),t}_iconTag(t){if("sprites"===this.optionsStore.options.display.icons.type){const e=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",t),s.setAttribute("href",t),e.appendChild(s),e}const e=document.createElement("i");return e.classList.add(...t.split(" ")),e}_rebuild(){const t=this._isVisible;this._dispose(),t&&this.show()}refreshCurrentView(){switch(this._isVisible||this._dispose(),this.optionsStore.currentView){case"clock":this._update("clock");break;case"calendar":this._update(i.date);break;case"months":this._update(i.month);break;case"years":this._update(i.year);break;case"decades":this._update("decade")}}_keyboardEvent(t){if("clock"!==this.optionsStore.currentView)return this._handleKeyDownDate(t),!1;this._handleKeyDownClock(t)}findViewDateElement(){let t="",e="";switch(this.optionsStore.currentView){case"clock":break;case"calendar":t=s.css.daysContainer,e=this.optionsStore.viewDate.dateToDataValue();break;case"months":t=s.css.monthsContainer,e=this.optionsStore.viewDate.month.toString();break;case"years":t=s.css.yearsContainer,e=this.optionsStore.viewDate.year.toString();break;case"decades":t=s.css.decadesContainer,e=(10*Math.floor(this.optionsStore.viewDate.year/10)).toString()}return this.widget.querySelector(`.${t} > div[data-value="${e}"]`)}_handleKeyDownDate(t){let e=!1;const s=document.activeElement;let o=null,a=7,n=1,r=1;const d=this.optionsStore.currentView;switch(d){case"calendar":o=i.date;break;case"months":o=i.month,a=3,n=1;break;case"years":o=i.year,a=3,n=1;break;case"decades":o=i.year,a=30,n=10}switch(t.key){case"Esc":case"Escape":this._eventEmitters.action.emit({e:null,action:I.close});break;case" ":case"Enter":return s.click(),t.stopPropagation(),void t.preventDefault();case"Tab":return void this._handleTab(s,t);case"Right":case"ArrowRight":r=n,e=!0;break;case"Left":case"ArrowLeft":e=!0,r=-n;break;case"Down":case"ArrowDown":e=!0,r=a;break;case"Up":case"ArrowUp":e=!0,r=-a;break;case"PageDown":switch(d){case"calendar":o=t.shiftKey?i.year:i.month,r=1;break;case"months":o=i.year,r=t.shiftKey?10:1;break;case"years":case"decades":o=i.year,r=t.shiftKey?100:10}e=!0;break;case"PageUp":switch(d){case"calendar":o=t.shiftKey?i.year:i.month,r=-1;break;case"months":o=i.year,r=-(t.shiftKey?10:1);break;case"years":case"decades":o=i.year,r=-(t.shiftKey?100:10)}e=!0;break;case"Home":this.optionsStore.viewDate=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek),e=!0,o=null;break;case"End":this.optionsStore.viewDate=this.optionsStore.viewDate.clone.endOf("weekDay",this.optionsStore.options.localization.startOfTheWeek),e=!0,o=null}if(!e)return;let c=this.optionsStore.viewDate;o&&(c=c.clone.manipulate(r,o)),this._eventEmitters.updateViewDate.emit(c);const l=this.findViewDateElement();l&&l.focus(),t.stopPropagation(),t.preventDefault()}_handleKeyDownClock(t){let e=!1;const i=document.activeElement,o=this.widget.querySelector(`.${s.css.timeContainer} > div[style*="display: grid"]`);let a=s.css.clockContainer;switch(o.classList.contains(s.css.hourContainer)&&(a=s.css.hourContainer),o.classList.contains(s.css.minuteContainer)&&(a=s.css.minuteContainer),o.classList.contains(s.css.secondContainer)&&(a=s.css.secondContainer),t.key){case"Esc":case"Escape":this._eventEmitters.action.emit({e:null,action:I.close});break;case" ":case"Enter":return i.click(),t.stopPropagation(),void t.preventDefault();case"Tab":return void this._handleTab(i,t)}if(a===s.css.clockContainer)return;const n=[...o.querySelectorAll("div")],r=n.indexOf(document.activeElement);let d;switch(t.key){case"Right":case"ArrowRight":d=r<n.length-1?r+1:null,e=!0;break;case"Left":case"ArrowLeft":e=!0,d=r>0?r-1:null;break;case"Down":case"ArrowDown":d=r+4<n.length?r+4:null,e=!0;break;case"Up":case"ArrowUp":d=r-4>=0?r-4:null,e=!0}e&&(null!=d&&n[d].focus(),t.stopPropagation(),t.preventDefault())}_handleTab(t,e){const i=e.shiftKey,o=()=>{const t=this.widget.querySelectorAll(`.${s.css.calendarHeader} > div`);a.push(...t)},a=[];switch(this.optionsStore.currentView){case"clock":{a.push(...this.widget.querySelectorAll(`.${s.css.timeContainer} > div[style*="display: grid"] > div[data-action]`));const t=this.widget.querySelectorAll(`.${s.css.clockContainer}`)[0];"grid"===t?.style.display&&a.push(...this.widget.querySelectorAll(`.${s.css.toggleMeridiem}`))}break;case"calendar":case"months":case"years":case"decades":o(),a.push(this.findViewDateElement())}const n=this.widget.querySelectorAll(`.${s.css.toolbar} > div`);a.push(...n);const r=a.indexOf(t);-1!==r&&(i?0===r?a[a.length-1].focus():a[r-1].focus():r===a.length-1?a[0].focus():a[r+1].focus(),e.stopPropagation(),e.preventDefault())}_handleFocus(){"clock"===this.optionsStore.currentView?this._handleFocusClock():this.findViewDateElement().focus()}_handleFocusClock(){this.widget.querySelector(`.${s.css.timeContainer} > div[style*="display: grid"]`).children[0].focus()}}class U{constructor(){this.optionsStore=l.locate(p),this.dates=l.locate($),this.validation=l.locate(u),this.display=l.locate(Y),this._eventEmitters=l.locate(y),this._eventEmitters.action.subscribe((t=>{this.do(t.e,t.action)}))}do(t,e){const o=t?.currentTarget;if(o?.classList?.contains(s.css.disabled))return;e=e||o?.dataset?.action;const a=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(e){case I.next:case I.previous:this.handleNextPrevious(e);break;case I.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case I.selectMonth:case I.selectYear:case I.selectDecade:this.handleSelectCalendarMode(e,o);break;case I.selectDay:this.handleSelectDay(o);break;case I.selectHour:{let e=+o.dataset.value;a.hours>=12&&this.optionsStore.isTwelveHour&&(e+=12),a.hours=e,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(t);break}case I.selectMinute:a.minutes=+o.dataset.value,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(t);break;case I.selectSecond:a.seconds=+o.dataset.value,this.dates.setValue(a,this.dates.lastPickedIndex),this.hideOrClock(t);break;case I.incrementHours:this.manipulateAndSet(a,i.hours);break;case I.incrementMinutes:this.manipulateAndSet(a,i.minutes,this.optionsStore.options.stepping);break;case I.incrementSeconds:this.manipulateAndSet(a,i.seconds);break;case I.decrementHours:this.manipulateAndSet(a,i.hours,-1);break;case I.decrementMinutes:this.manipulateAndSet(a,i.minutes,-1*this.optionsStore.options.stepping);break;case I.decrementSeconds:this.manipulateAndSet(a,i.seconds,-1);break;case I.toggleMeridiem:this.manipulateAndSet(a,i.hours,this.dates.lastPicked.hours>=12?-12:12);break;case I.togglePicker:this.handleToggle(o);break;case I.showClock:case I.showHours:case I.showMinutes:case I.showSeconds:this.optionsStore.options.display.sideBySide||"clock"===this.optionsStore.currentView||(q.hideImmediately(this.display.dateContainer),q.showImmediately(this.display.timeContainer)),this.handleShowClockContainers(e);break;case I.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case I.close:this.display.hide();break;case I.today:{const t=(new d).setLocalization(this.optionsStore.options.localization);if(this._eventEmitters.updateViewDate.emit(t),!this.validation.isValid(t,i.date))break;this.optionsStore.options.dateRange?this.handleDateRange(t):this.optionsStore.options.multipleDates?this.handleMultiDate(t):this.dates.setValue(t,this.dates.lastPickedIndex);break}}}handleShowClockContainers(t){if(!this.display._hasTime)return void s.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${s.css.timeContainer} > div`).forEach((t=>t.style.display="none"));let e="";switch(t){case I.showClock:e=s.css.clockContainer,this.display._update("clock");break;case I.showHours:e=s.css.hourContainer,this.display._update(i.hours);break;case I.showMinutes:e=s.css.minuteContainer,this.display._update(i.minutes);break;case I.showSeconds:e=s.css.secondContainer,this.display._update(i.seconds)}const o=this.display.widget.getElementsByClassName(e)[0];o.style.display="grid",o.children[0]?.focus()}handleNextPrevious(t){const{unit:e,step:s}=h[this.optionsStore.currentCalendarViewMode];t===I.next?this.optionsStore.viewDate.manipulate(s,e):this.optionsStore.viewDate.manipulate(-1*s,e),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(t){this.optionsStore.isTwelveHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(t,I.showClock):this.display.hide()}manipulateAndSet(t,e,s=1){const i=t.manipulate(s,e);this.validation.isValid(i,e)&&this.dates.setValue(i,this.dates.lastPickedIndex)}handleSelectCalendarMode(t,e){const s=+e.dataset.value;switch(t){case I.selectMonth:this.optionsStore.viewDate.month=s;break;case I.selectYear:case I.selectDecade:this.optionsStore.viewDate.year=s}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1)}handleToggle(t){t.getAttribute("title")===this.optionsStore.options.localization.selectDate?(t.setAttribute("title",this.optionsStore.options.localization.selectTime),t.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(t.setAttribute("title",this.optionsStore.options.localization.selectDate),t.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.handleShowClockContainers(I.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${s.css.dateContainer}, .${s.css.timeContainer}`).forEach((t=>q.toggle(t))),this._eventEmitters.viewUpdate.emit();const e=this.display.widget.querySelector(`.${s.css.collapsing} > div[style*="display: grid"]`);e?.focus()}handleSelectDay(t){const e=this.optionsStore.viewDate.clone;t.classList.contains(s.css.old)&&e.manipulate(-1,i.month),t.classList.contains(s.css.new)&&e.manipulate(1,i.month),e.date=+t.dataset.day,this.optionsStore.options.dateRange?this.handleDateRange(e):this.optionsStore.options.multipleDates?this.handleMultiDate(e):this.dates.setValue(e,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange||this.display.hide()}handleMultiDate(t){let e=this.dates.pickedIndex(t,i.date);-1!==e?this.dates.setValue(null,e):(e=this.dates.lastPickedIndex+1,0===this.dates.picked.length&&(e=0),this.dates.setValue(t,e))}handleDateRange(t){switch(this.dates.picked.length){case 2:this.dates.clear();break;case 1:{const e=this.dates.picked[0];if(t.getTime()===e.getTime()){this.dates.clear();break}return t.isBefore(e)?(this.dates.setValue(t,0),void this.dates.setValue(e,1)):void this.dates.setValue(t,1)}}this.dates.setValue(t,0)}}class j{constructor(t,e={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=t=>{const e=t?.detail;if(e)return;const s=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked.clone)},i=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange)try{const t=i.split(this.optionsStore.options.multipleDatesSeparator);for(let e=0;e<t.length;e++)this.dates.setFromInput(t[e],e);s()}catch{console.warn("TD: Something went wrong trying to set the multipleDates values from the input field.")}else this.dates.setFromInput(i,0),s()},this._toggleClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||"INPUT"===this.optionsStore.toggle.nodeName&&"text"===this.optionsStore.toggle?.type&&this.optionsStore.options.allowInputToggle||this.toggle()},this._openClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||this.display.isVisible||this.show()},l=new c,this._eventEmitters=l.locate(y),this.optionsStore=l.locate(p),this.display=l.locate(Y),this.dates=l.locate($),this.actions=l.locate(U),t||s.errorMessages.mustProvideElement(),this.optionsStore.element=t,this._initializeOptions(e,v,!0),this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((t=>{this._triggerEvent(t)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()})),this._eventEmitters.updateViewDate.subscribe((t=>{this.viewDate=t}))}get viewDate(){return this.optionsStore.viewDate}set viewDate(t){this.optionsStore.viewDate=t,this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.display._update("clock"===this.optionsStore.currentView?"clock":"calendar")}updateOptions(t,e=!1){e?this._initializeOptions(t,v):this._initializeOptions(t,this.optionsStore.options),this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.display.refreshCurrentView()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){this._isDisabled=!0,this.optionsStore.input?.setAttribute("disabled","disabled"),this.display.hide()}enable(){this._isDisabled=!1,this.optionsStore.input?.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(t,e){let i;"string"==typeof t&&(t=[t]),i=Array.isArray(e)?e:[e],t.length!==i.length&&s.errorMessages.subscribeMismatch();const o=[];for(let e=0;e<t.length;e++){const s=t[e];if(Array.isArray(this._subscribers[s])||(this._subscribers[s]=[]),this._subscribers[s].push(i[e]),o.push({unsubscribe:this._unsubscribe.bind(this,s,this._subscribers[s].length-1)}),1===t.length)return o[0]}return o}dispose(){this.display.hide(),this.display._dispose(),this._eventEmitters.destroy(),this.optionsStore.input?.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(this.optionsStore.input?.removeEventListener("click",this._openClickEvent),this.optionsStore.input?.removeEventListener("focus",this._openClickEvent)),this.optionsStore.toggle?.removeEventListener("click",this._toggleClickEvent),this.optionsStore.toggle?.removeEventListener("keydown",this._handleToggleKeydown),this._subscribers={}}locale(t){const e=R[t];e&&this.updateOptions({localization:e})}_triggerEvent(t){t.viewMode=this.optionsStore.currentView;const e=t.type===s.events.change;if(e){const{date:e,oldDate:s,isClear:i}=t;if(e&&s&&e.isSame(s)||!i&&!e&&!s)return;if(this._handleAfterChangeEvent(t),this.optionsStore.input?.dispatchEvent(new CustomEvent("change",{detail:t})),this.optionsStore.toggle){let t=this.optionsStore.options.localization.toggleAriaLabel;if(this.dates.picked.length>0){t=`${t}, ${this.dates.picked.map((t=>t.format())).join(", ")}`}this.optionsStore.toggle.ariaLabel=t}}if(this.optionsStore.element.dispatchEvent(new CustomEvent(t.type,{detail:t})),window.jQuery){const s=window.jQuery;e&&this.optionsStore.input?s(this.optionsStore.input).trigger(t):s(this.optionsStore.element).trigger(t)}this._publish(t)}_publish(t){Array.isArray(this._subscribers[t.type])&&this._subscribers[t.type].forEach((e=>{e(t)}))}_viewUpdate(){this._triggerEvent({type:s.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(t,e){this._subscribers[t].splice(e,1)}_initializeOptions(t,e,s=!1){let i=V.deepCopy(t);i=V._mergeOptions(i,e),s&&(i=V._dataToOptions(this.optionsStore.element,i)),V._validateConflicts(i),i.viewDate=i.viewDate.setLocalization(i.localization),this.optionsStore.viewDate.isSame(i.viewDate)||(this.optionsStore.viewDate=i.viewDate),i.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),i.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),i.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),h[this.optionsStore.currentCalendarViewMode].name!==i.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(h.findIndex((t=>t.name===i.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),this.display?.isVisible&&this.display._update("all"),i.display.components.useTwentyfourHour&&void 0===i.localization.hourCycle?i.localization.hourCycle="h24":void 0===i.localization.hourCycle&&(i.localization.hourCycle=r(i.localization.locale)),this.optionsStore.options=i,i.restrictions.maxDate&&this.viewDate.isAfter(i.restrictions.maxDate)&&(this.viewDate=i.restrictions.maxDate.clone),i.restrictions.minDate&&this.viewDate.isBefore(i.restrictions.minDate)&&(this.viewDate=i.restrictions.minDate.clone)}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{const t=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==t||"nearest"==t?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(t)}this.optionsStore.input&&(!this.optionsStore.input.value&&this.optionsStore.options.defaultDate&&(this.optionsStore.input.value=this.dates.formatInput(this.optionsStore.options.defaultDate)),this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(this.optionsStore.input.addEventListener("click",this._openClickEvent),this.optionsStore.input.addEventListener("focus",this._openClickEvent)),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let t=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==t&&(t='[data-td-toggle="datetimepicker"]'),this.optionsStore.toggle=null==t?this.optionsStore.element:this.optionsStore.element.querySelector(t),null!=this.optionsStore.toggle&&(this.optionsStore.toggle.addEventListener("click",this._toggleClickEvent),this.optionsStore.toggle!==this.optionsStore.element&&this.optionsStore.toggle.addEventListener("keydown",this._handleToggleKeydown.bind(this)))}_handleAfterChangeEvent(t){!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.multipleDates||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||this.display.widget?.getElementsByClassName(s.css.show)[0].classList.contains(s.css.timeContainer)||!t.oldDate&&this.optionsStore.options.useCurrent||t.oldDate&&t.date?.isSame(t.oldDate)||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector('[data-action="togglePicker"]')},action:I.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}_handleToggleKeydown(t){" "!==t.key&&"Enter"!==t.key||(this.optionsStore.toggle.click(),t.stopPropagation(),t.preventDefault())}}const R={},K=t=>{R[t.name]||(R[t.name]=t.localization)},Q=t=>{const e=R[t];e&&(v.localization=e)},J=function(t,e=undefined){return t?(t.installed||(t(e,{TempusDominus:j,Dates:$,Display:Y,DateTime:d,Namespace:s},G),t.installed=!0),G):G},Z="6.9.4",G={TempusDominus:j,extend:J,loadLocale:K,locale:Q,Namespace:s,DefaultOptions:v,DateTime:d,Unit:i,version:Z,DefaultEnLocalization:S};export{d as DateTime,S as DefaultEnLocalization,v as DefaultOptions,s as Namespace,j as TempusDominus,i as Unit,J as extend,K as loadLocale,Q as locale,Z as version};
