(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["ePub"] = factory();
	else
		root["ePub"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/examples/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 181);
/******/ })
/************************************************************************/
/******/ ({

/***/ 181:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var CACHES = {
  resources: 'epubjs-resources'
};
var DEV = false;

self.addEventListener('install', function (event) {
  DEV && console.log('[install] Kicking off service worker registration!');
  event.waitUntil(self.skipWaiting());
});

self.addEventListener('fetch', function (event) {
  event.respondWith(caches.match(event.request).then(function (response) {
    // Cache hit - return the response from the cached version
    if (response) {
      DEV && console.log('[fetch] Returning from Service Worker cache: ', event.request.url);
      return response;
    }

    // Not in cache - return the result from the live server
    DEV && console.log('[fetch] Returning from server: ', event.request.url);
    return fetch(event.request);
  }));
});

self.addEventListener('activate', function (event) {
  // Claim the service work for this client, forcing `controllerchange` event
  DEV && console.log('[activate] Claiming this service worker!');

  event.waitUntil(clients.claim().then(function () {
    // After the activation and claiming is complete, send a message to each of the controlled
    // pages letting it know that it's active.
    // This will trigger navigator.serviceWorker.onmessage in each client.
    return self.clients.matchAll().then(function (clients) {
      return Promise.all(clients.map(function (client) {
        return client.postMessage({ msg: 'active' });
      }));
    });
  }));
});

self.addEventListener('message', function (event) {
  DEV && console.log('[msg]', event.data);

  if (event.data.method === "add") {
    var resources = event.data.resources;
    var key = event.data.key || CACHES['resources'];
    if (!key in CACHES) {
      CACHES[key] = key;
    }
    // Open the given cache with the keys
    var added = caches.open(CACHES[key]).then(function (cache) {
      // Process each item in the resources
      var mapped = resources.map(function (item) {
        var href = item.href;
        // Check if the href is already cached
        return cache.match(href).then(function (response) {
          if (!response) {
            // If not found, fetch the resource and store it
            var request = new Request(href, { mode: 'no-cors' });
            return fetch(request).then(function (response) {
              return cache.put(href, response);
            });
          }
        });
      });
      return Promise.all(mapped);
    });

    event.waitUntil(added);
  }

  if (event.data.method === "remove") {}
});

/***/ })

/******/ });
});
//# sourceMappingURL=sw.js.map