import _regeneratorRuntime from "babel-runtime/regenerator";
import _typeof from "babel-runtime/helpers/typeof";
import _asyncToGenerator from "babel-runtime/helpers/asyncToGenerator";

/**
 * Creates a new Book or Book Bridge & Worker
 * @param {string|ArrayBuffer} url URL, Path or ArrayBuffer
 * @param {object} options to pass to the book
 * @returns {Book} a new Book object
 * @example ePub("/path/to/book.epub", {})
 */
var ePub = function () {
	var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(url) {
		var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
		var epub,
		    rendition,
		    _args = arguments;
		return _regeneratorRuntime.wrap(function _callee$(_context) {
			while (1) {
				switch (_context.prev = _context.next) {
					case 0:
						epub = void 0;
						rendition = void 0;

						if (!(_args.length === 0 || _args.length === 1 && _typeof(_args[0]) === "object")) {
							_context.next = 4;
							break;
						}

						return _context.abrupt("return", new (Function.prototype.bind.apply(Epub, [null].concat(Array.prototype.slice.call(_args))))());

					case 4:

						if (options.worker) {
							epub = new EpubBridge(options);
						} else {
							epub = new Epub(options);
						}

						return _context.abrupt("return", epub.open(url).then(function (book) {
							/**
        * Sugar to render a book to an element
        * @param  {element | string} element element or string to add a rendition to
        * @param  {object} [options]
        * @return {Rendition}
        */
							book.renderTo = function (element) {
								var renditionOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};


								if (options && typeof options.worker !== "undefined" && typeof renditionOptions.worker === "undefined") {
									renditionOptions.worker = options.worker;
								}

								rendition = new Rendition(book.manifest, renditionOptions);
								rendition.attachTo(element);

								// If the workers fails, switch to replacements
								rendition.on("workerFailed", function () {
									rendition.clear();
									epub.replacements().then(function (book) {
										rendition.unpack(book.manifest);
										rendition.display(rendition.location);
									});
								});

								return rendition;
							};

							book.generateLocations = function (chars) {
								return epub.generateLocations(chars).then(function (locations) {
									book.locations = locations;
									return locations;
								});
							};

							book._destroy = book.destroy;
							book.destroy = function () {
								book._destroy();
								epub.destroy();
								rendition.destroy();
							};

							// epub.destroy();
							window.Epub = epub;

							return book;
						}));

					case 6:
					case "end":
						return _context.stop();
				}
			}
		}, _callee, this);
	}));

	return function ePub(_x2) {
		return _ref.apply(this, arguments);
	};
}();

import Book from "./book/book";
import Rendition from "./rendition/rendition";
import EpubCFI from "./utils/epubcfi";
import Contents from "./rendition/contents";
import * as core from "./utils/core";
import { EPUBJS_VERSION } from "./utils/constants";
import "../libs/url/url-polyfill";

import IframeView from "./managers/views/iframe";
import DefaultViewManager from "./managers/default/index";
import ContinuousViewManager from "./managers/continuous/index";

import Epub from './epub/epub';
import EpubBridge from './epub/bridge';

ePub.VERSION = EPUBJS_VERSION;

ePub.CFI = EpubCFI;
ePub.Book = Book;
ePub.Rendition = Rendition;
ePub.Contents = Contents;
ePub.utils = core;

ePub.ViewManagers = {};
ePub.Views = {};
/**
 * Register Managers and Views
 */
ePub.register = {
	/**
  * register a new view manager
  */
	manager: function manager(name, _manager) {
		return ePub.ViewManagers[name] = _manager;
	},
	/**
  * register a new view
  */
	view: function view(name, _view) {
		return ePub.Views[name] = _view;
	}
};

// Default Views
ePub.register.view("iframe", IframeView);

// Default View Managers
ePub.register.manager("default", DefaultViewManager);
ePub.register.manager("continuous", ContinuousViewManager);

export default ePub;