import type { Rule } from 'eslint';
import * as prettier from 'prettier';
import type { SFCBlocksOptions } from './utils/parse-vue';
export interface PrettierVuePluginOptions {
    /**
     * Options of prettier itself
     */
    prettierOptions: prettier.Options;
    /**
     * Use the options in .prettierrc file or not
     */
    usePrettierrc: boolean;
    /**
     * The fileInfoOptions of prettier
     */
    fileInfoOptions: prettier.FileInfoOptions;
    /**
     * Options for how to process vue SFC blocks
     */
    SFCBlocksOptions: SFCBlocksOptions;
}
export declare const create: Rule.RuleModule['create'];
