"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.meta = void 0;
exports.meta = {
    type: 'layout',
    docs: {
        description: 'Make your code prettier',
        recommended: true,
        url: 'https://github.com/meteorlxy/eslint-plugin-prettier-vue#eslint-config',
    },
    fixable: 'code',
    schema: [
        /**
         * Prettier options
         *
         * @see https://prettier.io/docs/en/options.html
         */
        {
            type: 'object',
            properties: {
                printWidth: {
                    type: 'integer',
                },
                tabWidth: {
                    type: 'integer',
                },
                useTabs: {
                    type: 'boolean',
                },
                semi: {
                    type: 'boolean',
                },
                singleQuote: {
                    type: 'boolean',
                },
                quoteProps: {
                    type: 'string',
                    enum: ['as-needed', 'consistent', 'preserve'],
                },
                jsxSingleQuote: {
                    type: 'boolean',
                },
                trailingComma: {
                    type: 'string',
                    enum: ['none', 'es5', 'all'],
                },
                bracketSpacing: {
                    type: 'boolean',
                },
                bracketSameLine: {
                    type: 'boolean',
                },
                arrowParens: {
                    type: 'string',
                    enum: ['avoid', 'always'],
                },
                rangeStart: {
                    type: 'integer',
                },
                rangeEnd: {
                    type: 'integer',
                },
                parser: {
                    type: ['string', 'object'],
                },
                filepath: {
                    type: 'string',
                },
                requirePragma: {
                    type: 'boolean',
                },
                insertPragma: {
                    type: 'boolean',
                },
                proseWrap: {
                    type: 'string',
                    enum: ['always', 'never', 'preserve'],
                },
                htmlWhitespaceSensitivity: {
                    type: 'string',
                    enum: ['css', 'strict', 'ignore'],
                },
                vueIndentScriptAndStyle: {
                    type: 'boolean',
                },
                endOfLine: {
                    type: 'string',
                    enum: ['auto', 'lf', 'crlf', 'cr'],
                },
                embeddedLanguageFormatting: {
                    type: 'string',
                    enum: ['auto', 'off'],
                },
                singleAttributePerLine: {
                    type: 'boolean',
                },
            },
            additionalProperties: true,
        },
    ],
};
