import createLoader from 'create-esm-loader';
import { extname } from 'node:path';
import semver from 'semver';
const NAME = 'esm-loader-css';
const extensions = [
    '.css',
    '.less',
    '.pcss',
    '.postcss',
    '.sass',
    '.scss',
    '.sss',
    '.styl', // Stylus
];
const isCSS = (pathname) => extensions.some((extension) => extension === extname(pathname));
// create-esm-loader config
const config = {
    resolve: (specifier, options) => {
        const { debug, parentURL } = options;
        const { href, pathname } = new URL(specifier, parentURL);
        if (!isCSS(pathname))
            return undefined;
        if (debug)
            console.log(`[${NAME}] resolve: ${specifier}`);
        return {
            format: semver.gte(process.versions.node, '16.12.0')
                ? 'module' // node>=16.12
                : undefined,
            url: href,
        };
    },
    format: (url, options) => {
        const { debug } = options;
        const { pathname } = new URL(url);
        if (semver.gte(process.versions.node, '16.12.0'))
            return undefined;
        // node<16.12
        if (!isCSS(pathname))
            return undefined;
        if (debug)
            console.log(`[${NAME}] format: ${url}`);
        return { format: 'module' };
    },
    transform: (source, options) => {
        const { debug, url } = options;
        const { pathname } = new URL(url);
        if (!isCSS(pathname))
            return undefined;
        if (debug)
            console.log(`[${NAME}] transform: ${url}`);
        const result = `export default ${JSON.stringify(String(source))}`;
        return { source: result };
    },
};
export default config;
// node loader
export const { resolve, load, getFormat, // node<16.12
getSource, // node<16.12
transformSource, // node<16.12
 } = await createLoader(config);
