export namespace jsx {
    export { jsxAttribute as JSXAttribute };
    export { jsxClosingElement as JSXClosingElement };
    export { jsxClosingFragment as JSXClosingFragment };
    export { jsxElement as JSXElement };
    export { jsxEmptyExpression as JSXEmptyExpression };
    export { jsxExpressionContainer as JSXExpressionContainer };
    export { jsxFragment as JSXFragment };
    export { jsxIdentifier as JSXIdentifier };
    export { jsxMemberExpression as JSXMemberExpression };
    export { jsxNamespacedName as JSXNamespacedName };
    export { jsxOpeningElement as JSXOpeningElement };
    export { jsxOpeningFragment as JSXOpeningFragment };
    export { jsxSpreadAttribute as JSXSpreadAttribute };
    export { jsxText as JSXText };
}
export type JsxAttribute = import('estree-jsx').JSXAttribute;
export type JsxClosingElement = import('estree-jsx').JSXClosingElement;
export type JsxClosingFragment = import('estree-jsx').JSXClosingFragment;
export type JsxElement = import('estree-jsx').JSXElement;
export type JsxExpressionContainer = import('estree-jsx').JSXExpressionContainer;
export type JsxFragment = import('estree-jsx').JSXFragment;
export type JsxIdentifier = import('estree-jsx').JSXIdentifier;
export type JsxMemberExpression = import('estree-jsx').JSXMemberExpression;
export type JsxNamespacedName = import('estree-jsx').JSXNamespacedName;
export type JsxOpeningElement = import('estree-jsx').JSXOpeningElement;
export type JsxOpeningFragment = import('estree-jsx').JSXOpeningFragment;
export type JsxSpreadAttribute = import('estree-jsx').JSXSpreadAttribute;
export type JsxText = import('estree-jsx').JSXText;
export type Generator = import('./index.js').Generator;
export type State = import('./index.js').State;
/**
 * `attr`
 * `attr="something"`
 * `attr={1}`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxAttribute} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxAttribute(this: import("./index.js").Generator, node: JsxAttribute, state: State): undefined;
/**
 * `</div>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxClosingElement} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxClosingElement(this: import("./index.js").Generator, node: JsxClosingElement, state: State): undefined;
/**
 * `</>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxClosingFragment} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxClosingFragment(this: import("./index.js").Generator, node: JsxClosingFragment, state: State): undefined;
/**
 * `<div />`
 * `<div></div>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxElement} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxElement(this: import("./index.js").Generator, node: JsxElement, state: State): undefined;
/**
 * `{}` (always in a `JSXExpressionContainer`, which does the curlies)
 *
 * @this {Generator}
 *   `astring` generator.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxEmptyExpression(this: import("./index.js").Generator): undefined;
/**
 * `{expression}`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxExpressionContainer} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxExpressionContainer(this: import("./index.js").Generator, node: JsxExpressionContainer, state: State): undefined;
/**
 * `<></>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxFragment} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxFragment(this: import("./index.js").Generator, node: JsxFragment, state: State): undefined;
/**
 * `div`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxIdentifier} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxIdentifier(this: import("./index.js").Generator, node: JsxIdentifier, state: State): undefined;
/**
 * `member.expression`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxMemberExpression} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxMemberExpression(this: import("./index.js").Generator, node: JsxMemberExpression, state: State): undefined;
/**
 * `ns:name`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxNamespacedName} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxNamespacedName(this: import("./index.js").Generator, node: JsxNamespacedName, state: State): undefined;
/**
 * `<div>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxOpeningElement} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxOpeningElement(this: import("./index.js").Generator, node: JsxOpeningElement, state: State): undefined;
/**
 * `<>`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxOpeningFragment} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxOpeningFragment(this: import("./index.js").Generator, node: JsxOpeningFragment, state: State): undefined;
/**
 * `{...argument}`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxSpreadAttribute} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxSpreadAttribute(this: import("./index.js").Generator, node: JsxSpreadAttribute, state: State): undefined;
/**
 * `!`
 *
 * @this {Generator}
 *   `astring` generator.
 * @param {JsxText} node
 *   Node to serialize.
 * @param {State} state
 *   Info passed around.
 * @returns {undefined}
 *   Nothing.
 */
declare function jsxText(this: import("./index.js").Generator, node: JsxText, state: State): undefined;
export {};
